/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import java.util.Set;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.InstanceModeConstraint;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;

public record ServerDetails(ServerId serverId, String name, Optional<SocketAddress> boltAddress, Optional<SocketAddress> httpAddress, Optional<SocketAddress> httpsAddress, Set<String> tags, State state, RunningState runningState, Set<String> hostedDatabases, Set<String> desiredDatabases, Set<String> allowedDatabases, Set<String> deniedDatabases, InstanceModeConstraint modeConstraint, Optional<String> neo4jVersion) {

    public static enum State {
        FREE("Free"),
        ENABLED("Enabled"),
        CORDONED("Cordoned"),
        DEALLOCATING("Deallocating"),
        DEALLOCATED("Deallocated"),
        DROPPED("Dropped");

        private final String prettyPrint;

        private State(String prettyPrint) {
            this.prettyPrint = prettyPrint;
        }

        public String prettyPrint() {
            return this.prettyPrint;
        }

        public static State fromInstanceStatus(TopologyGraphDbmsModel.InstanceStatus status) {
            return switch (status) {
                default -> throw new MatchException(null, null);
                case TopologyGraphDbmsModel.InstanceStatus.ENABLED -> ENABLED;
                case TopologyGraphDbmsModel.InstanceStatus.CORDONED -> CORDONED;
                case TopologyGraphDbmsModel.InstanceStatus.DEALLOCATING -> DEALLOCATING;
            };
        }
    }

    public static enum RunningState {
        AVAILABLE("Available"),
        INITIALIZING("Initializing"),
        STARTING_DATABASES("Starting databases"),
        SHUTTING_DOWN("Shutting down"),
        PANICKED("Panicked"),
        UNAVAILABLE("Unavailable");

        private final String prettyPrint;

        private RunningState(String prettyPrint) {
            this.prettyPrint = prettyPrint;
        }

        public String prettyPrint() {
            return this.prettyPrint;
        }
    }
}

