/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import com.github.luben.zstd.util.Native;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.neo4j.dbms.archive.CompressionFormat;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.IOUtils;

public enum StandardCompressionFormat implements CompressionFormat
{
    GZIP{

        @Override
        public OutputStream compress(OutputStream stream) throws IOException {
            return new GZIPOutputStream(stream);
        }

        @Override
        public InputStream decompress(InputStream stream) throws IOException {
            return new GZIPInputStream(stream);
        }
    }
    ,
    ZSTD{
        private final byte[] HEADER = new byte[]{122, 115, 116, 100};

        @Override
        public OutputStream compress(OutputStream stream) throws IOException {
            ZstdOutputStreamNoFinalizer zstdout = new ZstdOutputStreamNoFinalizer(stream);
            try {
                zstdout.setChecksum(true);
                if (Runtime.getRuntime().availableProcessors() > 2) {
                    zstdout.setWorkers(Runtime.getRuntime().availableProcessors());
                }
                zstdout.write(this.HEADER);
                return zstdout;
            }
            catch (IOException e) {
                zstdout.close();
                throw e;
            }
        }

        @Override
        public InputStream decompress(InputStream stream) throws IOException {
            ZstdInputStreamNoFinalizer zstdin = new ZstdInputStreamNoFinalizer(stream);
            try {
                byte[] header = new byte[this.HEADER.length];
                if (zstdin.read(header) != this.HEADER.length || !Arrays.equals(header, this.HEADER)) {
                    throw new IOException("Not in ZSTD format");
                }
                return zstdin;
            }
            catch (IOException e) {
                zstdin.close();
                throw e;
            }
        }
    };


    public boolean isFormat(InputStream stream) {
        return this == ZSTD && stream instanceof ZstdInputStreamNoFinalizer || this == GZIP && stream instanceof GZIPInputStream;
    }

    public boolean isFormat(OutputStream stream) {
        return this == ZSTD && stream instanceof ZstdOutputStreamNoFinalizer || this == GZIP && stream instanceof GZIPOutputStream;
    }

    public static OutputStream compress(ThrowingSupplier<OutputStream, IOException> streamSupplier, CompressionFormat format) throws IOException {
        OutputStream sink = (OutputStream)streamSupplier.get();
        try {
            return new BufferedOutputStream(format.compress(sink));
        }
        catch (IOException ioe) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{sink});
            throw ioe;
        }
    }

    public static InputStream decompress(ThrowingSupplier<InputStream, IOException> streamSupplier) throws IOException {
        if (StandardCompressionFormat.selectCompressionFormat().equals(ZSTD)) {
            try {
                return StandardCompressionFormat.decompress(streamSupplier, ZSTD);
            }
            catch (IOException zstdIOe) {
                try {
                    return StandardCompressionFormat.decompress(streamSupplier, GZIP);
                }
                catch (IOException gzipIOe) {
                    throw (IOException)Exceptions.chain((Throwable)zstdIOe, (Throwable)gzipIOe);
                }
            }
        }
        return StandardCompressionFormat.decompress(streamSupplier, GZIP);
    }

    private static InputStream decompress(ThrowingSupplier<InputStream, IOException> streamSupplier, CompressionFormat format) throws IOException {
        InputStream source = (InputStream)streamSupplier.get();
        try {
            return format.decompress(source);
        }
        catch (IOException ioe) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{source});
            throw ioe;
        }
    }

    public static StandardCompressionFormat selectCompressionFormat() {
        return StandardCompressionFormat.selectCompressionFormat(null);
    }

    public static StandardCompressionFormat selectCompressionFormat(PrintStream output) {
        block3: {
            try {
                Native.load();
                if (Native.isLoaded()) {
                    return ZSTD;
                }
            }
            catch (Throwable t) {
                if (output == null) break block3;
                output.println("Failed to load " + ZSTD.name() + ": " + t.getMessage());
                output.println("Fallback to " + GZIP.name());
            }
        }
        return GZIP;
    }
}

