/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.logging.InternalLog;

class ApocSettingsMigrator {
    private final Map<String, String> rawConfig;
    private final List<String> apocKeys;
    private final PrintStream out;
    private final Path destinationConfigFile;

    ApocSettingsMigrator(PrintStream out, Path destinationConfigFile, Map<String, String> rawConfig, List<String> apocKeys) {
        this.out = out;
        this.destinationConfigFile = destinationConfigFile;
        this.rawConfig = rawConfig;
        this.apocKeys = apocKeys;
    }

    static boolean isApocSetting(String keyString) {
        return keyString.startsWith("apoc.");
    }

    public void migrate() throws IOException {
        Path apocConfig = this.destinationConfigFile.resolveSibling("apoc.conf");
        this.preserveOriginal(apocConfig);
        StringBuilder sb = new StringBuilder();
        for (String key : this.apocKeys) {
            String value = this.rawConfig.get(key);
            if (value == null) continue;
            sb.append(key);
            sb.append('=');
            sb.append(value);
            sb.append(System.lineSeparator());
        }
        Files.writeString(apocConfig, (CharSequence)sb.toString(), new OpenOption[0]);
        this.out.println("APOC settings moved to separate file: " + String.valueOf(apocConfig));
    }

    private void preserveOriginal(Path configFile) throws IOException {
        if (Files.exists(configFile, new LinkOption[0])) {
            Path preservedFilePath = configFile.getParent().resolve(String.valueOf(configFile.getFileName()) + ".old");
            this.out.println("Keeping original " + String.valueOf(configFile.getFileName()) + " file at: " + String.valueOf(preservedFilePath));
            Files.move(configFile, preservedFilePath, new CopyOption[0]);
        }
    }

    static class ApocSettingRemover
    implements SettingMigrator {
        static ApocSettingRemover INSTANCE = new ApocSettingRemover();

        private ApocSettingRemover() {
        }

        public void migrate(Map<String, String> values, Map<String, String> defaultValues, InternalLog log) {
            List<String> apocSettings = values.keySet().stream().filter(ApocSettingsMigrator::isApocSetting).toList();
            for (String apocSetting : apocSettings) {
                values.remove(apocSetting);
            }
        }
    }
}

