/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.internal.collector.RecentBuffer;

public class ConcurrentLinkedQueueRecentBuffer<T>
implements RecentBuffer<T> {
    private final ConcurrentLinkedQueue<T> queue;
    private final int maxSize;
    private final AtomicInteger size;

    public ConcurrentLinkedQueueRecentBuffer(int maxSize) {
        this.maxSize = maxSize;
        this.queue = new ConcurrentLinkedQueue();
        this.size = new AtomicInteger(0);
    }

    @Override
    public void produce(T t) {
        this.queue.add(t);
        int newSize = this.size.incrementAndGet();
        if (newSize > this.maxSize) {
            this.queue.poll();
            this.size.decrementAndGet();
        }
    }

    @Override
    public void clearIf(Predicate<T> predicate) {
        MutableInt removeCount = new MutableInt(0);
        this.queue.removeIf(q -> {
            if (predicate.test(q)) {
                removeCount.increment();
                return true;
            }
            return false;
        });
        this.size.addAndGet(-removeCount.intValue());
    }

    @Override
    public void foreach(Consumer<T> consumer) {
        this.queue.forEach(consumer);
    }
}

