/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Closeable;
import java.io.Serializable;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.cypher.internal.CachingPreParser;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r5f!B\u00193\u0003\u0003Y\u0004\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011A&\t\u0011I\u0003!\u0011!Q\u0001\n1C\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t7\u0002\u0011\t\u0011)A\u0005+\"AA\f\u0001BC\u0002\u0013\u0005Q\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003_\u0011!)\u0007A!b\u0001\n\u00031\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u00115\u0004!Q1A\u0005\u00029D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\ti\u0002\u0011)\u0019!C\u0001k\"AA\u0010\u0001B\u0001B\u0003%a\u000f\u0003\u0005~\u0001\t\u0015\r\u0011\"\u0001\u007f\u0011%\tY\u0001\u0001B\u0001B\u0003%q\u0010\u0003\u0006\u0002\u000e\u0001\u0011)\u0019!C\u0001\u0003\u001fA!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011\u001d\ty\u0002\u0001C\u0001\u0003CA\u0011\"!\u000e\u0001\u0005\u0004%\t\"a\u000e\t\u0011\u0005%\u0003\u0001)A\u0005\u0003sA\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001fB\u0011\"a\u0016\u0001\u0005\u0004%I!!\u0017\t\u0011\u0005]\u0005\u0001)A\u0005\u00037B\u0011\"!'\u0001\u0005\u0004%I!a'\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003;Cq!!*\u0001\t\u0003\t9\u000bC\u0005\u0003\u0002\u0001\t\n\u0011\"\u0001\u0003\u0004!9\u0011Q\u0015\u0001\u0005\u0002\te\u0001b\u0002B \u0001\u0011\u0005!\u0011\t\u0005\n\u0005+\u0002\u0011\u0013!C\u0001\u0005\u0007AqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003\u0018\u0002!IA!'\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!1\u001e\u0001\u0005\n\t5\bb\u0002B~\u0001\u0011\u0005!Q \u0005\b\u0007\u000b\u0001A\u0011\u0001B\u007f\u0011\u001d\u00199\u0001\u0001C\u0001\u0005{Dqa!\u0003\u0001\t\u0003\u0011i\u0010C\u0004\u0004\f\u0001!\ta!\u0004\t\u000f\r%\u0003\u0001\"\u0001\u0004L!91Q\f\u0001\u0005B\r}\u0003bBB1\u0001\u0011%11M\u0004\b\u0007\u001b\u0013\u0004\u0012ABH\r\u0019\t$\u0007#\u0001\u0004\u0012\"9\u0011q\u0004\u0017\u0005\u0002\re\u0005\"CBNY\t\u0007I\u0011ABO\u0011!\u0019)\u000b\fQ\u0001\n\r}\u0005\"CBTYE\u0005I\u0011ABU\u0005=)\u00050Z2vi&|g.\u00128hS:,'BA\u001a5\u0003!Ig\u000e^3s]\u0006d'BA\u001b7\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0007O\u0001\u0006]\u0016|GG\u001b\u0006\u0002s\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0010#\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015\u0001\u00027b]\u001eT\u0011!Q\u0001\u0005U\u00064\u0018-\u0003\u0002D}\t1qJ\u00196fGR\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012!\u0002\u0005%|\u0017BA%G\u0005%\u0019En\\:fC\ndW-\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001M!\ti\u0005+D\u0001O\u0015\tye'\u0001\u0004lKJtW\r\\\u0005\u0003#:\u0013\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\u0006i\u0011/^3ssN+'O^5dK\u0002\nab[3s]\u0016dWj\u001c8ji>\u00148/F\u0001V!\t1\u0016,D\u0001X\u0015\tAf'\u0001\u0006n_:LGo\u001c:j]\u001eL!AW,\u0003\u00115{g.\u001b;peN\fqb[3s]\u0016dWj\u001c8ji>\u00148\u000fI\u0001\u0007iJ\f7-\u001a:\u0016\u0003y\u0003\"a\u00182\u000e\u0003\u0001T!!\u0019\u001a\u0002\u000fQ\u0014\u0018mY5oO&\u00111\r\u0019\u0002\u0012\u0007>l\u0007/\u001b7bi&|g\u000e\u0016:bG\u0016\u0014\u0018a\u0002;sC\u000e,'\u000fI\u0001\u0007G>tg-[4\u0016\u0003\u001d\u0004\"\u0001\u001b6\u000e\u0003%T!!\u001a\u001a\n\u0005-L'aE\"za\",'oQ8oM&<WO]1uS>t\u0017aB2p]\u001aLw\rI\u0001\u000f[\u0006\u001cH/\u001a:D_6\u0004\u0018\u000e\\3s+\u0005y\u0007C\u00019r\u001b\u0005\u0011\u0014B\u0001:3\u00059i\u0015m\u001d;fe\u000e{W\u000e]5mKJ\fq\"\\1ti\u0016\u00148i\\7qS2,'\u000fI\u0001\fcV,'/_\"bG\",7/F\u0001w!\t9(0D\u0001y\u0015\tI('A\u0003dC\u000eDW-\u0003\u0002|q\n\t2)\u001f9iKJ\fV/\u001a:z\u0007\u0006\u001c\u0007.Z:\u0002\u0019E,XM]=DC\u000eDWm\u001d\u0011\u0002\u00171|w\r\u0015:pm&$WM]\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006Y\nq\u0001\\8hO&tw-\u0003\u0003\u0002\n\u0005\r!aE%oi\u0016\u0014h.\u00197M_\u001e\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u00047pOB\u0013xN^5eKJ\u0004\u0013!B2m_\u000e\\WCAA\t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\u0001\u0006!A/[7f\u0013\u0011\tY\"!\u0006\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003\u0019a\u0014N\\5u}Q\u0011\u00121EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a!\t\u0001\b\u0001C\u0003K#\u0001\u0007A\nC\u0003T#\u0001\u0007Q\u000bC\u0003]#\u0001\u0007a\fC\u0003f#\u0001\u0007q\rC\u0003n#\u0001\u0007q\u000eC\u0003u#\u0001\u0007a\u000fC\u0003~#\u0001\u0007q\u0010C\u0005\u0002\u000eE\u0001\n\u00111\u0001\u0002\u0012\u0005aB-\u001a4bk2$\u0018+^3ss\u0016CXmY;uS>tWj\u001c8ji>\u0014XCAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nQ!];fefT1!a\u0011O\u0003\u0011IW\u000e\u001d7\n\t\u0005\u001d\u0013Q\b\u0002\u0016#V,'/_#yK\u000e,H/[8o\u001b>t\u0017\u000e^8s\u0003u!WMZ1vYR\fV/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J\u0004\u0013!\u00039sKB\u000b'o]3s+\t\ty\u0005E\u0002q\u0003#J1!a\u00153\u0005A\u0019\u0015m\u00195j]\u001e\u0004&/\u001a)beN,'/\u0001\u0006qe\u0016\u0004\u0016M]:fe\u0002\n!\"];fef\u001c\u0015m\u00195f+\t\tY\u0006E\u0004q\u0003;\n\t'!%\n\u0007\u0005}#G\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016\u0004b!a\u0019\u0002\u0000\u0005\u0015e\u0002BA3\u0003wrA!a\u001a\u0002z9!\u0011\u0011NA<\u001d\u0011\tY'!\u001e\u000f\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d;\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u00028q%\u0011QGN\u0005\u0003gQJ1!! 3\u0003)\tV/\u001a:z\u0007\u0006\u001c\u0007.Z\u0005\u0005\u0003\u0003\u000b\u0019I\u0001\u0005DC\u000eDWmS3z\u0015\r\tiH\r\t\u0005\u0003\u000f\u000biID\u0002q\u0003\u0013K1!a#3\u0003)Ie\u000e];u#V,'/_\u0005\u0005\u0003\u0003\u000byIC\u0002\u0002\fJ\u00022\u0001]AJ\u0013\r\t)J\r\u0002\u0010\u000bb,7-\u001e;bE2,\u0017+^3ss\u0006Y\u0011/^3ss\u000e\u000b7\r[3!\u00031\u00198\r[3nC\"+G\u000e]3s+\t\ti\nE\u0002q\u0003?K1!!)3\u00051\u00196\r[3nC\"+G\u000e]3s\u00035\u00198\r[3nC\"+G\u000e]3sA\u00059Q\r_3dkR,G\u0003EAU\u0003_\u000b)-!7\u0002d\u0006=\u00181_A\u007f!\u0011\tY$a+\n\t\u00055\u0016Q\b\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u001d\tyD\u0007a\u0001\u0003c\u0003B!a-\u0002@:!\u0011QWA^!\u0011\ti'a.\u000b\u0005\u0005e\u0016!B:dC2\f\u0017\u0002BA_\u0003o\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAa\u0003\u0007\u0014aa\u0015;sS:<'\u0002BA_\u0003oCq!a2\u001b\u0001\u0004\tI-\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003\u001d1\u0018N\u001d;vC2T1!a57\u0003\u00191\u0018\r\\;fg&!\u0011q[Ag\u0005!i\u0015\r\u001d,bYV,\u0007bBAn5\u0001\u0007\u0011Q\\\u0001\bG>tG/\u001a=u!\u0011\tY$a8\n\t\u0005\u0005\u0018Q\b\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\u000f\u0005\u0015(\u00041\u0001\u0002h\u00069\u0001O]8gS2,\u0007\u0003BAu\u0003Wl!!a.\n\t\u00055\u0018q\u0017\u0002\b\u0005>|G.Z1o\u0011\u001d\t\tP\u0007a\u0001\u0003O\f1\u0002\u001d:f!>\u0004X\u000f\\1uK\"9\u0011Q\u001f\u000eA\u0002\u0005]\u0018AC:vEN\u001c'/\u001b2feB!\u00111HA}\u0013\u0011\tY0!\u0010\u0003\u001fE+XM]=Tk\n\u001c8M]5cKJD\u0011\"a@\u001b!\u0003\u0005\r!!\u000f\u0002\u000f5|g.\u001b;pe\u0006\tR\r_3dkR,G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t\u0015!\u0006BA\u001d\u0005\u000fY#A!\u0003\u0011\t\t-!QC\u0007\u0003\u0005\u001bQAAa\u0004\u0003\u0012\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005'\t9,\u0001\u0006b]:|G/\u0019;j_:LAAa\u0006\u0003\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015!\u0005%&1\u0004B\u0012\u0005K\u00119C!\u000b\u0003:\tu\u0002bBA 9\u0001\u0007!Q\u0004\t\u0004a\n}\u0011b\u0001B\u0011e\t\u0001b)\u001e7msB\u000b'o]3e#V,'/\u001f\u0005\b\u0003\u000fd\u0002\u0019AAe\u0011\u001d\tY\u000e\ba\u0001\u0003;Dq!!=\u001d\u0001\u0004\t9\u000fC\u0004\u0003,q\u0001\rA!\f\u0002\u000b%t\u0007/\u001e;\u0011\t\t=\"QG\u0007\u0003\u0005cQ1Aa\r3\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u000e\u00032\ty\u0011J\u001c9vi\u0012\u000bG/Y*ue\u0016\fW\u000eC\u0004\u0003<q\u0001\r!!\u000f\u0002\u0019E,XM]=N_:LGo\u001c:\t\u000f\u0005UH\u00041\u0001\u0002x\u0006yQ\r_3dkR,7+\u001e2rk\u0016\u0014\u0018\u0010\u0006\n\u0002*\n\r#Q\tB$\u0005\u0013\u0012iEa\u0014\u0003R\tM\u0003bBA ;\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003\u000fl\u0002\u0019AAe\u0011\u001d\tY.\ba\u0001\u0003;DqAa\u0013\u001e\u0001\u0004\t9/\u0001\tjg>+H/\u001a:n_N$\u0018+^3ss\"9\u0011Q]\u000fA\u0002\u0005\u001d\bbBAy;\u0001\u0007\u0011q\u001d\u0005\b\u0003kl\u0002\u0019AA|\u0011%\ty0\bI\u0001\u0002\u0004\tI$A\rfq\u0016\u001cW\u000f^3Tk\n\fX/\u001a:zI\u0011,g-Y;mi\u0012B\u0014aB2m_NLgnZ\u000b\u0005\u00057\u0012\u0019\u0007\u0006\u0004\u0003^\t}$\u0011\u0011\u000b\u0005\u0005?\u0012)\b\u0005\u0003\u0003b\t\rD\u0002\u0001\u0003\b\u0005Kz\"\u0019\u0001B4\u0005\u0005!\u0016\u0003\u0002B5\u0005_\u0002B!!;\u0003l%!!QNA\\\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!;\u0003r%!!1OA\\\u0005\r\te.\u001f\u0005\t\u0005ozB\u00111\u0001\u0003z\u0005!1m\u001c3f!\u0019\tIOa\u001f\u0003`%!!QPA\\\u0005!a$-\u001f8b[\u0016t\u0004bBAn?\u0001\u0007\u0011Q\u001c\u0005\b\u0005\u0007{\u0002\u0019\u0001BC\u0003)!(/Y2f\u000bZ,g\u000e\u001e\t\u0005\u0005\u000f\u0013\tJ\u0004\u0003\u0003\n\n5e\u0002BA3\u0005\u0017K!!\u0019\u001a\n\u0007\t=\u0005-A\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJLAAa%\u0003\u0016\n)\u0012+^3ss\u000e{W\u000e]5mCRLwN\\#wK:$(b\u0001BHA\u0006IAm\\#yK\u000e,H/\u001a\u000b\u0017\u0003S\u0013YJa)\u0003&\n\u001d&\u0011\u0016BV\u0005[\u0013yK!-\u00034\"9\u0011q\b\u0011A\u0002\tu\u0005c\u00019\u0003 &\u0019!\u0011\u0015\u001a\u0003\u0015%s\u0007/\u001e;Rk\u0016\u0014\u0018\u0010C\u0004\u0002H\u0002\u0002\r!!3\t\u000f\u0005m\u0007\u00051\u0001\u0002^\"9!1\n\u0011A\u0002\u0005\u001d\bbBAyA\u0001\u0007\u0011q\u001d\u0005\b\u0005W\u0001\u0003\u0019\u0001B\u0017\u0011\u001d\u0011Y\u0004\ta\u0001\u0003sAa\u0001\u0018\u0011A\u0002\t\u0015\u0005bBA{A\u0001\u0007\u0011q\u001f\u0005\b\u0005k\u0003\u0003\u0019\u0001B\\\u0003Iqw\u000e^5gS\u000e\fG/[8o\u0019><w-\u001a:\u0011\t\te&qX\u0007\u0003\u0005wS1A!03\u0003\u0011)H/\u001b7\n\t\t\u0005'1\u0018\u0002\u001b\u0013:$XM\u001d8bY:{G/\u001b4jG\u0006$\u0018n\u001c8M_\u001e<WM]\u0001$G>l\u0007/\u001b7fe^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]>\u0003H/[8o)9\u00119M!4\u0003R\nM'q\u001bBm\u00057\u0004R\u0001\u001dBe\u0003#K1Aa33\u0005\r\u001au.\u001c9jY\u0016\u0014x+\u001b;i\u000bb\u0004(/Z:tS>t7i\u001c3f\u000f\u0016tw\n\u001d;j_:DqAa4\"\u0001\u0004\u0011i*\u0001\u0006j]B,H/U;fefDa\u0001X\u0011A\u0002\t\u0015\u0005b\u0002BkC\u0001\u0007\u0011Q\\\u0001\u0015iJ\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\u000f\u0005\u001d\u0017\u00051\u0001\u0002J\"9!QW\u0011A\u0002\t]\u0006b\u0002BoC\u0001\u0007!q\\\u0001\u0010g\u0016\u001c8/[8o\t\u0006$\u0018MY1tKB!!\u0011\u001dBt\u001b\t\u0011\u0019OC\u0002\u0003f:\u000b\u0001\u0002Z1uC\n\f7/Z\u0005\u0005\u0005S\u0014\u0019OA\tECR\f'-Y:f%\u00164WM]3oG\u0016\fAbZ3u\u001fJ\u001cu.\u001c9jY\u0016$B\"!%\u0003p\nE(Q\u001fB|\u0005sDq!a7#\u0001\u0004\ti\u000eC\u0004\u0003t\n\u0002\rA!(\u0002#%t\u0017\u000e^5bY&s\u0007/\u001e;Rk\u0016\u0014\u0018\u0010\u0003\u0004]E\u0001\u0007!Q\u0011\u0005\b\u0003\u000f\u0014\u0003\u0019AAe\u0011\u001d\u0011)L\ta\u0001\u0005o\u000b\u0001c\u00197fCJ\fV/\u001a:z\u0007\u0006\u001c\u0007.Z:\u0015\u0005\t}\b\u0003BAu\u0007\u0003IAaa\u0001\u00028\n!Aj\u001c8h\u0003M\u0019G.Z1s!J,\u0007+\u0019:tKJ\u001c\u0015m\u00195f\u0003e\u0019G.Z1s\u000bb,7-\u001e;bE2,\u0017+^3ss\u000e\u000b7\r[3\u0002'\rdW-\u0019:D_6\u0004\u0018\u000e\\3s\u0007\u0006\u001c\u0007.Z:\u0002\u001f%t7/\u001a:u\u0013:$xnQ1dQ\u0016$Bba\u0004\u0004\u0016\re11EB\u0013\u0007s\u0001B!!;\u0004\u0012%!11CA\\\u0005\u0011)f.\u001b;\t\u000f\r]q\u00051\u0001\u00022\u0006I\u0011/^3ssR+\u0007\u0010\u001e\u0005\b\u000779\u0003\u0019AB\u000f\u00039\u0001(/\u001a)beN,G-U;fef\u00042\u0001]B\u0010\u0013\r\u0019\tC\r\u0002\u000f!J,\u0007+\u0019:tK\u0012\fV/\u001a:z\u0011\u001d\t9m\na\u0001\u0003\u0013Dqaa\n(\u0001\u0004\u0019I#A\u0006qCJ\u001cX\rZ)vKJL\b\u0003BB\u0016\u0007ki!a!\f\u000b\t\r=2\u0011G\u0001\u0007a\"\f7/Z:\u000b\u0007\rM\"'\u0001\u0005ge>tG/\u001a8e\u0013\u0011\u00199d!\f\u0003\u0013\t\u000b7/Z*uCR,\u0007bBB\u001eO\u0001\u00071QH\u0001\u0015a\u0006\u00148/\u001b8h\u001d>$\u0018NZ5dCRLwN\\:\u0011\r\u0005M6qHB\"\u0013\u0011\u0019\t%a1\u0003\u0007M+G\u000f\u0005\u0003\u0003:\u000e\u0015\u0013\u0002BB$\u0005w\u0013A#\u00138uKJt\u0017\r\u001c(pi&4\u0017nY1uS>t\u0017AE4fi\u000eK\b\u000f[3s\rVt7\r^5p]N,\"a!\u0014\u0011\r\r=31KB,\u001b\t\u0019\tFC\u0002\u0003>\u0002KAa!\u0016\u0004R\t!A*[:u!\u0011\tYd!\u0017\n\t\rm\u0013Q\b\u0002\u0014\rVt7\r^5p]&sgm\u001c:nCRLwN\\\u0001\u0006G2|7/\u001a\u000b\u0003\u0007\u001f\tqb\u00195fG.\u0004\u0016M]1nKR,'o\u001d\u000b\t\u0007\u001f\u0019)ga\u001c\u0004t!91q\r\u0016A\u0002\r%\u0014aC9vKJL\b+\u0019:b[N\u0004b!!;\u0004l\u0005E\u0016\u0002BB7\u0003o\u0013Q!\u0011:sCfDqa!\u001d+\u0001\u0004\tI-A\u0006hSZ,g\u000eU1sC6\u001c\bbBB;U\u0001\u0007\u0011\u0011Z\u0001\u0010Kb$(/Y2uK\u0012\u0004\u0016M]1ng\"*!f!\u001f\u0004\fB1\u0011\u0011^B>\u0007\u007fJAa! \u00028\n1A\u000f\u001b:poN\u0004Ba!!\u0004\b6\u001111\u0011\u0006\u0004\u0007\u000b3\u0014AC3yG\u0016\u0004H/[8og&!1\u0011RBB\u0005i\u0001\u0016M]1nKR,'OT8u\r>,h\u000eZ#yG\u0016\u0004H/[8oG\t\u0019y(A\bFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f!\t\u0001HfE\u0002-\u0007'\u0003B!!;\u0004\u0016&!1qSA\\\u0005\u0019\te.\u001f*fMR\u00111qR\u0001\u0014!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUiU\u000b\u0003\u0007?\u0003B!!;\u0004\"&!11UA\\\u0005\rIe\u000e^\u0001\u0015!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUi\u0015\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019YK\u000b\u0003\u0002\u0012\t\u001d\u0001")
public abstract class ExecutionEngine
implements Closeable {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CypherConfiguration config;
    private final MasterCompiler masterCompiler;
    private final CypherQueryCaches queryCaches;
    private final InternalLogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final CachingPreParser preParser;
    private final QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    public CypherQueryCaches queryCaches() {
        return this.queryCaches;
    }

    public InternalLogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    public QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private CachingPreParser preParser() {
        return this.preParser;
    }

    private QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        monitor.startProcessing(context.executingQuery());
        return this.executeSubquery(query, params, context, true, profile, prePopulate, subscriber, monitor);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger));
    }

    public QueryExecutionMonitor execute$default$7() {
        return this.defaultQueryExecutionMonitor();
    }

    public QueryExecution executeSubquery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.masterCompiler().supportsAdministrativeCommands();
            RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, (InternalNotificationLogger)notificationLogger, profile, couldContainSensitiveFields, TransactionalContext.DatabaseMode.COMPOSITE.equals((Object)context.databaseMode()));
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, monitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger);
        });
    }

    public QueryExecutionMonitor executeSubquery$default$8() {
        return this.defaultQueryExecutionMonitor();
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Status.HasStatus) {
                    Throwable throwable3 = throwable2;
                    context.kernelTransaction().markForTermination(((Status.HasStatus)throwable3).status());
                    context.close();
                    throw throwable3;
                }
                if (throwable2 != null) {
                    Throwable throwable4 = throwable2;
                    context.kernelTransaction().markForTermination((Status)Status.Transaction.QueryExecutionFailedOnTransaction);
                    context.close();
                    throw throwable4;
                }
                throw throwable;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber, InternalNotificationLogger notificationLogger) {
        ExecutableQuery executableQuery;
        try {
            executableQuery = this.getOrCompile(context, query, tracer, params, notificationLogger);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ErrorGqlStatusObject) {
                Throwable throwable3 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable4 = throwable3;
                    if (throwable4 instanceof Status.HasStatus) {
                        Throwable throwable5 = throwable4;
                        status = ((Status.HasStatus)throwable5).status();
                    } else {
                        status = null;
                    }
                    Status status2 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable3.getMessage(), status2, (ErrorGqlStatusObject)throwable3);
                }
                throw throwable3;
            }
            if (throwable2 != null) {
                Throwable throwable6 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable7 = throwable6;
                    if (throwable7 instanceof Status.HasStatus) {
                        Throwable throwable8 = throwable7;
                        status = ((Status.HasStatus)throwable8).status();
                    } else {
                        status = null;
                    }
                    Status status3 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable6.getMessage(), status3, null);
                }
                throw throwable6;
            }
            throw throwable;
        }
        ExecutableQuery executableQuery2 = executableQuery;
        String string = query.options().queryOptions().executionMode().name();
        String string2 = "explain";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkParameters(executableQuery2.paramNames(), params, executableQuery2.extractedParams());
        }
        MapValue combinedParams = params.updatedWith(executableQuery2.extractedParams());
        if (isOutermostQuery) {
            context.executingQuery().onObfuscatorReady(executableQuery2.queryObfuscator(), query.options().offset().offset());
            context.executingQuery().onCompilationCompleted(executableQuery2.compilerInfo(), executableQuery2.planDescriptionSupplier(), executableQuery2.deprecationNotificationsProvider(query.options().offset()), executableQuery2.executionPlanCacheKeyHash());
        }
        QueryRuntimeConfig queryConfig = QueryRuntimeConfig$.MODULE$.createFrom(query.options().queryOptions(), this.config());
        return executableQuery2.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber, queryConfig);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params, InternalNotificationLogger notificationLogger, DatabaseReference sessionDatabase) {
        Function0 & Serializable compiledExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        Function0 & Serializable interpretedExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0) {
                    return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
                }
                return (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount, Function0<Object> shouldRecompile) {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() && shouldRecompile.apply$mcZ$sp()) {
                    return new Some(this.compiledExpressionCompiler$1.apply());
                }
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params, InternalNotificationLogger notificationLogger) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<InputQuery.CacheKey> cacheKey = new QueryCache.CacheKey<InputQuery.CacheKey>(initialInputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params, this.config().useParameterSizeHint()), tc.kernelTransaction().dataRead().transactionStateHasChanges());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params, notificationLogger, new DatabaseReference(null, context){
                            private final TransactionalContext context$3;

                            public String name() {
                                return super.name();
                            }

                            public NormalizedDatabaseName alias() {
                                throw new NotImplementedError();
                            }

                            public Optional<NormalizedDatabaseName> namespace() {
                                throw new NotImplementedError();
                            }

                            public boolean isPrimary() {
                                throw new NotImplementedError();
                            }

                            public UUID id() {
                                throw new NotImplementedError();
                            }

                            public String toPrettyString() {
                                throw new NotImplementedError();
                            }

                            public NormalizedDatabaseName fullName() {
                                return new NormalizedDatabaseName(this.context$3.databaseId().name());
                            }

                            public boolean isComposite() {
                                return this.context$3.databaseMode().equals((Object)TransactionalContext.DatabaseMode.COMPOSITE);
                            }

                            public int compareTo(DatabaseReference o) {
                                throw new NotImplementedError();
                            }

                            public String owningDatabaseName() {
                                return this.fullName().name();
                            }

                            public NormalizedCatalogEntry catalogEntry() {
                                throw new NotImplementedError();
                            }
                            {
                                this.context$3 = context$3;
                            }
                        });
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()}))).max((Ordering)Ordering.Long$.MODULE$));
    }

    public long clearPreParserCache() {
        return this.preParser().clearCache();
    }

    public long clearExecutableQueryCache() {
        return this.queryCache().clear();
    }

    public long clearCompilerCaches() {
        return this.masterCompiler().clearCaches();
    }

    public void insertIntoCache(String queryText, PreParsedQuery preParsedQuery, MapValue params, BaseState parsedQuery, Set<InternalNotification> parsingNotifications) {
        this.preParser().insertIntoCache(queryText, preParsedQuery);
        this.masterCompiler().insertIntoCache(preParsedQuery, params, parsedQuery, parsingNotifications);
    }

    public java.util.List<FunctionInformation> getCypherFunctions() {
        List informations = Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        scala.collection.immutable.Seq predicateInformations = (scala.collection.immutable.Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)informations.$plus$plus((IterableOnce)predicateInformations)).asJava();
    }

    @Override
    public void close() {
        this.queryCaches().close();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])queryParams), (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key)))));
            throw new ParameterNotFoundException("Expected parameter(s): " + Predef$.MODULE$.wrapRefArray((Object[])missingKeys).mkString(", "));
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CypherConfiguration config, MasterCompiler masterCompiler, CypherQueryCaches queryCaches, InternalLogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.config = config;
        this.masterCompiler = masterCompiler;
        this.queryCaches = queryCaches;
        this.logProvider = logProvider;
        this.clock = clock;
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new CachingPreParser(config, queryCaches.preParserCache());
        this.queryCache = queryCaches.executableQueryCache();
        this.schemaHelper = new SchemaHelper(this.queryCache(), masterCompiler);
    }
}

