/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.administration;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import org.neo4j.common.DependencyResolver;
import org.neo4j.cypher.internal.AdministrationCommandRuntime;
import org.neo4j.cypher.internal.AdministrationCommandRuntime$;
import org.neo4j.cypher.internal.AdministrationShowCommandUtils$;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExistingDataOption$;
import org.neo4j.cypher.internal.ExistingSeedInstanceOption$;
import org.neo4j.cypher.internal.LogEnrichmentOption$;
import org.neo4j.cypher.internal.SeedConfigOption$;
import org.neo4j.cypher.internal.SeedCredentialsOption$;
import org.neo4j.cypher.internal.SeedURIOption$;
import org.neo4j.cypher.internal.administration.BaseDatabaseInfoMapper$;
import org.neo4j.cypher.internal.administration.DatabaseInfoMapper;
import org.neo4j.cypher.internal.administration.ShowDatabasesExecutionPlanner$;
import org.neo4j.cypher.internal.ast.DatabaseName;
import org.neo4j.cypher.internal.ast.DatabaseScope;
import org.neo4j.cypher.internal.ast.DefaultDatabaseScope;
import org.neo4j.cypher.internal.ast.HomeDatabaseScope;
import org.neo4j.cypher.internal.ast.NamedDatabaseScope;
import org.neo4j.cypher.internal.ast.Return;
import org.neo4j.cypher.internal.ast.ShowDatabase$;
import org.neo4j.cypher.internal.ast.Yield;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.procs.ParameterTransformer;
import org.neo4j.cypher.internal.procs.ParameterTransformer$;
import org.neo4j.cypher.internal.procs.SystemCommandExecutionPlan;
import org.neo4j.cypher.internal.procs.SystemCommandExecutionPlan$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseInfo;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.database.ExtendedDatabaseInfo;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r}a\u0001\u0002\u001f>\u0001\"C\u0001B\u0018\u0001\u0003\u0016\u0004%\ta\u0018\u0005\tM\u0002\u0011\t\u0012)A\u0005A\"Aq\r\u0001BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005r\u0001\tE\t\u0015!\u0003j\u0011!\u0011\bA!f\u0001\n\u0003\u0019\b\u0002\u0003=\u0001\u0005#\u0005\u000b\u0011\u0002;\t\u0011e\u0004!Q3A\u0005\u0002iD\u0011\"a\u0003\u0001\u0005#\u0005\u000b\u0011B>\t\u0015\u00055\u0001A!A!\u0002\u0017\ty\u0001C\u0004\u0002&\u0001!\t!a\n\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA&\u0001\u0001\u0006I!a\u000f\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA0\u0001\u0001\u0006I!!\u0015\t\u0013\u0005\u0005\u0004A1A\u0005\n\u0005e\u0002\u0002CA2\u0001\u0001\u0006I!a\u000f\t\u0013\u0005\u0015\u0004A1A\u0005\n\u0005e\u0002\u0002CA4\u0001\u0001\u0006I!a\u000f\t\u0013\u0005%\u0004A1A\u0005\n\u0005e\u0002\u0002CA6\u0001\u0001\u0006I!a\u000f\t\u0013\u00055\u0004A1A\u0005\n\u0005e\u0002\u0002CA8\u0001\u0001\u0006I!a\u000f\t\u0013\u0005E\u0004A1A\u0005\n\u0005e\u0002\u0002CA:\u0001\u0001\u0006I!a\u000f\t\u0013\u0005}\u0001A1A\u0005\n\u0005U\u0004\u0002CAA\u0001\u0001\u0006I!a\u001e\t\u0013\u0005\r\u0005A1A\u0005\n\u0005\u0015\u0005\u0002CAG\u0001\u0001\u0006I!a\"\t\u0013\u0005=\u0005A1A\u0005\n\u0005E\u0005\u0002CAM\u0001\u0001\u0006I!a%\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bb\u0002B\r\u0001\u0011%!1\u0004\u0005\n\u0005C\u0001!\u0019!C\u0005\u0005GA\u0001B!\u000e\u0001A\u0003%!Q\u0005\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007fAqAa\u0017\u0001\t\u0013\u0011i\u0006C\u0005\u0003j\u0001\t\t\u0011\"\u0001\u0003l!I!\u0011\u0010\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005#\u0003\u0011\u0013!C\u0001\u0005'C\u0011Ba&\u0001#\u0003%\tA!'\t\u0013\tu\u0005!%A\u0005\u0002\t}\u0005\"\u0003BR\u0001\u0005\u0005I\u0011IA(\u0011%\u0011)\u000bAA\u0001\n\u0003\u00119\u000bC\u0005\u00030\u0002\t\t\u0011\"\u0001\u00032\"I!Q\u0018\u0001\u0002\u0002\u0013\u0005#q\u0018\u0005\n\u0005\u0013\u0004\u0011\u0011!C\u0001\u0005\u0017D\u0011Ba4\u0001\u0003\u0003%\tE!5\t\u0013\tU\u0007!!A\u0005B\t]\u0007\"\u0003Bm\u0001\u0005\u0005I\u0011\tBn\u0011%\u0011i\u000eAA\u0001\n\u0003\u0012ynB\u0005\u0003dv\n\t\u0011#\u0001\u0003f\u001aAA(PA\u0001\u0012\u0003\u00119\u000fC\u0004\u0002&Y\"\tAa=\t\u0013\teg'!A\u0005F\tm\u0007\"\u0003B{m\u0005\u0005I\u0011\u0011B|\u0011%\u0019)ANA\u0001\n\u0003\u001b9\u0001C\u0005\u0004\u0016Y\n\t\u0011\"\u0003\u0004\u0018\ti2\u000b[8x\t\u0006$\u0018MY1tKN,\u00050Z2vi&|g\u000e\u00157b]:,'O\u0003\u0002?\u007f\u0005q\u0011\rZ7j]&\u001cHO]1uS>t'B\u0001!B\u0003!Ig\u000e^3s]\u0006d'B\u0001\"D\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A)R\u0001\u0006]\u0016|GG\u001b\u0006\u0002\r\u0006\u0019qN]4\u0004\u0001M!\u0001!S(S!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0019\te.\u001f*fMB\u0011!\nU\u0005\u0003#.\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002T7:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/\u001e\u000ba\u0001\u0010:p_Rt\u0014\"\u0001'\n\u0005i[\u0015a\u00029bG.\fw-Z\u0005\u00039v\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!AW&\u0002\u0011I,7o\u001c7wKJ,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u000e\u000baaY8n[>t\u0017BA3c\u0005I!U\r]3oI\u0016t7-\u001f*fg>dg/\u001a:\u0002\u0013I,7o\u001c7wKJ\u0004\u0013a\u00063fM\u0006,H\u000e\u001e#bi\u0006\u0014\u0017m]3SKN|GN^3s+\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003!!\u0017\r^1cCN,'B\u00018D\u0003\u0019YWM\u001d8fY&\u0011\u0001o\u001b\u0002\u0018\t\u00164\u0017-\u001e7u\t\u0006$\u0018MY1tKJ+7o\u001c7wKJ\f\u0001\u0004Z3gCVdG\u000fR1uC\n\f7/\u001a*fg>dg/\u001a:!\u0003UqwN]7bY\u0016CXmY;uS>tWI\\4j]\u0016,\u0012\u0001\u001e\t\u0003kZl\u0011aP\u0005\u0003o~\u0012q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.Z\u0001\u0017]>\u0014X.\u00197Fq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8fA\u0005a2/Z2ve&$\u00180Q;uQ>\u0014\u0018N_1uS>t\u0007*\u00198eY\u0016\u0014X#A>\u0011\u0007q\f9!D\u0001~\u0015\tqx0\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0011\t\t!a\u0001\u0002\u0007\u0005\u0004\u0018NC\u0002o\u0003\u000bQ!\u0001Q\"\n\u0007\u0005%QP\u0001\u000fTK\u000e,(/\u001b;z\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8IC:$G.\u001a:\u0002;M,7-\u001e:jif\fU\u000f\u001e5pe&T\u0018\r^5p]\"\u000bg\u000e\u001a7fe\u0002\n!$\u001a=uK:$W\r\u001a#bi\u0006\u0014\u0017m]3J]\u001a|W*\u00199qKJ\u0004b!!\u0005\u0002\u0014\u0005]Q\"A\u001f\n\u0007\u0005UQH\u0001\nECR\f'-Y:f\u0013:4w.T1qa\u0016\u0014\b\u0003BA\r\u0003Ci!!a\u0007\u000b\u00071\fiBC\u0002\u0002 \r\u000bA\u0001\u001a2ng&!\u00111EA\u000e\u0005Q)\u0005\u0010^3oI\u0016$G)\u0019;bE\u0006\u001cX-\u00138g_\u00061A(\u001b8jiz\"\"\"!\u000b\u00020\u0005E\u00121GA\u001b)\u0011\tY#!\f\u0011\u0007\u0005E\u0001\u0001C\u0004\u0002\u000e)\u0001\u001d!a\u0004\t\u000byS\u0001\u0019\u00011\t\u000b\u001dT\u0001\u0019A5\t\u000bIT\u0001\u0019\u0001;\t\u000beT\u0001\u0019A>\u0002;=\u0003F+S(O'~#\u0006l\u0018'P\u000f~+eJU%D\u00116+e\nV0L\u000bf+\"!a\u000f\u0011\t\u0005u\u0012Q\t\b\u0005\u0003\u007f\t\t\u0005\u0005\u0002V\u0017&\u0019\u00111I&\u0002\rA\u0013X\rZ3g\u0013\u0011\t9%!\u0013\u0003\rM#(/\u001b8h\u0015\r\t\u0019eS\u0001\u001f\u001fB#\u0016j\u0014(T?RCv\fT(H?\u0016s%+S\"I\u001b\u0016sEkX&F3\u0002\n\u0011d\u0014)U\u0013>s5kX#Y\u0013N#\u0016JT$`\t\u0006#\u0016iX&F3V\u0011\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0013\u0001\u00026bm\u0006LA!a\u0012\u0002V\u0005Qr\n\u0015+J\u001f:\u001bv,\u0012-J'RKejR0E\u0003R\u000bulS#ZA\u0005!r\n\u0015+J\u001f:\u001bvlU#F\t~+&+S0L\u000bf\u000bQc\u0014)U\u0013>s5kX*F\u000b\u0012{VKU%`\u0017\u0016K\u0006%A\fP!RKuJT*`'\u0016+EiX\"P\u001d\u001aKuiX&F3\u0006Ar\n\u0015+J\u001f:\u001bvlU#F\t~\u001buJ\u0014$J\u000f~[U)\u0017\u0011\u00029=\u0003F+S(O'~\u001bV)\u0012#`\u0007J+E)\u0012(U\u0013\u0006c5kX&F3\u0006ir\n\u0015+J\u001f:\u001bvlU#F\t~\u001b%+\u0012#F\u001dRK\u0015\tT*`\u0017\u0016K\u0006%A\rP!RKuJT*`'\u0016+EiX%O'R\u000bejQ#`\u0017\u0016K\u0016AG(Q)&{ejU0T\u000b\u0016#u,\u0013(T)\u0006s5)R0L\u000bf\u0003\u0013\u0001E1dG\u0016\u001c8/\u001b2mK\u0012\u00137oS3z\u0003E\t7mY3tg&\u0014G.\u001a#cg.+\u0017\u0010I\u000b\u0003\u0003o\u0002B!!\u001f\u0002~5\u0011\u00111\u0010\u0006\u0005\u0003\u0003\ti\"\u0003\u0003\u0002\u0000\u0005m$!\u0007#bi\u0006\u0014\u0017m]3NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016\fQ\u0001\u001a2ng\u0002\n1\"\u001b8g_N+'O^5dKV\u0011\u0011q\u0011\t\u0005\u00033\tI)\u0003\u0003\u0002\f\u0006m!a\u0005#bi\u0006\u0014\u0017m]3J]\u001a|7+\u001a:wS\u000e,\u0017\u0001D5oM>\u001cVM\u001d<jG\u0016\u0004\u0013!\u0005:fM\u0016\u0014XM\\2f%\u0016\u001cx\u000e\u001c<feV\u0011\u00111\u0013\t\u0004U\u0006U\u0015bAALW\nYB)\u0019;bE\u0006\u001cXMU3gKJ,gnY3SKB|7/\u001b;pef\f!C]3gKJ,gnY3SKN|GN^3sA\u0005\t\u0002\u000f\\1o'\"|w\u000fR1uC\n\f7/Z:\u0015\u0019\u0005}\u0015QUA[\u0003\u007f\u000bI-!7\u0011\u0007U\f\t+C\u0002\u0002$~\u0012Q\"\u0012=fGV$\u0018n\u001c8QY\u0006t\u0007bBAT?\u0001\u0007\u0011\u0011V\u0001\u0006g\u000e|\u0007/\u001a\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*\u0019\u0011qV \u0002\u0007\u0005\u001cH/\u0003\u0003\u00024\u00065&!\u0004#bi\u0006\u0014\u0017m]3TG>\u0004X\rC\u0004\u00028~\u0001\r!!/\u0002\u000fY,'OY8tKB\u0019!*a/\n\u0007\u0005u6JA\u0004C_>dW-\u00198\t\u000f\u0005\u0005w\u00041\u0001\u0002D\u000691/_7c_2\u001c\b#B*\u0002F\u0006m\u0012bAAd;\n!A*[:u\u0011\u001d\tYm\ba\u0001\u0003\u001b\fa!_5fY\u0012\u001c\b#\u0002&\u0002P\u0006M\u0017bAAi\u0017\n1q\n\u001d;j_:\u0004B!a+\u0002V&!\u0011q[AW\u0005\u0015I\u0016.\u001a7e\u0011\u001d\tYn\ba\u0001\u0003;\fqA]3ukJt7\u000fE\u0003K\u0003\u001f\fy\u000e\u0005\u0003\u0002,\u0006\u0005\u0018\u0002BAr\u0003[\u0013aAU3ukJt\u0017\u0001K4f]\u0016\u0014\u0018\r^3TQ><\u0018iY2fgNL'\r\\3ECR\f'-Y:fgB\u000b'/Y7fi\u0016\u0014HCCAu\u0003s\u0014IAa\u0005\u0003\u0018A!\u00111^A{\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018a\u0002<jeR,\u0018\r\u001c\u0006\u0004\u0003g\u001c\u0015A\u0002<bYV,7/\u0003\u0003\u0002x\u00065(\u0001C'baZ\u000bG.^3\t\u000f\u0005m\b\u00051\u0001\u0002~\u0006YAO]1og\u0006\u001cG/[8o!\u0011\tyP!\u0002\u000e\u0005\t\u0005!b\u0001B\u0002\u0007\u00069qM]1qQ\u0012\u0014\u0017\u0002\u0002B\u0004\u0005\u0003\u00111\u0002\u0016:b]N\f7\r^5p]\"9!1\u0002\u0011A\u0002\t5\u0011aD:fGV\u0014\u0018\u000e^=D_:$X\r\u001f;\u0011\u0007q\u0014y!C\u0002\u0003\u0012u\u0014qbU3dkJLG/_\"p]R,\u0007\u0010\u001e\u0005\b\u0005+\u0001\u0003\u0019AAg\u0003)i\u0017-\u001f2f3&,G\u000e\u001a\u0005\b\u0003o\u0003\u0003\u0019AA]\u0003e9WM\\3sCR,Wk]3s]\u0006lW\rU1sC6,G/\u001a:\u0015\r\u0005%(Q\u0004B\u0010\u0011\u001d\tY0\ta\u0001\u0003{DqAa\u0003\"\u0001\u0004\u0011i!\u0001\neKR\f\u0017\u000e\\3e\u0019>|7.\u001e9D_2\u001cXC\u0001B\u0013!\u0019\u00119C!\r\u0002R5\u0011!\u0011\u0006\u0006\u0005\u0005W\u0011i#A\u0005j[6,H/\u00192mK*\u0019!qF&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00034\t%\"aA*fi\u0006\u0019B-\u001a;bS2,G\rT8pWV\u00048i\u001c7tA\u00051\"/Z9vSJ,7\u000fR3uC&dW\r\u001a'p_.,\b\u000f\u0006\u0003\u0002:\nm\u0002bBAfI\u0001\u0007\u00111[\u0001\u0011Y>|7.\u001e9DC\u000eDW\rZ%oM>$bA!\u0011\u0003L\te\u0003#B*\u0002F\n\r\u0003\u0003\u0002B#\u0005\u000fj!!!=\n\t\t%\u0013\u0011\u001f\u0002\t\u0003:Lh+\u00197vK\"9!QJ\u0013A\u0002\t=\u0013a\u00033bi\u0006\u0014\u0017m]3JIN\u0004b!!\u0010\u0003R\tM\u0013\u0002\u0002B\u001a\u0003\u0013\u00022A\u001bB+\u0013\r\u00119f\u001b\u0002\u0010\u001d\u0006lW\r\u001a#bi\u0006\u0014\u0017m]3JI\"9\u00111`\u0013A\u0002\u0005u\u0018a\u0005:fcV,7\u000f\u001e#fi\u0006LG.\u001a3J]\u001a|GC\u0002B0\u0005K\u00129\u0007\u0006\u0003\u0003B\t\u0005\u0004b\u0002B2M\u0001\u000f\u0011qB\u0001\u0007[\u0006\u0004\b/\u001a:\t\u000f\t5c\u00051\u0001\u0003P!9\u00111 \u0014A\u0002\u0005u\u0018\u0001B2paf$\"B!\u001c\u0003r\tM$Q\u000fB<)\u0011\tYCa\u001c\t\u000f\u00055q\u0005q\u0001\u0002\u0010!9al\nI\u0001\u0002\u0004\u0001\u0007bB4(!\u0003\u0005\r!\u001b\u0005\be\u001e\u0002\n\u00111\u0001u\u0011\u001dIx\u0005%AA\u0002m\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003~)\u001a\u0001Ma ,\u0005\t\u0005\u0005\u0003\u0002BB\u0005\u001bk!A!\"\u000b\t\t\u001d%\u0011R\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa#L\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0013)IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0016*\u001a\u0011Na \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0014\u0016\u0004i\n}\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005CS3a\u001fB@\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\u0016\t\u0004\u0015\n-\u0016b\u0001BW\u0017\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0017B]!\rQ%QW\u0005\u0004\u0005o[%aA!os\"I!1\u0018\u0018\u0002\u0002\u0003\u0007!\u0011V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0007C\u0002Bb\u0005\u000b\u0014\u0019,\u0004\u0002\u0003.%!!q\u0019B\u0017\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e&Q\u001a\u0005\n\u0005w\u0003\u0014\u0011!a\u0001\u0005g\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011\u000bBj\u0011%\u0011Y,MA\u0001\u0002\u0004\u0011I+\u0001\u0005iCND7i\u001c3f)\t\u0011I+\u0001\u0005u_N#(/\u001b8h)\t\t\t&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003s\u0013\t\u000fC\u0005\u0003<R\n\t\u00111\u0001\u00034\u0006i2\u000b[8x\t\u0006$\u0018MY1tKN,\u00050Z2vi&|g\u000e\u00157b]:,'\u000fE\u0002\u0002\u0012Y\u001aBAN%\u0003jB!!1\u001eBy\u001b\t\u0011iO\u0003\u0003\u0003p\u0006e\u0013AA5p\u0013\ra&Q\u001e\u000b\u0003\u0005K\fQ!\u00199qYf$\"B!?\u0003~\n}8\u0011AB\u0002)\u0011\tYCa?\t\u000f\u00055\u0011\bq\u0001\u0002\u0010!)a,\u000fa\u0001A\")q-\u000fa\u0001S\")!/\u000fa\u0001i\")\u00110\u000fa\u0001w\u00069QO\\1qa2LH\u0003BB\u0005\u0007#\u0001RASAh\u0007\u0017\u0001rASB\u0007A&$80C\u0002\u0004\u0010-\u0013a\u0001V;qY\u0016$\u0004\"CB\nu\u0005\u0005\t\u0019AA\u0016\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00073\u0001B!a\u0015\u0004\u001c%!1QDA+\u0005\u0019y%M[3di\u0002")
public class ShowDatabasesExecutionPlanner
implements Product,
Serializable {
    private final DependencyResolver resolver;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final ExecutionEngine normalExecutionEngine;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final DatabaseInfoMapper<ExtendedDatabaseInfo> extendedDatabaseInfoMapper;
    private final String OPTIONS_TX_LOG_ENRICHMENT_KEY;
    private final String OPTIONS_EXISTING_DATA_KEY;
    private final String OPTIONS_SEED_URI_KEY;
    private final String OPTIONS_SEED_CONFIG_KEY;
    private final String OPTIONS_SEED_CREDENTIALS_KEY;
    private final String OPTIONS_SEED_INSTANCE_KEY;
    private final String accessibleDbsKey;
    private final DatabaseManagementService dbms;
    private final DatabaseInfoService infoService;
    private final DatabaseReferenceRepository referenceResolver;
    private final Set<String> detailedLookupCols;

    public static Option<Tuple4<DependencyResolver, DefaultDatabaseResolver, ExecutionEngine, SecurityAuthorizationHandler>> unapply(ShowDatabasesExecutionPlanner x$0) {
        return ShowDatabasesExecutionPlanner$.MODULE$.unapply(x$0);
    }

    public static ShowDatabasesExecutionPlanner apply(DependencyResolver resolver, DefaultDatabaseResolver defaultDatabaseResolver, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler, DatabaseInfoMapper<ExtendedDatabaseInfo> extendedDatabaseInfoMapper) {
        return ShowDatabasesExecutionPlanner$.MODULE$.apply(resolver, defaultDatabaseResolver, normalExecutionEngine, securityAuthorizationHandler, extendedDatabaseInfoMapper);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public DependencyResolver resolver() {
        return this.resolver;
    }

    public DefaultDatabaseResolver defaultDatabaseResolver() {
        return this.defaultDatabaseResolver;
    }

    public ExecutionEngine normalExecutionEngine() {
        return this.normalExecutionEngine;
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.securityAuthorizationHandler;
    }

    private String OPTIONS_TX_LOG_ENRICHMENT_KEY() {
        return this.OPTIONS_TX_LOG_ENRICHMENT_KEY;
    }

    private String OPTIONS_EXISTING_DATA_KEY() {
        return this.OPTIONS_EXISTING_DATA_KEY;
    }

    private String OPTIONS_SEED_URI_KEY() {
        return this.OPTIONS_SEED_URI_KEY;
    }

    private String OPTIONS_SEED_CONFIG_KEY() {
        return this.OPTIONS_SEED_CONFIG_KEY;
    }

    private String OPTIONS_SEED_CREDENTIALS_KEY() {
        return this.OPTIONS_SEED_CREDENTIALS_KEY;
    }

    private String OPTIONS_SEED_INSTANCE_KEY() {
        return this.OPTIONS_SEED_INSTANCE_KEY;
    }

    private String accessibleDbsKey() {
        return this.accessibleDbsKey;
    }

    private DatabaseManagementService dbms() {
        return this.dbms;
    }

    private DatabaseInfoService infoService() {
        return this.infoService;
    }

    private DatabaseReferenceRepository referenceResolver() {
        return this.referenceResolver;
    }

    public ExecutionPlan planShowDatabases(DatabaseScope scope, boolean verbose, List<String> symbols, Option<Yield> yields, Option<Return> returns) {
        Tuple3 tuple3;
        String usernameKey = AdministrationCommandRuntime$.MODULE$.internalKey("username");
        String optionsKey = AdministrationCommandRuntime$.MODULE$.internalKey("options");
        String isCompositeKey = AdministrationCommandRuntime$.MODULE$.internalKey("isComposite");
        ParameterTransformer parameterGenerator = ParameterTransformer$.MODULE$.apply((Function2<Transaction, SecurityContext, MapValue>)(Function2 & Serializable)(tx, securityContext) -> this.generateShowAccessibleDatabasesParameter((Transaction)tx, (SecurityContext)securityContext, yields, verbose)).generate((Function2<Transaction, SecurityContext, MapValue>)(Function2 & Serializable)(transaction, securityContext) -> this.generateUsernameParameter((Transaction)transaction, (SecurityContext)securityContext));
        DatabaseScope databaseScope = scope;
        if (databaseScope instanceof DefaultDatabaseScope) {
            v0 = new Tuple3((Object)"WHERE default = true", (Object)VirtualValues.EMPTY_MAP, (Object)parameterGenerator);
        } else if (databaseScope instanceof HomeDatabaseScope) {
            v0 = new Tuple3((Object)"WHERE home = true", (Object)VirtualValues.EMPTY_MAP, (Object)parameterGenerator);
        } else if (databaseScope instanceof NamedDatabaseScope) {
            NamedDatabaseScope namedDatabaseScope = (NamedDatabaseScope)databaseScope;
            DatabaseName p = namedDatabaseScope.database();
            AdministrationCommandRuntime.DatabaseNameFields nameFields = AdministrationCommandRuntime$.MODULE$.getDatabaseNameFields("databaseName", p);
            v0 = new Tuple3((Object)("WHERE any(a in aliases WHERE $`" + nameFields.nameKey() + "` = a.name AND  $`" + nameFields.namespaceKey() + "` = a.namespace)"), (Object)VirtualValues.map((String[])nameFields.keys(), (AnyValue[])nameFields.values()), (Object)parameterGenerator.convert(nameFields.nameConverter()).validate((Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>>)(Function2 & Serializable)(tx, params) -> AdministrationCommandRuntime$.MODULE$.checkNamespaceExists(nameFields, (Transaction)tx, (MapValue)params)));
        } else {
            v0 = tuple3 = new Tuple3((Object)"", (Object)VirtualValues.EMPTY_MAP, (Object)parameterGenerator);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String extraFilter = (String)tuple3._1();
        MapValue params2 = (MapValue)tuple3._2();
        ParameterTransformer parameterTransformer = (ParameterTransformer)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)extraFilter, (Object)params2, (Object)parameterTransformer);
        String extraFilter2 = (String)tuple32._1();
        MapValue params3 = (MapValue)tuple32._2();
        ParameterTransformer parameterTransformer2 = (ParameterTransformer)tuple32._3();
        String optionsMap = ShowDatabasesExecutionPlanner.optionsOutputMap$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.OPTIONS_EXISTING_DATA_KEY(), this.OPTIONS_SEED_URI_KEY(), this.OPTIONS_SEED_CONFIG_KEY(), this.OPTIONS_SEED_CREDENTIALS_KEY(), this.OPTIONS_SEED_INSTANCE_KEY(), this.OPTIONS_TX_LOG_ENRICHMENT_KEY()})), optionsKey);
        String verboseColumns = verbose ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(", props." + ShowDatabase$.MODULE$.DATABASE_ID_COL() + " as " + ShowDatabase$.MODULE$.DATABASE_ID_COL() + ",\n           |props." + ShowDatabase$.MODULE$.CURRENT_PRIMARIES_COUNT_COL() + " as " + ShowDatabase$.MODULE$.CURRENT_PRIMARIES_COUNT_COL() + ",\n           |props." + ShowDatabase$.MODULE$.CURRENT_SECONDARIES_COUNT_COL() + " as " + ShowDatabase$.MODULE$.CURRENT_SECONDARIES_COUNT_COL() + ",\n           |d.primaries as " + ShowDatabase$.MODULE$.REQUESTED_PRIMARIES_COUNT_COL() + ",\n           |d.secondaries as " + ShowDatabase$.MODULE$.REQUESTED_SECONDARIES_COUNT_COL() + ",\n           |props." + ShowDatabase$.MODULE$.LAST_COMMITTED_TX_COL() + " as " + ShowDatabase$.MODULE$.LAST_COMMITTED_TX_COL() + ",\n           |props." + ShowDatabase$.MODULE$.REPLICATION_LAG_COL() + " as " + ShowDatabase$.MODULE$.REPLICATION_LAG_COL() + ",\n           |d.created_at as " + ShowDatabase$.MODULE$.CREATION_TIME_COL() + ",\n           |d.started_at as " + ShowDatabase$.MODULE$.LAST_START_TIME_COL() + ",\n           |d.stopped_at as " + ShowDatabase$.MODULE$.LAST_STOP_TIME_COL() + ",\n           |props." + ShowDatabase$.MODULE$.STORE_COL() + " as " + ShowDatabase$.MODULE$.STORE_COL() + ",\n           |d:" + TopologyGraphDbmsModel.COMPOSITE_DATABASE + " as " + isCompositeKey + ",\n           |{ " + this.OPTIONS_EXISTING_DATA_KEY() + ": CASE WHEN coalesce(d.seedURI, d.designated_seeder) IS NOT NULL THEN 'use' ELSE NULL END,\n           |  " + this.OPTIONS_SEED_URI_KEY() + ": d.seedURI,\n           |  " + this.OPTIONS_SEED_CONFIG_KEY() + ": d.seedConfig,\n           |  " + this.OPTIONS_SEED_CREDENTIALS_KEY() + ": CASE WHEN d.seedCredentialsEncrypted IS NOT NULL THEN '********' ELSE NULL END,\n           |  " + this.OPTIONS_SEED_INSTANCE_KEY() + ": d.designated_seeder,\n           |  " + this.OPTIONS_TX_LOG_ENRICHMENT_KEY() + ": d.txLogEnrichment } as " + optionsKey + "\n           |with *, CASE WHEN " + isCompositeKey + " THEN NULL ELSE " + optionsMap + " END as " + ShowDatabase$.MODULE$.OPTIONS_COL() + "\n           |")) : "";
        String verboseNames = verbose ? ", " + ShowDatabase$.MODULE$.DATABASE_ID_COL() + ", " + ShowDatabase$.MODULE$.SERVER_ID_COL() + ", " + ShowDatabase$.MODULE$.REQUESTED_PRIMARIES_COUNT_COL() + ", " + ShowDatabase$.MODULE$.REQUESTED_SECONDARIES_COUNT_COL() + ", " + ShowDatabase$.MODULE$.CURRENT_PRIMARIES_COUNT_COL() + ", " + ShowDatabase$.MODULE$.CURRENT_SECONDARIES_COUNT_COL() + ", " + ShowDatabase$.MODULE$.CREATION_TIME_COL() + ", " + ShowDatabase$.MODULE$.LAST_START_TIME_COL() + ", " + ShowDatabase$.MODULE$.LAST_STOP_TIME_COL() + ", " + ShowDatabase$.MODULE$.STORE_COL() + ", " + ShowDatabase$.MODULE$.LAST_COMMITTED_TX_COL() + ", " + ShowDatabase$.MODULE$.REPLICATION_LAG_COL() + ", " + ShowDatabase$.MODULE$.OPTIONS_COL() : "";
        String returnClause = AdministrationShowCommandUtils$.MODULE$.generateReturnClause(symbols, yields, returns, (Seq<String>)new .colon.colon((Object)"name", (List)Nil$.MODULE$));
        String query = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("// First resolve which database is the home database\n           |OPTIONAL MATCH (default:" + TopologyGraphDbmsModel.DATABASE_LABEL + " {default: true})\n           |OPTIONAL MATCH (user:User {name: $`" + usernameKey + "`})\n           |WITH coalesce(user.homeDatabase, default.name) as homeDbName\n           |\n           |UNWIND $`" + this.accessibleDbsKey() + "` AS props\n           |MATCH (d:" + TopologyGraphDbmsModel.DATABASE + ")<-[:" + TopologyGraphDbmsModel.TARGETS + "]-(dn:" + TopologyGraphDbmsModel.DATABASE_NAME + " {name: props.name, namespace: 'system-root'})\n           |WITH d, dn, props, homeDbName\n           |OPTIONAL MATCH (d)<-[:" + TopologyGraphDbmsModel.TARGETS + "]-(a:" + TopologyGraphDbmsModel.DATABASE_NAME + ")\n           |WITH a, d, dn, props, homeDbName ORDER BY a.displayName\n           |OPTIONAL MATCH (constituent:" + TopologyGraphDbmsModel.DATABASE_NAME + " {namespace: dn.name})\n           |WHERE d:" + TopologyGraphDbmsModel.COMPOSITE_DATABASE + " AND constituent <> dn\n           |WITH d.name as name,\n           |collect(a) as aliases,\n           |collect(constituent.displayName) as constituents,\n           |props." + ShowDatabase$.MODULE$.ACCESS_COL() + " as " + ShowDatabase$.MODULE$.ACCESS_COL() + ",\n           |props." + ShowDatabase$.MODULE$.ADDRESS_COL() + " as " + ShowDatabase$.MODULE$.ADDRESS_COL() + ",\n           |props." + ShowDatabase$.MODULE$.ROLE_COL() + " as " + ShowDatabase$.MODULE$.ROLE_COL() + ",\n           |props." + ShowDatabase$.MODULE$.WRITER_COL() + " as " + ShowDatabase$.MODULE$.WRITER_COL() + ",\n           | // serverID needs to be part of the grouping key here as it is guaranteed to be different on different servers\n           |props." + ShowDatabase$.MODULE$.SERVER_ID_COL() + " as " + ShowDatabase$.MODULE$.SERVER_ID_COL() + ",\n           |d.status as requestedStatus,\n           |props." + ShowDatabase$.MODULE$.CURRENT_STATUS_COL() + " as " + ShowDatabase$.MODULE$.CURRENT_STATUS_COL() + ",\n           |props." + ShowDatabase$.MODULE$.STATUS_MSG_COL() + " as " + ShowDatabase$.MODULE$.STATUS_MSG_COL() + ",\n           |props.type as type,\n           |d.default as default,\n           |homeDbName,\n           |coalesce( homeDbName in collect(a.displayName) + [d.name], false ) as home\n           |" + verboseColumns + "\n           |" + extraFilter2 + "\n           |\n           |WITH name AS " + ShowDatabase$.MODULE$.NAME_COL() + ",\n           |type,\n           |[alias in aliases WHERE NOT (name = alias.name AND alias.namespace = 'system-root') | alias.displayName] as " + ShowDatabase$.MODULE$.ALIASES_COL() + ",\n           |" + ShowDatabase$.MODULE$.ACCESS_COL() + ",\n           |" + ShowDatabase$.MODULE$.ADDRESS_COL() + ",\n           |" + ShowDatabase$.MODULE$.ROLE_COL() + ",\n           |" + ShowDatabase$.MODULE$.WRITER_COL() + ",\n           |requestedStatus AS " + ShowDatabase$.MODULE$.REQUESTED_STATUS_COL() + ",\n           |" + ShowDatabase$.MODULE$.CURRENT_STATUS_COL() + ",\n           |" + ShowDatabase$.MODULE$.STATUS_MSG_COL() + ",\n           |default AS " + ShowDatabase$.MODULE$.DEFAULT_COL() + ",\n           |home AS " + ShowDatabase$.MODULE$.HOME_COL() + ",\n           |constituents as " + ShowDatabase$.MODULE$.CONSTITUENTS_COL() + "\n           |" + verboseNames + "\n           |" + returnClause + "\n           |"));
        String x$1 = scope.showCommandName();
        ExecutionEngine x$2 = this.normalExecutionEngine();
        SecurityAuthorizationHandler x$3 = this.securityAuthorizationHandler();
        String x$4 = query;
        MapValue x$5 = params3;
        ParameterTransformer x$6 = parameterTransformer2;
        Option<ExecutionPlan> x$7 = SystemCommandExecutionPlan$.MODULE$.apply$default$6();
        boolean x$8 = SystemCommandExecutionPlan$.MODULE$.apply$default$7();
        Function1<SecurityContext, SecurityContext> x$9 = SystemCommandExecutionPlan$.MODULE$.apply$default$9();
        return new SystemCommandExecutionPlan(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6, x$9);
    }

    private MapValue generateShowAccessibleDatabasesParameter(Transaction transaction, SecurityContext securityContext, Option<Yield> maybeYield, boolean verbose) {
        Set accessibleDatabases = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.referenceResolver().getAllDatabaseReferences()).asScala().collect((PartialFunction)new Serializable(null, securityContext){
            private static final long serialVersionUID = 0L;
            private final SecurityContext securityContext$1;

            public final <A1 extends DatabaseReference, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.isPrimary() && this.securityContext$1.databaseAccessMode().canSeeDatabase(A1)) {
                    return (B1)DatabaseIdFactory.from((String)A1.alias().name(), (UUID)A1.id());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(DatabaseReference x1) {
                DatabaseReference databaseReference = x1;
                return databaseReference.isPrimary() && this.securityContext$1.databaseAccessMode().canSeeDatabase(databaseReference);
            }
            {
                this.securityContext$1 = securityContext$1;
            }
        })).toSet();
        java.util.List dbMetadata = verbose && maybeYield.isDefined() && this.requiresDetailedLookup((Yield)maybeYield.get()) ? CollectionConverters$.MODULE$.SeqHasAsJava(this.requestDetailedInfo((Set<NamedDatabaseId>)accessibleDatabases, transaction, this.extendedDatabaseInfoMapper)).asJava() : CollectionConverters$.MODULE$.SeqHasAsJava(this.lookupCachedInfo((Set<NamedDatabaseId>)accessibleDatabases, transaction)).asJava();
        return VirtualValues.map((String[])((String[])((Object[])new String[]{this.accessibleDbsKey()})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{VirtualValues.fromList((java.util.List)dbMetadata)})));
    }

    /*
     * Unable to fully structure code
     */
    private MapValue generateUsernameParameter(Transaction transaction, SecurityContext securityContext) {
        block5: {
            block4: {
                var5_3 = false;
                var6_4 = null;
                var7_5 = Option$.MODULE$.apply((Object)securityContext.subject().executingUser());
                if (!None$.MODULE$.equals(var7_5)) break block4;
                v0 = Values.NO_VALUE;
                break block5;
            }
            if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
            var5_3 = true;
            var6_4 = (Some)var7_5;
            var8_6 = (String)var6_4.value();
            if ("".equals(var8_6)) {
                v0 = Values.NO_VALUE;
            } else if (var5_3) {
                user = (String)var6_4.value();
                v0 = Values.stringValue((String)user);
            } else {
                throw new MatchError((Object)var7_5);
            }
        }
        username = v0;
        return VirtualValues.map((String[])((String[])((Object[])new String[]{AdministrationCommandRuntime$.MODULE$.internalKey("username")})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{username})));
    }

    private Set<String> detailedLookupCols() {
        return this.detailedLookupCols;
    }

    private boolean requiresDetailedLookup(Yield yields) {
        return yields.returnItems().includeExisting() || ((IterableOnceOps)yields.returnItems().items().map((Function1 & Serializable)x$4 -> x$4.expression())).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ShowDatabasesExecutionPlanner.$anonfun$requiresDetailedLookup$2(this, x0$1)));
    }

    private List<AnyValue> lookupCachedInfo(Set<NamedDatabaseId> databaseIds, Transaction transaction) {
        Iterable dbInfos = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.infoService().lookupCachedInfo(CollectionConverters$.MODULE$.SetHasAsJava(databaseIds).asJava(), transaction)).asScala();
        return ((IterableOnceOps)dbInfos.map((Function1 & Serializable)info -> BaseDatabaseInfoMapper$.MODULE$.toMapValue(this.dbms(), (DatabaseInfo)info))).toList();
    }

    private List<AnyValue> requestDetailedInfo(Set<NamedDatabaseId> databaseIds, Transaction transaction, DatabaseInfoMapper<ExtendedDatabaseInfo> mapper) {
        Iterable dbInfos = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.infoService().requestDetailedInfo(CollectionConverters$.MODULE$.SetHasAsJava(databaseIds).asJava(), transaction)).asScala();
        return ((IterableOnceOps)dbInfos.map((Function1 & Serializable)info -> mapper.toMapValue(this.dbms(), (ExtendedDatabaseInfo)info))).toList();
    }

    public ShowDatabasesExecutionPlanner copy(DependencyResolver resolver, DefaultDatabaseResolver defaultDatabaseResolver, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler, DatabaseInfoMapper<ExtendedDatabaseInfo> extendedDatabaseInfoMapper) {
        return new ShowDatabasesExecutionPlanner(resolver, defaultDatabaseResolver, normalExecutionEngine, securityAuthorizationHandler, extendedDatabaseInfoMapper);
    }

    public DependencyResolver copy$default$1() {
        return this.resolver();
    }

    public DefaultDatabaseResolver copy$default$2() {
        return this.defaultDatabaseResolver();
    }

    public ExecutionEngine copy$default$3() {
        return this.normalExecutionEngine();
    }

    public SecurityAuthorizationHandler copy$default$4() {
        return this.securityAuthorizationHandler();
    }

    public String productPrefix() {
        return "ShowDatabasesExecutionPlanner";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.resolver();
            }
            case 1: {
                return this.defaultDatabaseResolver();
            }
            case 2: {
                return this.normalExecutionEngine();
            }
            case 3: {
                return this.securityAuthorizationHandler();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShowDatabasesExecutionPlanner;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "resolver";
            }
            case 1: {
                return "defaultDatabaseResolver";
            }
            case 2: {
                return "normalExecutionEngine";
            }
            case 3: {
                return "securityAuthorizationHandler";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShowDatabasesExecutionPlanner)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShowDatabasesExecutionPlanner showDatabasesExecutionPlanner = (ShowDatabasesExecutionPlanner)x$1;
        DependencyResolver dependencyResolver = this.resolver();
        DependencyResolver dependencyResolver2 = showDatabasesExecutionPlanner.resolver();
        if (dependencyResolver == null) {
            if (dependencyResolver2 != null) {
                return false;
            }
        } else if (!dependencyResolver.equals(dependencyResolver2)) return false;
        DefaultDatabaseResolver defaultDatabaseResolver = this.defaultDatabaseResolver();
        DefaultDatabaseResolver defaultDatabaseResolver2 = showDatabasesExecutionPlanner.defaultDatabaseResolver();
        if (defaultDatabaseResolver == null) {
            if (defaultDatabaseResolver2 != null) {
                return false;
            }
        } else if (!defaultDatabaseResolver.equals(defaultDatabaseResolver2)) return false;
        ExecutionEngine executionEngine = this.normalExecutionEngine();
        ExecutionEngine executionEngine2 = showDatabasesExecutionPlanner.normalExecutionEngine();
        if (executionEngine == null) {
            if (executionEngine2 != null) {
                return false;
            }
        } else if (!executionEngine.equals(executionEngine2)) return false;
        SecurityAuthorizationHandler securityAuthorizationHandler = this.securityAuthorizationHandler();
        SecurityAuthorizationHandler securityAuthorizationHandler2 = showDatabasesExecutionPlanner.securityAuthorizationHandler();
        if (securityAuthorizationHandler == null) {
            if (securityAuthorizationHandler2 != null) {
                return false;
            }
        } else if (!securityAuthorizationHandler.equals(securityAuthorizationHandler2)) return false;
        if (!showDatabasesExecutionPlanner.canEqual(this)) return false;
        return true;
    }

    private static final String optionsOutputMap$1(Set keys, String mapName) {
        List whens = ((List)keys.subsets().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty())).toList().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), (Ordering)Ordering.Int$.MODULE$)).reverse().map((Function1 & Serializable)predicateKeys -> {
            List predicates = (List)((IterableOnceOps)predicateKeys.map((Function1 & Serializable)key -> mapName + "." + key + " IS NULL")).toList().sorted((Ordering)Ordering.String$.MODULE$);
            Set remainingKeys = (Set)keys.$minus$minus((IterableOnce)predicateKeys);
            List entries = (List)((IterableOnceOps)remainingKeys.map((Function1 & Serializable)key -> key + ": " + mapName + "." + key)).toList().sorted((Ordering)Ordering.String$.MODULE$);
            String filteredMap = "{" + entries.mkString(", ") + "}";
            return "WHEN " + predicates.mkString(" AND ") + " THEN " + filteredMap;
        });
        return "CASE " + whens.mkString(System.lineSeparator()) + " ELSE " + mapName + " END";
    }

    public static final /* synthetic */ boolean $anonfun$requiresDetailedLookup$2(ShowDatabasesExecutionPlanner $this, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            String name = variable.name();
            return $this.detailedLookupCols().contains((Object)name);
        }
        return false;
    }

    public ShowDatabasesExecutionPlanner(DependencyResolver resolver, DefaultDatabaseResolver defaultDatabaseResolver, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler, DatabaseInfoMapper<ExtendedDatabaseInfo> extendedDatabaseInfoMapper) {
        this.resolver = resolver;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.normalExecutionEngine = normalExecutionEngine;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
        this.extendedDatabaseInfoMapper = extendedDatabaseInfoMapper;
        Product.$init$((Product)this);
        this.OPTIONS_TX_LOG_ENRICHMENT_KEY = LogEnrichmentOption$.MODULE$.KEY();
        this.OPTIONS_EXISTING_DATA_KEY = ExistingDataOption$.MODULE$.KEY();
        this.OPTIONS_SEED_URI_KEY = SeedURIOption$.MODULE$.KEY();
        this.OPTIONS_SEED_CONFIG_KEY = SeedConfigOption$.MODULE$.KEY();
        this.OPTIONS_SEED_CREDENTIALS_KEY = SeedCredentialsOption$.MODULE$.KEY();
        this.OPTIONS_SEED_INSTANCE_KEY = ExistingSeedInstanceOption$.MODULE$.KEY();
        this.accessibleDbsKey = AdministrationCommandRuntime$.MODULE$.internalKey("accessibleDbs");
        this.dbms = (DatabaseManagementService)resolver.resolveDependency(DatabaseManagementService.class);
        this.infoService = (DatabaseInfoService)resolver.resolveDependency(DatabaseInfoService.class);
        this.referenceResolver = (DatabaseReferenceRepository)resolver.resolveDependency(DatabaseReferenceRepository.class);
        this.detailedLookupCols = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ShowDatabase$.MODULE$.STORE_COL(), ShowDatabase$.MODULE$.LAST_COMMITTED_TX_COL(), ShowDatabase$.MODULE$.REPLICATION_LAG_COL(), ShowDatabase$.MODULE$.CURRENT_PRIMARIES_COUNT_COL(), ShowDatabase$.MODULE$.CURRENT_SECONDARIES_COUNT_COL(), ShowDatabase$.MODULE$.DATABASE_ID_COL()}));
    }
}

