/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.cypher.internal.CacheabilityInfo;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.cache.CacheSize;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.MissingLabelNotification;
import org.neo4j.cypher.internal.compiler.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.compiler.MissingRelTypeNotification;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.ParameterTypeInfo;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0011ma\u0001B-[\u0001\rD\u0001b\u001b\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\tg\u0002\u0011\t\u0011)A\u0005[\"AA\u000f\u0001BC\u0002\u0013\u0005Q\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003w\u0011!Q\bA!b\u0001\n\u0003Y\b\"CA\f\u0001\t\u0005\t\u0015!\u0003}\u0011)\tI\u0002\u0001BC\u0002\u0013\u0005\u00111\u0004\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u0005u\u0001bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\n\u0003w\u0001!\u0019!C\u0001\u0003{A\u0001\"!/\u0001A\u0003%\u0011q\b\u0005\n\u0003w\u0003!\u0019!C\u0005\u0003{C\u0001\"!2\u0001A\u0003%\u0011q\u0018\u0005\b\u0003\u000f\u0004A\u0011AAe\r\u0019\ti\u0006\u0001\u0001\u0002`!Q\u0011\u0011M\b\u0003\u0006\u0004%\t!a\u0019\t\u0015\u0005\u0015tB!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002h=\u0011)\u0019!C\u0001\u0003SB!\"!\u001d\u0010\u0005\u0003\u0005\u000b\u0011BA6\u0011\u001d\tic\u0004C\u0001\u0003gB\u0011\"!\u001f\u0010\u0001\u0004%I!a\u001f\t\u0013\u0005\ru\u00021A\u0005\n\u0005\u0015\u0005\u0002CAI\u001f\u0001\u0006K!! \t\u000f\u0005mu\u0002\"\u0001\u0002\u001e\"9\u0011qT\b\u0005\u0002\u0005m\u0004bBAQ\u001f\u0011\u0005\u00111\u0015\u0005\b\u0003_{A\u0011IAY\u0011\u001d\t)l\u0004C!\u0003oCq!!5\u0001\t\u0003\t\u0019\u000eC\u0005\u0003&\u0001\t\n\u0011\"\u0001\u0003(!9!Q\b\u0001\u0005\n\t}\u0002b\u0002B$\u0001\u0011%!\u0011\n\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u0011I\u0007\u0001C\u0005\u0005WB\u0011Ba\u001e\u0001#\u0003%IA!\u001f\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000!I!\u0011\u0012\u0001\u0012\u0002\u0013%!\u0011\u0010\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u00038\u0002!\t!!3\b\u000f\te&\f#\u0001\u0003<\u001a1\u0011L\u0017E\u0001\u0005{Cq!!\f,\t\u0003\u0011yL\u0002\u0004\u0003B.\u0012%1\u0019\u0005\u000b\u0005?l#Q3A\u0005\u0002\t\u0005\bB\u0003Bv[\tE\t\u0015!\u0003\u0003d\"Q!Q^\u0017\u0003\u0016\u0004%\tAa<\t\u0015\r-RF!E!\u0002\u0013\u0011\t\u0010\u0003\u0006\u0004.5\u0012)\u001a!C\u0001\u0003SB!ba\f.\u0005#\u0005\u000b\u0011BA6\u0011\u001d\ti#\fC\u0001\u0007cA\u0011ba\u000f.\u0003\u0003%\ta!\u0010\t\u0013\r5S&%A\u0005\u0002\r=\u0003\"CB,[E\u0005I\u0011AB-\u0011%\u0019\t'LI\u0001\n\u0003\u0019\u0019\u0007C\u0005\u0004h5\n\t\u0011\"\u0011\u0004j!I1QO\u0017\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0007oj\u0013\u0011!C\u0001\u0007sB\u0011b! .\u0003\u0003%\tea \t\u0013\u0005\u0005V&!A\u0005\u0002\r5\u0005\"CBI[\u0005\u0005I\u0011IBJ\u0011%\t),LA\u0001\n\u0003\n9\fC\u0005\u0004(5\n\t\u0011\"\u0011\u0004\u0018\"I\u0011qV\u0017\u0002\u0002\u0013\u00053\u0011T\u0004\n\u0007;[\u0013\u0011!E\u0001\u0007?3\u0011B!1,\u0003\u0003E\ta!)\t\u000f\u000552\t\"\u0001\u0004.\"I1qE\"\u0002\u0002\u0013\u00153q\u0013\u0005\n\u0007_\u001b\u0015\u0011!CA\u0007cC\u0011b!1D\u0003\u0003%\tia1\t\u0013\ru7)!A\u0005\n\r}\u0007\"CBtW\t\u0007I\u0011ABu\u0011!\u0019\tp\u000bQ\u0001\n\r-hA\u0002B{W\u0001\u00119\u0010\u0003\u0006\u0003z.\u0013)\u0019!C\u0005\u0005wD!ba\u0006L\u0005\u0003\u0005\u000b\u0011\u0002B\u007f\u0011)\u0019Ib\u0013B\u0001B\u0003%\u0011Q\u0010\u0005\t\u0003[YE\u0011A\u0016\u0004\u001c!9\u0011QW&\u0005B\u0005]\u0006bBAX\u0017\u0012\u00053\u0011\u0005\u0005\b\u0007OYE\u0011IB\u0015\u000f\u001d\u0019\u0019p\u000bE\u0001\u0007k4qA!>,\u0011\u0003\u00199\u0010C\u0004\u0002.Q#\ta!?\t\u0013\rmHK1A\u0005\u0006\t=\b\u0002CB\u007f)\u0002\u0006iA!=\t\u000f\r}8\u0006\"\u0001\u0005\u0002\tQ\u0011+^3ss\u000e\u000b7\r[3\u000b\u0005mc\u0016\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005us\u0016AB2za\",'O\u0003\u0002`A\u0006)a.Z85U*\t\u0011-A\u0002pe\u001e\u001c\u0001!F\u0003e\u0003K\t)a\u0005\u0002\u0001KB\u0011a-[\u0007\u0002O*\t\u0001.A\u0003tG\u0006d\u0017-\u0003\u0002kO\n1\u0011I\\=SK\u001a\fAbY1dQ\u00164\u0015m\u0019;pef,\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003aj\u000bQaY1dQ\u0016L!A]8\u0003)\r\u000bgMZ3j]\u0016\u001c\u0015m\u00195f\r\u0006\u001cGo\u001c:z\u00035\u0019\u0017m\u00195f\r\u0006\u001cGo\u001c:zA\u0005YQ.\u0019=j[Vl7+\u001b>f+\u00051\bC\u00018x\u0013\tAxNA\u0005DC\u000eDWmU5{K\u0006aQ.\u0019=j[Vl7+\u001b>fA\u0005y1\u000f^1mK:,7o]\"bY2,'/F\u0001}!\u0011ih0!\u0001\u000e\u0003iK!a .\u0003'Ac\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:\u0011\t\u0005\r\u0011Q\u0001\u0007\u0001\t\u001d\t9\u0001\u0001b\u0001\u0003\u0013\u0011\u0001#\u0012-F\u0007V#\u0016I\u0011'F?F+VIU-\u0012\t\u0005-\u0011\u0011\u0003\t\u0004M\u00065\u0011bAA\bO\n9aj\u001c;iS:<\u0007cA?\u0002\u0014%\u0019\u0011Q\u0003.\u0003!\r\u000b7\r[3bE&d\u0017\u000e^=J]\u001a|\u0017\u0001E:uC2,g.Z:t\u0007\u0006dG.\u001a:!\u0003\u0019!(/Y2feV\u0011\u0011Q\u0004\t\u0006]\u0006}\u00111E\u0005\u0004\u0003Cy'aC\"bG\",GK]1dKJ\u0004B!a\u0001\u0002&\u00119\u0011q\u0005\u0001C\u0002\u0005%\"!C)V\u000bJKvlS#Z#\r\tY!Z\u0001\biJ\f7-\u001a:!\u0003\u0019a\u0014N\\5u}QQ\u0011\u0011GA\u001a\u0003k\t9$!\u000f\u0011\ru\u0004\u00111EA\u0001\u0011\u0015Y\u0017\u00021\u0001n\u0011\u0015!\u0018\u00021\u0001w\u0011\u0015Q\u0018\u00021\u0001}\u0011\u001d\tI\"\u0003a\u0001\u0003;\tqB]3n_Z\fG\u000eT5ti\u0016tWM]\u000b\u0003\u0003\u007f\u0001\u0002\"!\u0011\u0002V\u0005\r\u0012\u0011L\u0007\u0003\u0003\u0007R1\u0001]A#\u0015\u0011\t9%!\u0013\u0002\u0011\r\fgMZ3j]\u0016TA!a\u0013\u0002N\u0005A!-\u001a8nC:,7O\u0003\u0003\u0002P\u0005E\u0013AB4ji\",(M\u0003\u0002\u0002T\u0005\u00191m\\7\n\t\u0005]\u00131\t\u0002\u0010%\u0016lwN^1m\u0019&\u001cH/\u001a8feB\u0019\u00111L\b\u000e\u0003\u0001\u00111bQ1dQ\u0016$g+\u00197vKN\u0011q\"Z\u0001\u0006m\u0006dW/Z\u000b\u0003\u0003\u0003\taA^1mk\u0016\u0004\u0013a\b:fG>l\u0007/\u001b7fI^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]V\u0011\u00111\u000e\t\u0004M\u00065\u0014bAA8O\n9!i\\8mK\u0006t\u0017\u0001\t:fG>l\u0007/\u001b7fI^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]\u0002\"b!!\u0017\u0002v\u0005]\u0004bBA1)\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003O\"\u0002\u0019AA6\u00035yf.^7cKJ|e\rS5ugV\u0011\u0011Q\u0010\t\u0004M\u0006}\u0014bAAAO\n\u0019\u0011J\u001c;\u0002#}sW/\u001c2fe>3\u0007*\u001b;t?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u00065\u0005c\u00014\u0002\n&\u0019\u00111R4\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u001f3\u0012\u0011!a\u0001\u0003{\n1\u0001\u001f\u00132\u00039yf.^7cKJ|e\rS5ug\u0002B3aFAK!\r1\u0017qS\u0005\u0004\u00033;'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u000f5\f'o\u001b%jiR\u0011\u0011qQ\u0001\r]Vl'-\u001a:PM\"KGo]\u0001\tG\u0006tW)];bYR!\u00111NAS\u0011\u001d\t9K\u0007a\u0001\u0003S\u000bQa\u001c;iKJ\u00042AZAV\u0013\r\tik\u001a\u0002\u0004\u0003:L\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002l\u0005M\u0006bBAT7\u0001\u0007\u0011\u0011V\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QP\u0001\u0011e\u0016lwN^1m\u0019&\u001cH/\u001a8fe\u0002\nQ!\u001b8oKJ,\"!a0\u0011\u0011\u0005\u0005\u0013\u0011YA\u0012\u00033JA!a1\u0002D\t)1)Y2iK\u00061\u0011N\u001c8fe\u0002\nQ\"Z:uS6\fG/\u001a3TSj,GCAAf!\r1\u0017QZ\u0005\u0004\u0003\u001f<'\u0001\u0002'p]\u001e\facY8naV$X-\u00134BEN,g\u000e^(s'R\fG.\u001a\u000b\r\u0003\u0003\t).!7\u0002r\u0006m(1\u0002\u0005\b\u0003/l\u0002\u0019AA\u0012\u0003!\tX/\u001a:z\u0017\u0016L\bbBAn;\u0001\u0007\u0011Q\\\u0001\u0003i\u000e\u0004B!a8\u0002n6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/A\u0003rk\u0016\u0014\u0018P\u0003\u0003\u0002h\u0006%\u0018\u0001B5na2T1!a;_\u0003\u0019YWM\u001d8fY&!\u0011q^Aq\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yi\"9\u00111_\u000fA\u0002\u0005U\u0018\u0001C2p[BLG.\u001a:\u0011\u000bu\f90!\u0001\n\u0007\u0005e(LA\u0012D_6\u0004\u0018\u000e\\3s/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o\u001fB$\u0018n\u001c8\t\u000f\u0005uX\u00041\u0001\u0002\u0000\u0006q!/\u001a9mC:\u001cFO]1uK\u001eL\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015!,A\u0004paRLwN\\:\n\t\t%!1\u0001\u0002\u0013\u0007f\u0004\b.\u001a:SKBd\u0017M\\(qi&|g\u000eC\u0005\u0003\u000eu\u0001\n\u00111\u0001\u0003\u0010\u0005AQ.\u001a;b\t\u0006$\u0018\r\u0005\u0003\u0003\u0012\t}a\u0002\u0002B\n\u00057\u00012A!\u0006h\u001b\t\u00119BC\u0002\u0003\u001a\t\fa\u0001\u0010:p_Rt\u0014b\u0001B\u000fO\u00061\u0001K]3eK\u001aLAA!\t\u0003$\t11\u000b\u001e:j]\u001eT1A!\bh\u0003\u0001\u001aw.\u001c9vi\u0016Le-\u00112tK:$xJ]*uC2,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t%\"\u0006\u0002B\b\u0005WY#A!\f\u0011\t\t=\"\u0011H\u0007\u0003\u0005cQAAa\r\u00036\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005o9\u0017AC1o]>$\u0018\r^5p]&!!1\bB\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cS:4\u0018\r\\5e\u001d>$\u0018NZ5dCRLwN\\#ySN$\u0018N\\4\u0015\r\u0005-$\u0011\tB#\u0011\u001d\u0011\u0019e\ba\u0001\u00033\n1bY1dQ\u0016$g+\u00197vK\"9\u00111\\\u0010A\u0002\u0005u\u0017!F5t\u0013:4\u0018\r\\5e\u001d>$\u0018NZ5dCRLwN\u001c\u000b\u0007\u0003W\u0012YEa\u0017\t\u000f\t5\u0003\u00051\u0001\u0003P\u0005aan\u001c;jM&\u001c\u0017\r^5p]B!!\u0011\u000bB,\u001b\t\u0011\u0019FC\u0002\u0003Vi\u000bA!\u001e;jY&!!\u0011\fB*\u0005QIe\u000e^3s]\u0006dgj\u001c;jM&\u001c\u0017\r^5p]\"9\u00111\u001c\u0011A\u0002\u0005u\u0017A\u0004:fG>l\u0007/\u001b7f\u001fJ<U\r\u001e\u000b\u000b\u0003\u0003\u0011\tGa\u0019\u0003f\t\u001d\u0004b\u0002B\"C\u0001\u0007\u0011\u0011\f\u0005\b\u0003g\f\u0003\u0019AA{\u0011\u001d\t9.\ta\u0001\u0003GAqA!\u0004\"\u0001\u0004\u0011y!A\bd_6\u0004\u0018\u000e\\3B]\u0012\u001c\u0015m\u00195f))\t\tA!\u001c\u0003p\tE$1\u000f\u0005\b\u0003/\u0014\u0003\u0019AA\u0012\u0011\u001d\t\u0019P\ta\u0001\u0003kDqA!\u0004#\u0001\u0004\u0011y\u0001C\u0005\u0003v\t\u0002\n\u00111\u0001\u0002l\u0005A\u0001.\u001b;DC\u000eDW-A\rd_6\u0004\u0018\u000e\\3B]\u0012\u001c\u0015m\u00195fI\u0011,g-Y;mi\u0012\"TC\u0001B>U\u0011\tYGa\u000b\u0002I\r|W\u000e]5mK^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]\u0006sGmQ1dQ\u0016$\"\"!\u0001\u0003\u0002\n\r%Q\u0011BD\u0011\u001d\t9\u000e\na\u0001\u0003GAq!a=%\u0001\u0004\t)\u0010C\u0004\u0003\u000e\u0011\u0002\rAa\u0004\t\u0013\tUD\u0005%AA\u0002\u0005-\u0014AL2p[BLG.Z,ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\!oI\u000e\u000b7\r[3%I\u00164\u0017-\u001e7uIQ\nQfY8na&dWm\u0014:D_6\u0004\u0018\u000e\\3XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8B]\u0012\u001c\u0015m\u00195f))\t\tAa$\u0003\u0012\nm%Q\u0014\u0005\b\u0003/4\u0003\u0019AA\u0012\u0011\u001d\u0011\u0019J\na\u0001\u0005+\u000bqaY8na&dW\rE\u0003g\u0005/\u000b\t!C\u0002\u0003\u001a\u001e\u0014\u0011BR;oGRLwN\u001c\u0019\t\u000f\t5a\u00051\u0001\u0003\u0010!9!Q\u000f\u0014A\u0002\u0005-\u0014a\u00015jiRA\u0011\u0011\u0001BR\u0005K\u0013I\u000bC\u0004\u0002X\u001e\u0002\r!a\t\t\u000f\t\u001dv\u00051\u0001\u0002Z\u0005yQ\r_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010C\u0004\u0003\u000e\u001d\u0002\rAa\u0004\u0002\t5L7o\u001d\u000b\t\u0003\u0003\u0011yK!-\u00036\"9\u0011q\u001b\u0015A\u0002\u0005\r\u0002b\u0002BZQ\u0001\u0007\u0011\u0011A\u0001\u0013]\u0016<X\t_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010C\u0004\u0003\u000e!\u0002\rAa\u0004\u0002\u000b\rdW-\u0019:\u0002\u0015E+XM]=DC\u000eDW\r\u0005\u0002~WM\u00111&\u001a\u000b\u0003\u0005w\u0013\u0001bQ1dQ\u0016\\U-_\u000b\u0005\u0005\u000b\u0014)o\u0005\u0004.K\n\u001d'Q\u001a\t\u0004M\n%\u0017b\u0001BfO\n9\u0001K]8ek\u000e$\b\u0003\u0002Bh\u00053tAA!5\u0003V:!!Q\u0003Bj\u0013\u0005A\u0017b\u0001BlO\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bn\u0005;\u0014AbU3sS\u0006d\u0017N_1cY\u0016T1Aa6h\u0003!\tX/\u001a:z%\u0016\u0004XC\u0001Br!\u0011\t\u0019A!:\u0005\u000f\t\u001dXF1\u0001\u0003j\nI\u0011+V#S3~\u0013V\tU\t\u0005\u0003\u0017\tI+A\u0005rk\u0016\u0014\u0018PU3qA\u0005\u0001\u0002/\u0019:b[\u0016$XM\u001d+za\u0016l\u0015\r]\u000b\u0003\u0005c\u00042Aa=L\u001b\u0005Y#\u0001\u0005)be\u0006lW\r^3s)f\u0004X-T1q'\tYU-A\u0005sKN,H\u000e^'baV\u0011!Q \t\t\u0005\u007f\u001c9Aa\u0004\u0004\f5\u00111\u0011\u0001\u0006\u0005\u0005+\u001a\u0019A\u0003\u0002\u0004\u0006\u0005!!.\u0019<b\u0013\u0011\u0019Ia!\u0001\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0004\u000e\rMQBAB\b\u0015\u0011\u0019\tBa\u0015\u0002\u000fMLXNY8mg&!1QCB\b\u0005E\u0001\u0016M]1nKR,'\u000fV=qK&sgm\\\u0001\u000be\u0016\u001cX\u000f\u001c;NCB\u0004\u0013!C0iCND7i\u001c3f)\u0019\u0011\tp!\b\u0004 !9!\u0011`(A\u0002\tu\bbBB\r\u001f\u0002\u0007\u0011Q\u0010\u000b\u0005\u0003W\u001a\u0019\u0003C\u0004\u0004&E\u0003\r!!+\u0002\u0007=\u0014'.\u0001\u0005u_N#(/\u001b8h)\t\u0011y!A\tqCJ\fW.\u001a;feRK\b/Z'ba\u0002\n\u0011\u0003\u001e=Ti\u0006$X\rS1t\u0007\"\fgnZ3t\u0003I!\bp\u0015;bi\u0016D\u0015m]\"iC:<Wm\u001d\u0011\u0015\u0011\rM2QGB\u001c\u0007s\u0001RAa=.\u0005GDqAa85\u0001\u0004\u0011\u0019\u000fC\u0004\u0003nR\u0002\rA!=\t\u000f\r5B\u00071\u0001\u0002l\u0005!1m\u001c9z+\u0011\u0019yd!\u0012\u0015\u0011\r\u00053qIB%\u0007\u0017\u0002RAa=.\u0007\u0007\u0002B!a\u0001\u0004F\u00119!q]\u001bC\u0002\t%\b\"\u0003BpkA\u0005\t\u0019AB\"\u0011%\u0011i/\u000eI\u0001\u0002\u0004\u0011\t\u0010C\u0005\u0004.U\u0002\n\u00111\u0001\u0002l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BB)\u0007+*\"aa\u0015+\t\t\r(1\u0006\u0003\b\u0005O4$\u0019\u0001Bu\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*Baa\u0017\u0004`U\u00111Q\f\u0016\u0005\u0005c\u0014Y\u0003B\u0004\u0003h^\u0012\rA!;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!!\u0011PB3\t\u001d\u00119\u000f\u000fb\u0001\u0005S\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB6!\u0011\u0019iga\u001d\u000e\u0005\r=$\u0002BB9\u0007\u0007\tA\u0001\\1oO&!!\u0011EB8\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!+\u0004|!I\u0011qR\u001e\u0002\u0002\u0003\u0007\u0011QP\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111\u0011\u0011\t\u0007\u0007\u0007\u001bI)!+\u000e\u0005\r\u0015%bABDO\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r-5Q\u0011\u0002\t\u0013R,'/\u0019;peR!\u00111NBH\u0011%\ty)PA\u0001\u0002\u0004\tI+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BB6\u0007+C\u0011\"a$?\u0003\u0003\u0005\r!! \u0015\u0005\r-D\u0003BA6\u00077C\u0011\"a$B\u0003\u0003\u0005\r!!+\u0002\u0011\r\u000b7\r[3LKf\u00042Aa=D'\u0011\u0019Uma)\u0011\t\r\u001561V\u0007\u0003\u0007OSAa!+\u0004\u0004\u0005\u0011\u0011n\\\u0005\u0005\u00057\u001c9\u000b\u0006\u0002\u0004 \u0006)\u0011\r\u001d9msV!11WB])!\u0019)la/\u0004>\u000e}\u0006#\u0002Bz[\r]\u0006\u0003BA\u0002\u0007s#qAa:G\u0005\u0004\u0011I\u000fC\u0004\u0003`\u001a\u0003\raa.\t\u000f\t5h\t1\u0001\u0003r\"91Q\u0006$A\u0002\u0005-\u0014aB;oCB\u0004H._\u000b\u0005\u0007\u000b\u001c)\u000e\u0006\u0003\u0004H\u000e]\u0007#\u00024\u0004J\u000e5\u0017bABfO\n1q\n\u001d;j_:\u0004\u0012BZBh\u0007'\u0014\t0a\u001b\n\u0007\rEwM\u0001\u0004UkBdWm\r\t\u0005\u0003\u0007\u0019)\u000eB\u0004\u0003h\u001e\u0013\rA!;\t\u0013\rew)!AA\u0002\rm\u0017a\u0001=%aA)!1_\u0017\u0004T\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u001d\t\u0005\u0007[\u001a\u0019/\u0003\u0003\u0004f\u000e=$AB(cU\u0016\u001cG/A\u0006O\u001fR{\u0006KU#T\u000b:#VCABv!\ri8Q^\u0005\u0004\u0007_T&aD#yK\u000e,H/\u00192mKF+XM]=\u0002\u00199{Ek\u0018)S\u000bN+e\n\u0016\u0011\u0002!A\u000b'/Y7fi\u0016\u0014H+\u001f9f\u001b\u0006\u0004\bc\u0001Bz)N\u0011A+\u001a\u000b\u0003\u0007k\fQ!Z7qif\fa!Z7qif\u0004\u0013aF3yiJ\f7\r\u001e)be\u0006lW\r^3s)f\u0004X-T1q)\u0019\u0011\t\u0010b\u0001\u0005\u0018!9AQ\u0001-A\u0002\u0011\u001d\u0011\u0001C7baZ\u000bG.^3\u0011\t\u0011%A1C\u0007\u0003\t\u0017QA\u0001\"\u0004\u0005\u0010\u00059a/\u001b:uk\u0006d'b\u0001C\t=\u00061a/\u00197vKNLA\u0001\"\u0006\u0005\f\tAQ*\u00199WC2,X\rC\u0004\u0005\u001aa\u0003\r!a\u001b\u0002\u0017U\u001cXmU5{K\"Kg\u000e\u001e")
public class QueryCache<QUERY_KEY, EXECUTABLE_QUERY extends CacheabilityInfo> {
    private final CaffeineCacheFactory cacheFactory;
    private final CacheSize maximumSize;
    private final PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller;
    private final CacheTracer<QUERY_KEY> tracer;
    private final RemovalListener<QUERY_KEY, CachedValue> removalListener;
    private final Cache<QUERY_KEY, CachedValue> inner;

    public static ParameterTypeMap extractParameterTypeMap(MapValue mapValue, boolean useSizeHint) {
        return QueryCache$.MODULE$.extractParameterTypeMap(mapValue, useSizeHint);
    }

    public static ExecutableQuery NOT_PRESENT() {
        return QueryCache$.MODULE$.NOT_PRESENT();
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public CacheSize maximumSize() {
        return this.maximumSize;
    }

    public PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller() {
        return this.stalenessCaller;
    }

    public CacheTracer<QUERY_KEY> tracer() {
        return this.tracer;
    }

    public RemovalListener<QUERY_KEY, CachedValue> removalListener() {
        return this.removalListener;
    }

    private Cache<QUERY_KEY, CachedValue> inner() {
        return this.inner;
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public EXECUTABLE_QUERY computeIfAbsentOrStale(QUERY_KEY queryKey, TransactionalContext tc, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, CypherReplanOption replanStrategy, String metaData) {
        if (this.maximumSize().currentValue() == 0) {
            CacheabilityInfo result = (CacheabilityInfo)compiler.compile();
            this.tracer().compute(queryKey, metaData);
            return (EXECUTABLE_QUERY)result;
        }
        CachedValue cachedValue = (CachedValue)this.inner().getIfPresent(queryKey);
        ExecutableQuery executableQuery = QueryCache$.MODULE$.NOT_PRESENT();
        CachedValue cachedValue2 = cachedValue;
        if (!(executableQuery != null ? !executableQuery.equals(cachedValue2) : cachedValue2 != null)) {
            CypherReplanOption cypherReplanOption = replanStrategy;
            CypherReplanOption.force$ force$2 = CypherReplanOption.force$.MODULE$;
            if (!(cypherReplanOption != null ? !cypherReplanOption.equals(force$2) : force$2 != null)) {
                return this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4());
            }
            return this.compileAndCache(queryKey, compiler, metaData, this.compileAndCache$default$4());
        }
        cachedValue.markHit();
        CypherReplanOption cypherReplanOption = replanStrategy;
        if (CypherReplanOption.force$.MODULE$.equals(cypherReplanOption)) {
            return this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, true);
        }
        if (CypherReplanOption.skip$.MODULE$.equals(cypherReplanOption)) {
            return this.hit(queryKey, cachedValue, metaData);
        }
        if (CypherReplanOption.default$.MODULE$.equals(cypherReplanOption)) {
            Staleness staleness = this.stalenessCaller().staleness(tc, cachedValue.value());
            if (NotStale$.MODULE$.equals(staleness)) {
                if (this.invalidNotificationExisting(cachedValue, tc)) {
                    return this.compileAndCache(queryKey, compiler, metaData, true);
                }
                return this.recompileOrGet(cachedValue, compiler, queryKey, metaData);
            }
            if (staleness instanceof Stale) {
                Stale stale = (Stale)staleness;
                int secondsSincePlan = stale.secondsSincePlan();
                Option<String> maybeReason = stale.maybeReason();
                this.tracer().cacheStale(queryKey, secondsSincePlan, metaData, maybeReason);
                if (cachedValue.recompiledWithExpressionCodeGen()) {
                    return this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, true);
                }
                return this.compileAndCache(queryKey, compiler, metaData, true);
            }
            throw new MatchError((Object)staleness);
        }
        throw new MatchError((Object)cypherReplanOption);
    }

    public String computeIfAbsentOrStale$default$5() {
        return "";
    }

    private boolean invalidNotificationExisting(CachedValue cachedValue, TransactionalContext tc) {
        IndexedSeq<InternalNotification> notifications = cachedValue.value().notifications();
        for (int i = 0; i < notifications.length(); ++i) {
            if (!this.isInvalidNotification((InternalNotification)notifications.apply(i), tc)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidNotification(InternalNotification notification, TransactionalContext tc) {
        InternalNotification internalNotification = notification;
        if (internalNotification instanceof MissingLabelNotification) {
            MissingLabelNotification missingLabelNotification = (MissingLabelNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().nodeLabel(missingLabelNotification.label()) != -1;
        }
        if (internalNotification instanceof MissingRelTypeNotification) {
            MissingRelTypeNotification missingRelTypeNotification = (MissingRelTypeNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().relationshipType(missingRelTypeNotification.relType()) != -1;
        }
        if (internalNotification instanceof MissingPropertyNameNotification) {
            MissingPropertyNameNotification missingPropertyNameNotification = (MissingPropertyNameNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().propertyKey(missingPropertyNameNotification.name()) != -1;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EXECUTABLE_QUERY recompileOrGet(CachedValue cachedValue, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, QUERY_KEY queryKey, String metaData) {
        CachedValue cachedValue2;
        this.tracer().cacheHit(queryKey, metaData);
        if (!cachedValue.recompiledWithExpressionCodeGen()) {
            Option<EXECUTABLE_QUERY> option = compiler.maybeCompileWithExpressionCodeGen(cachedValue.numberOfHits());
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheabilityInfo recompiledQuery = (CacheabilityInfo)some.value();
                this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
                CachedValue recompiled = new CachedValue(this, recompiledQuery, true);
                this.inner().put(queryKey, (Object)recompiled);
                cachedValue2 = recompiled;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                cachedValue2 = cachedValue;
            }
        } else {
            cachedValue2 = cachedValue;
        }
        CachedValue newCachedValue = cachedValue2;
        return newCachedValue.value();
    }

    private EXECUTABLE_QUERY compileAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compile(), metaData, hitCache);
        this.tracer().compute(queryKey, metaData);
        return result;
    }

    private boolean compileAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compileWithExpressionCodeGen(), metaData, hitCache);
        this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
        return result;
    }

    private boolean compileWithExpressionCodeGenAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileOrCompileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, Function0<EXECUTABLE_QUERY> compile, String metaData, boolean hitCache) {
        CacheabilityInfo newExecutableQuery = (CacheabilityInfo)compile.apply();
        if (newExecutableQuery.shouldBeCached()) {
            CachedValue cachedValue = new CachedValue(this, newExecutableQuery, false);
            this.inner().put(queryKey, (Object)cachedValue);
            if (hitCache) {
                return this.hit(queryKey, cachedValue, metaData);
            }
            return (EXECUTABLE_QUERY)this.miss(queryKey, newExecutableQuery, metaData);
        }
        return (EXECUTABLE_QUERY)this.miss(queryKey, newExecutableQuery, metaData);
    }

    private EXECUTABLE_QUERY hit(QUERY_KEY queryKey, CachedValue executableQuery, String metaData) {
        this.tracer().cacheHit(queryKey, metaData);
        return executableQuery.value();
    }

    private EXECUTABLE_QUERY miss(QUERY_KEY queryKey, EXECUTABLE_QUERY newExecutableQuery, String metaData) {
        this.tracer().cacheMiss(queryKey, metaData);
        return newExecutableQuery;
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer().cacheFlush(priorSize);
        return priorSize;
    }

    public QueryCache(CaffeineCacheFactory cacheFactory, CacheSize maximumSize, PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller, CacheTracer<QUERY_KEY> tracer) {
        this.cacheFactory = cacheFactory;
        this.maximumSize = maximumSize;
        this.stalenessCaller = stalenessCaller;
        this.tracer = tracer;
        this.removalListener = (key, value, cause) -> this.tracer().discard(key, "");
        this.inner = cacheFactory.createCache(maximumSize, this.removalListener());
    }

    public static final class CacheKey<QUERY_REP>
    implements Product,
    Serializable {
        private final QUERY_REP queryRep;
        private final ParameterTypeMap parameterTypeMap;
        private final boolean txStateHasChanges;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public QUERY_REP queryRep() {
            return this.queryRep;
        }

        public ParameterTypeMap parameterTypeMap() {
            return this.parameterTypeMap;
        }

        public boolean txStateHasChanges() {
            return this.txStateHasChanges;
        }

        public <QUERY_REP> CacheKey<QUERY_REP> copy(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            return new CacheKey<QUERY_REP>(queryRep, parameterTypeMap, txStateHasChanges);
        }

        public <QUERY_REP> QUERY_REP copy$default$1() {
            return this.queryRep();
        }

        public <QUERY_REP> ParameterTypeMap copy$default$2() {
            return this.parameterTypeMap();
        }

        public <QUERY_REP> boolean copy$default$3() {
            return this.txStateHasChanges();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.queryRep();
                }
                case 1: {
                    return this.parameterTypeMap();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.txStateHasChanges());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "queryRep";
                }
                case 1: {
                    return "parameterTypeMap";
                }
                case 2: {
                    return "txStateHasChanges";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryRep()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parameterTypeMap()));
            n = Statics.mix((int)n, (int)(this.txStateHasChanges() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            if (this.txStateHasChanges() != cacheKey.txStateHasChanges()) return false;
            if (!BoxesRunTime.equals(this.queryRep(), cacheKey.queryRep())) return false;
            ParameterTypeMap parameterTypeMap = this.parameterTypeMap();
            ParameterTypeMap parameterTypeMap2 = cacheKey.parameterTypeMap();
            if (parameterTypeMap != null) {
                if (!((Object)parameterTypeMap).equals(parameterTypeMap2)) return false;
                return true;
            }
            if (parameterTypeMap2 == null) return true;
            return false;
        }

        public CacheKey(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            this.queryRep = queryRep;
            this.parameterTypeMap = parameterTypeMap;
            this.txStateHasChanges = txStateHasChanges;
            Product.$init$((Product)this);
        }
    }

    public class CachedValue {
        private final EXECUTABLE_QUERY value;
        private final boolean recompiledWithExpressionCodeGen;
        private volatile int _numberOfHits;
        public final /* synthetic */ QueryCache $outer;

        public EXECUTABLE_QUERY value() {
            return this.value;
        }

        public boolean recompiledWithExpressionCodeGen() {
            return this.recompiledWithExpressionCodeGen;
        }

        private int _numberOfHits() {
            return this._numberOfHits;
        }

        private void _numberOfHits_$eq(int x$1) {
            this._numberOfHits = x$1;
        }

        public void markHit() {
            if (!this.recompiledWithExpressionCodeGen()) {
                this._numberOfHits_$eq(this._numberOfHits() + 1);
                return;
            }
        }

        public int numberOfHits() {
            return this._numberOfHits();
        }

        public boolean canEqual(Object other) {
            return other instanceof CachedValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CachedValue)) return false;
            if (((CachedValue)object).org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() != this.org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer()) return false;
            CachedValue cachedValue = (CachedValue)object;
            if (!cachedValue.canEqual(this)) return false;
            Object EXECUTABLE_QUERY = this.value();
            Object EXECUTABLE_QUERY2 = cachedValue.value();
            if (EXECUTABLE_QUERY != null) {
                if (!EXECUTABLE_QUERY.equals(EXECUTABLE_QUERY2)) return false;
                return true;
            }
            if (EXECUTABLE_QUERY2 == null) return true;
            return false;
        }

        public int hashCode() {
            .colon.colon state = new .colon.colon(this.value(), (List)Nil$.MODULE$);
            return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
        }

        public /* synthetic */ QueryCache org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public CachedValue(EXECUTABLE_QUERY value, boolean recompiledWithExpressionCodeGen) {
            this.value = value;
            this.recompiledWithExpressionCodeGen = recompiledWithExpressionCodeGen;
            if ($outer == null) {
                throw null;
            }
            this.$outer = (QueryCache)$outer;
            this._numberOfHits = 0;
        }
    }

    public static class ParameterTypeMap {
        private final Map<String, ParameterTypeInfo> resultMap;
        private final int _hashCode;

        private Map<String, ParameterTypeInfo> resultMap() {
            return this.resultMap;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof ParameterTypeMap) {
                ParameterTypeMap parameterTypeMap = (ParameterTypeMap)object;
                if (this.resultMap().size() == parameterTypeMap.resultMap().size()) {
                    Map<String, ParameterTypeInfo> otherMap = parameterTypeMap.resultMap();
                    java.util.Iterator<Map.Entry<String, ParameterTypeInfo>> entries = otherMap.entrySet().iterator();
                    boolean stillEqual = true;
                    while (entries.hasNext() && stillEqual) {
                        Map.Entry<String, ParameterTypeInfo> entry = entries.next();
                        String otherKey = entry.getKey();
                        ParameterTypeInfo otherValue = entry.getValue();
                        ParameterTypeInfo value = this.resultMap().get(otherKey);
                        stillEqual = otherValue.equals((Object)value);
                    }
                    return stillEqual;
                }
            }
            return false;
        }

        public String toString() {
            return CollectionConverters$.MODULE$.MapHasAsScala(this.resultMap()).asScala().toString();
        }

        public ParameterTypeMap(Map<String, ParameterTypeInfo> resultMap, int _hashCode) {
            this.resultMap = resultMap;
            this._hashCode = _hashCode;
        }
    }
}

