/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ComposedSourceCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ListCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansionCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.DirectedTypes;
import org.neo4j.storageengine.api.RelationshipDirection;

public class ProductGraphTraversalCursor
implements AutoCloseable {
    private long originNodeId = -1L;
    private boolean initialized = false;
    private final DirectedTypes directedTypes;
    private RelationshipTraversalCursor traversalCursor;
    private final ComposedSourceCursor<List<State>, State, RelationshipExpansion> nfaCursor;

    public ProductGraphTraversalCursor(RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker) {
        this.traversalCursor = relCursor;
        this.nfaCursor = new ComposedSourceCursor(new ListCursor(), new RelationshipExpansionCursor());
        this.directedTypes = new DirectedTypes(memoryTracker);
    }

    public State targetState() {
        return this.nfaCursor.current().targetState();
    }

    public State currentInputState() {
        return this.nfaCursor.currentIntermediate();
    }

    public long otherNodeReference() {
        return this.traversalCursor.otherNodeReference();
    }

    public long relationshipReference() {
        return this.traversalCursor.reference();
    }

    public RelationshipExpansion relationshipExpansion() {
        return this.nfaCursor.current();
    }

    public boolean next() {
        if (!this.initialized) {
            if (!this.nextRelationship()) {
                return false;
            }
            this.initialized = true;
        }
        while (true) {
            if (this.nfaCursor.next()) {
                if (!this.evaluateCurrent()) continue;
                return true;
            }
            if (!this.nextRelationship()) break;
        }
        return false;
    }

    private boolean nextRelationship() {
        this.nfaCursor.reset();
        return this.traversalCursor.next();
    }

    private boolean evaluateCurrent() {
        RelationshipExpansion expansion = this.nfaCursor.current();
        RelationshipDirection currentDirection = RelationshipDirection.directionOfStrict((long)this.originNodeId, (long)this.traversalCursor.sourceNodeReference(), (long)this.traversalCursor.targetNodeReference());
        return currentDirection.matches(expansion.direction()) && (expansion.types() == null || ArrayUtils.contains((int[])expansion.types(), (int)this.traversalCursor.type())) && expansion.testRelationship(this.traversalCursor) && expansion.testNode(this.traversalCursor.otherNodeReference());
    }

    public void setNodeAndStates(NodeCursor node, List<State> states) {
        this.initialized = false;
        this.originNodeId = node.nodeReference();
        this.nfaCursor.setSource(states);
        this.directedTypes.clear();
        while (this.nfaCursor.next()) {
            RelationshipExpansion expansion = this.nfaCursor.current();
            this.directedTypes.addTypes(expansion.types(), expansion.direction());
        }
        this.nfaCursor.reset();
        RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)this.traversalCursor, (NodeCursor)node, (DirectedTypes)this.directedTypes);
    }

    @Override
    public void close() throws Exception {
        this.nfaCursor.close();
    }
}

