/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValues;
import org.neo4j.values.Comparison;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.opencypher.v9_0.util.CypherTypeException;
import org.opencypher.v9_0.util.InternalException;
import org.opencypher.v9_0.util.InvalidSemanticsException;

public final class CypherBoolean {
    private static final BooleanMapper BOOLEAN_MAPPER = new BooleanMapper();

    private CypherBoolean() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static Value xor(AnyValue lhs, AnyValue rhs) {
        return lhs == Values.TRUE ^ rhs == Values.TRUE ? Values.TRUE : Values.FALSE;
    }

    public static Value not(AnyValue in) {
        return in != Values.TRUE ? Values.TRUE : Values.FALSE;
    }

    public static Value equals(AnyValue lhs, AnyValue rhs) {
        Boolean compare = lhs.ternaryEquals(rhs);
        if (compare == null) {
            return Values.NO_VALUE;
        }
        return compare != false ? Values.TRUE : Values.FALSE;
    }

    public static Value notEquals(AnyValue lhs, AnyValue rhs) {
        Boolean compare = lhs.ternaryEquals(rhs);
        if (compare == null) {
            return Values.NO_VALUE;
        }
        return compare != false ? Values.FALSE : Values.TRUE;
    }

    public static BooleanValue regex(TextValue lhs, TextValue rhs) {
        String regexString = rhs.stringValue();
        try {
            boolean matches = Pattern.compile(regexString).matcher(lhs.stringValue()).matches();
            return matches ? Values.TRUE : Values.FALSE;
        }
        catch (PatternSyntaxException e) {
            throw new InvalidSemanticsException("Invalid Regex: " + e.getMessage());
        }
    }

    public static BooleanValue regex(TextValue text, Pattern pattern) {
        boolean matches = pattern.matcher(text.stringValue()).matches();
        return matches ? Values.TRUE : Values.FALSE;
    }

    public static Value lessThan(AnyValue lhs, AnyValue rhs) {
        if (CypherBoolean.isNan(lhs) || CypherBoolean.isNan(rhs)) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TextValue && rhs instanceof TextValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof BooleanValue && rhs instanceof BooleanValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateValue && rhs instanceof DateValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalTimeValue && rhs instanceof LocalTimeValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TimeValue && rhs instanceof TimeValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalDateTimeValue && rhs instanceof LocalDateTimeValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateTimeValue && rhs instanceof DateTimeValue) {
            return CypherBoolean.lessThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        return Values.NO_VALUE;
    }

    public static Value lessThanOrEqual(AnyValue lhs, AnyValue rhs) {
        if (CypherBoolean.isNan(lhs) || CypherBoolean.isNan(rhs)) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TextValue && rhs instanceof TextValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof BooleanValue && rhs instanceof BooleanValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateValue && rhs instanceof DateValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalTimeValue && rhs instanceof LocalTimeValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TimeValue && rhs instanceof TimeValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalDateTimeValue && rhs instanceof LocalDateTimeValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateTimeValue && rhs instanceof DateTimeValue) {
            return CypherBoolean.lessThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        return Values.NO_VALUE;
    }

    public static Value greaterThan(AnyValue lhs, AnyValue rhs) {
        if (CypherBoolean.isNan(lhs) || CypherBoolean.isNan(rhs)) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TextValue && rhs instanceof TextValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof BooleanValue && rhs instanceof BooleanValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateValue && rhs instanceof DateValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalTimeValue && rhs instanceof LocalTimeValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TimeValue && rhs instanceof TimeValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalDateTimeValue && rhs instanceof LocalDateTimeValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateTimeValue && rhs instanceof DateTimeValue) {
            return CypherBoolean.greaterThan(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        return Values.NO_VALUE;
    }

    public static Value greaterThanOrEqual(AnyValue lhs, AnyValue rhs) {
        if (CypherBoolean.isNan(lhs) || CypherBoolean.isNan(rhs)) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TextValue && rhs instanceof TextValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof BooleanValue && rhs instanceof BooleanValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateValue && rhs instanceof DateValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalTimeValue && rhs instanceof LocalTimeValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof TimeValue && rhs instanceof TimeValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof LocalDateTimeValue && rhs instanceof LocalDateTimeValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        if (lhs instanceof DateTimeValue && rhs instanceof DateTimeValue) {
            return CypherBoolean.greaterThanOrEqual(AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs));
        }
        return Values.NO_VALUE;
    }

    public static Value coerceToBoolean(AnyValue value) {
        return (Value)value.map((ValueMapper)BOOLEAN_MAPPER);
    }

    private static Value lessThan(Comparison comparison) {
        switch (comparison) {
            case GREATER_THAN_AND_EQUAL: 
            case GREATER_THAN: 
            case EQUAL: 
            case SMALLER_THAN_AND_EQUAL: {
                return Values.FALSE;
            }
            case SMALLER_THAN: {
                return Values.TRUE;
            }
            case UNDEFINED: {
                return Values.NO_VALUE;
            }
        }
        throw new InternalException(comparison + " is not a known comparison", null);
    }

    private static Value lessThanOrEqual(Comparison comparison) {
        switch (comparison) {
            case GREATER_THAN_AND_EQUAL: 
            case GREATER_THAN: {
                return Values.FALSE;
            }
            case EQUAL: 
            case SMALLER_THAN_AND_EQUAL: 
            case SMALLER_THAN: {
                return Values.TRUE;
            }
            case UNDEFINED: {
                return Values.NO_VALUE;
            }
        }
        throw new InternalException(comparison + " is not a known comparison", null);
    }

    private static Value greaterThanOrEqual(Comparison comparison) {
        switch (comparison) {
            case GREATER_THAN_AND_EQUAL: 
            case GREATER_THAN: 
            case EQUAL: {
                return Values.TRUE;
            }
            case SMALLER_THAN_AND_EQUAL: 
            case SMALLER_THAN: {
                return Values.FALSE;
            }
            case UNDEFINED: {
                return Values.NO_VALUE;
            }
        }
        throw new InternalException(comparison + " is not a known comparison", null);
    }

    private static Value greaterThan(Comparison comparison) {
        switch (comparison) {
            case GREATER_THAN: {
                return Values.TRUE;
            }
            case GREATER_THAN_AND_EQUAL: 
            case EQUAL: 
            case SMALLER_THAN_AND_EQUAL: 
            case SMALLER_THAN: {
                return Values.FALSE;
            }
            case UNDEFINED: {
                return Values.NO_VALUE;
            }
        }
        throw new InternalException(comparison + " is not a known comparison", null);
    }

    private static boolean isNan(AnyValue value) {
        return value instanceof FloatingPointValue && ((FloatingPointValue)value).isNaN();
    }

    private static final class BooleanMapper
    implements ValueMapper<Value> {
        private BooleanMapper() {
        }

        public Value mapPath(PathValue value) {
            return value.size() > 0 ? Values.TRUE : Values.FALSE;
        }

        public Value mapNode(VirtualNodeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapRelationship(VirtualRelationshipValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapMap(MapValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapNoValue() {
            return Values.NO_VALUE;
        }

        public Value mapSequence(SequenceValue value) {
            return value.length() > 0 ? Values.TRUE : Values.FALSE;
        }

        public Value mapText(TextValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapBoolean(BooleanValue value) {
            return value;
        }

        public Value mapNumber(NumberValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapDateTime(DateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapLocalDateTime(LocalDateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapDate(DateValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapTime(TimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapLocalTime(LocalTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapDuration(DurationValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapPoint(PointValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }
    }
}

