/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.AdministrationCommand;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnionAll;
import org.neo4j.cypher.internal.ast.UnionDistinct;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.StatementConverters$;
import org.neo4j.cypher.internal.compiler.phases.CompilationContains;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState$;
import org.neo4j.cypher.internal.expressions.AutoExtractedParameter;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.frontend.PlannerName;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Namespacer$;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.StatementCondition;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.collapseMultipleInPredicates$;
import org.neo4j.cypher.internal.frontend.phases.factories.PlanPipelineTransformerFactory;
import org.neo4j.cypher.internal.frontend.phases.rewriting.cnf.CNFNormalizer$;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.rewriting.ValidatingCondition;
import org.neo4j.cypher.internal.rewriting.conditions.aggregationsAreIsolated$;
import org.neo4j.cypher.internal.rewriting.conditions.containsNamedPathOnlyForShortestPath$;
import org.neo4j.cypher.internal.rewriting.conditions.containsNoNodesOfType;
import org.neo4j.cypher.internal.rewriting.conditions.package$;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.exceptions.DatabaseAdministrationException;
import org.neo4j.exceptions.InternalException;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class CreatePlannerQuery$
implements Phase<BaseContext, BaseState, LogicalPlanState>,
StepSequencer.Step,
PlanPipelineTransformerFactory,
Product,
Serializable {
    public static final CreatePlannerQuery$ MODULE$ = new CreatePlannerQuery$();

    static {
        Transformer.$init$((Transformer)MODULE$);
        Phase.$init$((Phase)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, LogicalPlanState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions) {
        return Transformer.checkConditions$((Transformer)this, (Object)state, conditions);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public LogicalPlanState process(BaseState from, BaseContext context) {
        Statement statement = from.statement();
        if (statement instanceof Query) {
            Query query = (Query)statement;
            PlannerQuery plannerQuery = StatementConverters$.MODULE$.toPlannerQuery(query, from.semanticTable(), from.anonymousVariableNameGenerator(), context.cancellationChecker(), StatementConverters$.MODULE$.toPlannerQuery$default$5(), StatementConverters$.MODULE$.toPlannerQuery$default$6(), StatementConverters$.MODULE$.toPlannerQuery$default$7());
            LogicalPlanState qual$1 = LogicalPlanState$.MODULE$.apply(from);
            Some x$1 = new Some((Object)plannerQuery);
            String x$2 = qual$1.copy$default$1();
            Option<InputPosition> x$3 = qual$1.copy$default$2();
            PlannerName x$4 = qual$1.copy$default$3();
            PlanningAttributes x$5 = qual$1.copy$default$4();
            AnonymousVariableNameGenerator x$6 = qual$1.copy$default$5();
            Option<Object> x$7 = qual$1.copy$default$6();
            Option<Statement> x$8 = qual$1.copy$default$7();
            Option<SemanticState> x$9 = qual$1.copy$default$8();
            Option<Map<AutoExtractedParameter, Expression>> x$10 = qual$1.copy$default$9();
            Option<SemanticTable> x$11 = qual$1.copy$default$10();
            Option<LogicalPlan> x$12 = qual$1.copy$default$12();
            Set<StepSequencer.Condition> x$13 = qual$1.copy$default$13();
            boolean x$14 = qual$1.copy$default$14();
            Option<Seq<String>> x$15 = qual$1.copy$default$15();
            Option<ObfuscationMetadata> x$16 = qual$1.copy$default$16();
            return qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option<PlannerQuery>)x$1, x$12, x$13, x$14, x$15, x$16);
        }
        if (statement instanceof AdministrationCommand) {
            AdministrationCommand administrationCommand = (AdministrationCommand)statement;
            throw new DatabaseAdministrationException("This is an administration command and it should be executed against the system database: " + administrationCommand.name());
        }
        throw new InternalException("Expected a Query and not `" + statement + "`");
    }

    public Set<StepSequencer.Condition> preConditions() {
        return (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new StatementCondition((ValidatingCondition)containsNamedPathOnlyForShortestPath$.MODULE$), new StatementCondition((ValidatingCondition)new containsNoNodesOfType(ClassTag$.MODULE$.apply(UnionAll.class))), new StatementCondition((ValidatingCondition)new containsNoNodesOfType(ClassTag$.MODULE$.apply(UnionDistinct.class))), Namespacer$.MODULE$.completed(), new StatementCondition((ValidatingCondition)aggregationsAreIsolated$.MODULE$), collapseMultipleInPredicates$.MODULE$.completed()}))).$plus$plus((IterableOnce)CNFNormalizer$.MODULE$.PredicatesInCNF()).$plus$plus((IterableOnce)package$.MODULE$.SemanticInfoAvailable());
    }

    public Set<StepSequencer.Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new CompilationContains(ClassTag$.MODULE$.apply(PlannerQuery.class))}));
    }

    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    public Transformer<BaseContext, BaseState, LogicalPlanState> getTransformer(boolean pushdownPropertyReads, Seq<SemanticFeature> semanticFeatures) {
        return this;
    }

    public String productPrefix() {
        return "CreatePlannerQuery";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreatePlannerQuery$;
    }

    public int hashCode() {
        return -1598443182;
    }

    public String toString() {
        return "CreatePlannerQuery";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CreatePlannerQuery$.class);
    }

    private CreatePlannerQuery$() {
    }
}

