/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.planner.logical.ExpressionEvaluator;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.StatisticsBackedCardinalityModel$;
import org.neo4j.cypher.internal.compiler.planner.logical.schema.GraphSchemaOptimizations;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.ir.AbstractProcedureCallProjection;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.CommandProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.QueryProjection;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.RunQueryAtProjection;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.Multiplier;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.helpers.MapSupport$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r]c\u0001\u0002\u00192\u0001\u0001C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"Aq\r\u0001B\u0001B\u0003%\u0001\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003s\u0001\u0011\u00053\u000fC\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005b\u0002B{\u0001\u0011%!q\u001f\u0005\b\u0007\u000b\u0001A\u0011BB\u0004\u0011\u001d\u00199\u0002\u0001C\u0005\u00073Aqa!\t\u0001\t\u0013\u0019\u0019\u0003C\u0004\u0004>\u0001!Iaa\u0010\b\u000f\u0005-\u0015\u0007#\u0001\u0002\u000e\u001a1\u0001'\rE\u0001\u0003\u001fCa\u0001\\\b\u0005\u0002\u0005EeABAJ\u001f\u0001\u000b)\n\u0003\u0006\u00020F\u0011)\u001a!C\u0001\u0003cC\u0011\"a-\u0012\u0005#\u0005\u000b\u0011\u0002;\t\u0015\u0005\u001d\u0011C!f\u0001\n\u0003\t)\f\u0003\u0006\u00028F\u0011\t\u0012)A\u0005\u0003\u0013A!\"!\u0005\u0012\u0005+\u0007I\u0011AA]\u0011)\tY,\u0005B\tB\u0003%\u00111\u0003\u0005\u0007YF!\t!!0\t\u000f\u0005%\u0017\u0003\"\u0001\u0002L\"9\u0011\u0011[\t\u0005\u0002\u0005M\u0007\"CAm#\u0005\u0005I\u0011AAn\u0011%\t\u0019/EI\u0001\n\u0003\t)\u000fC\u0005\u0002|F\t\n\u0011\"\u0001\u0002~\"I!\u0011A\t\u0012\u0002\u0013\u0005!1\u0001\u0005\n\u0005\u000f\t\u0012\u0011!C!\u0005\u0013A\u0011Ba\u0007\u0012\u0003\u0003%\tA!\b\t\u0013\t\u0015\u0012#!A\u0005\u0002\t\u001d\u0002\"\u0003B\u001a#\u0005\u0005I\u0011\tB\u001b\u0011%\u0011\u0019%EA\u0001\n\u0003\u0011)\u0005C\u0005\u0003PE\t\t\u0011\"\u0011\u0003R!I!QK\t\u0002\u0002\u0013\u0005#q\u000b\u0005\n\u00053\n\u0012\u0011!C!\u00057B\u0011B!\u0018\u0012\u0003\u0003%\tEa\u0018\b\u0013\t\rt\"!A\t\u0002\t\u0015d!CAJ\u001f\u0005\u0005\t\u0012\u0001B4\u0011\u0019a\u0017\u0006\"\u0001\u0003\u0000!I!\u0011L\u0015\u0002\u0002\u0013\u0015#1\f\u0005\te&\n\t\u0011\"!\u0003\u0002\"I!\u0011R\u0015\u0002\u0002\u0013\u0005%1\u0012\u0005\n\u0005;K\u0013\u0011!C\u0005\u0005?CqAa*\u0010\t\u0003\u0011IK\u0001\u0011Ti\u0006$\u0018n\u001d;jGN\u0014\u0015mY6fI\u000e\u000b'\u000fZ5oC2LG/_'pI\u0016d'B\u0001\u001a4\u0003\u001dawnZ5dC2T!\u0001N\u001b\u0002\u000fAd\u0017M\u001c8fe*\u0011agN\u0001\tG>l\u0007/\u001b7fe*\u0011\u0001(O\u0001\tS:$XM\u001d8bY*\u0011!hO\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005qj\u0014!\u00028f_RR'\"\u0001 \u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tu\t\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15I\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0011rs!!\u0013.\u000f\u0005)KfBA&Y\u001d\tauK\u0004\u0002N-:\u0011a*\u0016\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!AU \u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014B\u0001\u001f>\u0013\tQ4(\u0003\u00029s%\u0011agN\u0005\u0003iUJ!AM\u001a\n\u0005m\u000b\u0014aB'fiJL7m]\u0005\u0003;z\u0013\u0001cQ1sI&t\u0017\r\\5us6{G-\u001a7\u000b\u0005m\u000b\u0014AG9vKJLxI]1qQ\u000e\u000b'\u000fZ5oC2LG/_'pI\u0016d\u0007C\u0001%b\u0013\t\u0011gL\u0001\u000eRk\u0016\u0014\u0018p\u0012:ba\"\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=N_\u0012,G.A\u000btK2,7\r^5wSRL8)\u00197dk2\fGo\u001c:\u0011\u0005!+\u0017B\u00014_\u0005U\u0019V\r\\3di&4\u0018\u000e^=DC2\u001cW\u000f\\1u_J\f\u0011d]5na2,W\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;peB\u0011\u0011N[\u0007\u0002c%\u00111.\r\u0002\u0014\u000bb\u0004(/Z:tS>tWI^1mk\u0006$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t9|\u0007/\u001d\t\u0003S\u0002AQa\u0018\u0003A\u0002\u0001DQa\u0019\u0003A\u0002\u0011DQa\u001a\u0003A\u0002!\fQ!\u00199qYf$b\u0002\u001e>\u0002\u0006\u0005=\u0011\u0011DA\u0017\u0003\u0003\n)\u0005\u0005\u0002vq6\taO\u0003\u0002xo\u0005!Q\u000f^5m\u0013\tIhOA\u0006DCJ$\u0017N\\1mSRL\b\"B>\u0006\u0001\u0004a\u0018!B9vKJL\bcA?\u0002\u00025\taP\u0003\u0002\u0000o\u0005\u0011\u0011N]\u0005\u0004\u0003\u0007q(\u0001\u0004)mC:tWM])vKJL\bbBA\u0004\u000b\u0001\u0007\u0011\u0011B\u0001\nY\u0006\u0014W\r\\%oM>\u00042\u0001SA\u0006\u0013\r\tiA\u0018\u0002\n\u0019\u0006\u0014W\r\\%oM>Dq!!\u0005\u0006\u0001\u0004\t\u0019\"A\u0006sK2$\u0016\u0010]3J]\u001a|\u0007c\u0001%\u0002\u0016%\u0019\u0011q\u00030\u0003\u0017I+G\u000eV=qK&sgm\u001c\u0005\b\u00037)\u0001\u0019AA\u000f\u00035\u0019X-\\1oi&\u001cG+\u00192mKB!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!C:f[\u0006tG/[2t\u0015\r\t9cN\u0001\u0004CN$\u0018\u0002BA\u0016\u0003C\u0011QbU3nC:$\u0018n\u0019+bE2,\u0007bBA\u0018\u000b\u0001\u0007\u0011\u0011G\u0001\u001eS:$W\r\u001f)sK\u0012L7-\u0019;f!J|g/\u001b3fe\u000e{g\u000e^3yiB!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!B5oI\u0016D(bAA\u001ec\u0005)1\u000f^3qg&!\u0011qHA\u001b\u0005!Je\u000eZ3y\u0007>l\u0007/\u0019;jE2,\u0007K]3eS\u000e\fG/Z:Qe>4\u0018\u000eZ3s\u0007>tG/\u001a=u\u0011\u0019\t\u0019%\u0002a\u0001\u000f\u0006\u00012-\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\u0005\b\u0003\u000f*\u0001\u0019AA%\u0003a9'/\u00199i'\u000eDW-\\1PaRLW.\u001b>bi&|gn\u001d\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ\u0019\u0002\rM\u001c\u0007.Z7b\u0013\u0011\t\u0019&!\u0014\u00031\u001d\u0013\u0018\r\u001d5TG\",W.Y(qi&l\u0017N_1uS>t7/A\u000ftS:<G.\u001a)mC:tWM])vKJL8)\u0019:eS:\fG.\u001b;z)=!\u0018\u0011LA1\u0003G\n)'a\u001a\u0002j\u0005-\u0004BB>\u0007\u0001\u0004\tY\u0006E\u0002~\u0003;J1!a\u0018\u007f\u0005I\u0019\u0016N\\4mKBc\u0017M\u001c8feF+XM]=\t\u000f\u0005\u001da\u00011\u0001\u0002\n!9\u0011\u0011\u0003\u0004A\u0002\u0005M\u0001bBA\u000e\r\u0001\u0007\u0011Q\u0004\u0005\b\u0003_1\u0001\u0019AA\u0019\u0011\u0019\t\u0019E\u0002a\u0001\u000f\"9\u0011q\t\u0004A\u0002\u0005%\u0013\u0001D2p[\nLg.Z+oS>tGc\u0002;\u0002r\u0005m\u0014q\u0010\u0005\b\u0003g:\u0001\u0019AA;\u0003))h.[8o#V,'/\u001f\t\u0004{\u0006]\u0014bAA=}\nQQK\\5p]F+XM]=\t\r\u0005ut\u00011\u0001u\u00039a\u0007n]\"be\u0012Lg.\u00197jifDa!!!\b\u0001\u0004!\u0018A\u0004:ig\u000e\u000b'\u000fZ5oC2LG/_\u0001$G\u0006d7-\u001e7bi\u0016\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=G_J\fV/\u001a:z\u0011>\u0014\u0018N_8o)A\t9I!6\u0003Z\n\r(Q\u001dBt\u0005S\u0014\u0019\u0010E\u0002\u0002\nFq!!\u0013\b\u0002AM#\u0018\r^5ti&\u001c7OQ1dW\u0016$7)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\t\u0003S>\u0019\"aD!\u0015\u0005\u00055%aE\"be\u0012Lg.\u00197jif\fe\u000eZ%oaV$8CB\tB\u0003/\u000bi\nE\u0002C\u00033K1!a'D\u0005\u001d\u0001&o\u001c3vGR\u0004B!a(\u0002*:!\u0011\u0011UAS\u001d\r\u0001\u00161U\u0005\u0002\t&\u0019\u0011qU\"\u0002\u000fA\f7m[1hK&!\u00111VAW\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t9kQ\u0001\fG\u0006\u0014H-\u001b8bY&$\u00180F\u0001u\u00031\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=!+\t\tI!\u0001\u0006mC\n,G.\u00138g_\u0002*\"!a\u0005\u0002\u0019I,G\u000eV=qK&sgm\u001c\u0011\u0015\u0011\u0005}\u00161YAc\u0003\u000f\u00042!!1\u0012\u001b\u0005y\u0001BBAX1\u0001\u0007A\u000fC\u0004\u0002\ba\u0001\r!!\u0003\t\u000f\u0005E\u0001\u00041\u0001\u0002\u0014\u0005\u0011r/\u001b;i\rV\u001cX\r\u001a'bE\u0016d\u0017J\u001c4p)\u0011\ty,!4\t\u000f\u0005=\u0017\u00041\u0001\u0002\n\u0005aa.Z<MC\n,G.\u00138g_\u0006!r/\u001b;i\rV\u001cX\r\u001a*fYRK\b/Z%oM>$B!a0\u0002V\"9\u0011q\u001b\u000eA\u0002\u0005M\u0011A\u00048foJ+G\u000eV=qK&sgm\\\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002@\u0006u\u0017q\\Aq\u0011!\tyk\u0007I\u0001\u0002\u0004!\b\"CA\u00047A\u0005\t\u0019AA\u0005\u0011%\t\tb\u0007I\u0001\u0002\u0004\t\u0019\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d(f\u0001;\u0002j.\u0012\u00111\u001e\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003%)hn\u00195fG.,GMC\u0002\u0002v\u000e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI0a<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}(\u0006BA\u0005\u0003S\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0006)\"\u00111CAu\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0002\t\u0005\u0005\u001b\u00119\"\u0004\u0002\u0003\u0010)!!\u0011\u0003B\n\u0003\u0011a\u0017M\\4\u000b\u0005\tU\u0011\u0001\u00026bm\u0006LAA!\u0007\u0003\u0010\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\b\u0011\u0007\t\u0013\t#C\u0002\u0003$\r\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u000b\u00030A\u0019!Ia\u000b\n\u0007\t52IA\u0002B]fD\u0011B!\r\"\u0003\u0003\u0005\rAa\b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0004\u0005\u0004\u0003:\t}\"\u0011F\u0007\u0003\u0005wQ1A!\u0010D\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0003\u0012YD\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B$\u0005\u001b\u00022A\u0011B%\u0013\r\u0011Ye\u0011\u0002\b\u0005>|G.Z1o\u0011%\u0011\tdIA\u0001\u0002\u0004\u0011I#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u0006\u0005'B\u0011B!\r%\u0003\u0003\u0005\rAa\b\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0003\u0002\r\u0015\fX/\u00197t)\u0011\u00119E!\u0019\t\u0013\tEr%!AA\u0002\t%\u0012aE\"be\u0012Lg.\u00197jif\fe\u000eZ%oaV$\bcAAaSM)\u0011F!\u001b\u0003vAY!1\u000eB9i\u0006%\u00111CA`\u001b\t\u0011iGC\u0002\u0003p\r\u000bqA];oi&lW-\u0003\u0003\u0003t\t5$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!!q\u000fB?\u001b\t\u0011IH\u0003\u0003\u0003|\tM\u0011AA5p\u0013\u0011\tYK!\u001f\u0015\u0005\t\u0015D\u0003CA`\u0005\u0007\u0013)Ia\"\t\r\u0005=F\u00061\u0001u\u0011\u001d\t9\u0001\fa\u0001\u0003\u0013Aq!!\u0005-\u0001\u0004\t\u0019\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5%\u0011\u0014\t\u0006\u0005\n=%1S\u0005\u0004\u0005#\u001b%AB(qi&|g\u000e\u0005\u0005C\u0005+#\u0018\u0011BA\n\u0013\r\u00119j\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tmU&!AA\u0002\u0005}\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0015\t\u0005\u0005\u001b\u0011\u0019+\u0003\u0003\u0003&\n=!AB(cU\u0016\u001cG/\u0001\u0010bO\u001e\u0014XmZ1uK\u000e\u000b'\u000fZ5oC2LG/_#ti&l\u0017\r^5p]R)AOa+\u00030\"1!QV\u0018A\u0002Q\f!!\u001b8\t\u000f\tEv\u00061\u0001\u00034\u0006\u0019rM]8va&tw-\u0012=qe\u0016\u001c8/[8ogBA!Q\u0017B_\u0005\u0007\u0014yM\u0004\u0003\u00038\ne\u0006C\u0001)D\u0013\r\u0011YlQ\u0001\u0007!J,G-\u001a4\n\t\t}&\u0011\u0019\u0002\u0004\u001b\u0006\u0004(b\u0001B^\u0007B!!Q\u0019Bf\u001b\t\u00119MC\u0002\u0003J^\n1\"\u001a=qe\u0016\u001c8/[8og&!!Q\u001aBd\u0005=aunZ5dC24\u0016M]5bE2,\u0007\u0003\u0002Bc\u0005#LAAa5\u0003H\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\t]\u0007\u00021\u0001\u0002\b\u0006\u00192-\u0019:eS:\fG.\u001b;z\u0003:$\u0017J\u001c9vi\"9!1\u001c\u0005A\u0002\tu\u0017a\u00025pe&TxN\u001c\t\u0004{\n}\u0017b\u0001Bq}\na\u0011+^3ss\"{'/\u001b>p]\"9\u00111\u0004\u0005A\u0002\u0005u\u0001bBA\u0018\u0011\u0001\u0007\u0011\u0011\u0007\u0005\u0007\u0003\u0007B\u0001\u0019A$\t\u000f\t-\b\u00021\u0001\u0003n\u0006Y\u0011M]4v[\u0016tG/\u00133t!\u0019\u0011)La<\u0003D&!!\u0011\u001fBa\u0005\r\u0019V\r\u001e\u0005\b\u0003\u000fB\u0001\u0019AA%\u0003\u0015\nX/\u001a:z!J|'.Z2uS>t7)\u0019:eS:\fG.\u001b;z\u0005\u00164wN]3MS6LG\u000fF\u0003u\u0005s\u0014Y\u0010\u0003\u0004\u0003.&\u0001\r\u0001\u001e\u0005\b\u0005{L\u0001\u0019\u0001B\u0000\u0003)\u0001(o\u001c6fGRLwN\u001c\t\u0004{\u000e\u0005\u0011bAB\u0002}\ny\u0011+^3ssB\u0013xN[3di&|g.A\u0012rk\u0016\u0014\u0018\u0010\u0015:pU\u0016\u001cG/[8o\u0007\u0006\u0014H-\u001b8bY&$\u0018pV5uQ2KW.\u001b;\u0015\u000bQ\u001cIa!\u0004\t\r\r-!\u00021\u0001u\u0003Y\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=CK\u001a|'/\u001a'j[&$\bbBB\b\u0015\u0001\u00071\u0011C\u0001\u0010cV,'/\u001f)bO&t\u0017\r^5p]B\u0019Qpa\u0005\n\u0007\rUaPA\bRk\u0016\u0014\u0018\u0010U1hS:\fG/[8o\u0003\t\nX/\u001a:z!J|'.Z2uS>t7)\u0019:eS:\fG.\u001b;z/&$\bnU6jaR)Aoa\u0007\u0004 !11QD\u0006A\u0002Q\fQcY1sI&t\u0017\r\\5us\n+gm\u001c:f'.L\u0007\u000fC\u0004\u0004\u0010-\u0001\ra!\u0005\u0002QE,XM]=Qe>TWm\u0019;j_:\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=XSRD7+\u001a7fGRLwN\\:\u0015!\u0005\u001d5QEB\u0015\u0007g\u0019)da\u000e\u0004:\rm\u0002bBB\u0014\u0019\u0001\u0007\u0011qQ\u0001\u0015S:\u0004X\u000f\u001e\"fM>\u0014XmU3mK\u000e$\u0018n\u001c8\t\u000f\r-B\u00021\u0001\u0004.\u0005)q\u000f[3sKB\u0019Qpa\f\n\u0007\rEbP\u0001\u0006TK2,7\r^5p]NDq!a\u0007\r\u0001\u0004\ti\u0002C\u0004\u000201\u0001\r!!\r\t\r\u0005\rC\u00021\u0001H\u0011\u001d\u0011Y\u000f\u0004a\u0001\u0005[Dq!a\u0012\r\u0001\u0004\tI%A\u0011dC2\u001cW\u000f\\1uK\u000e\u000b'\u000fZ5oC2LG/\u001f$peF+XM]=He\u0006\u0004\b\u000e\u0006\t\u0002\b\u000e\u000531JB'\u0007\u001f\u001a\tfa\u0015\u0004V!911I\u0007A\u0002\r\u0015\u0013!B4sCBD\u0007cA?\u0004H%\u00191\u0011\n@\u0003\u0015E+XM]=He\u0006\u0004\b\u000eC\u0004\u0002\b5\u0001\r!!\u0003\t\u000f\u0005EQ\u00021\u0001\u0002\u0014!9\u00111D\u0007A\u0002\u0005u\u0001bBA\u0018\u001b\u0001\u0007\u0011\u0011\u0007\u0005\u0007\u0003\u0007j\u0001\u0019A$\t\u000f\u0005\u001dS\u00021\u0001\u0002J\u0001")
public class StatisticsBackedCardinalityModel
implements Metrics.CardinalityModel {
    private final Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel;
    private final Metrics.SelectivityCalculator selectivityCalculator;
    private final ExpressionEvaluator simpleExpressionEvaluator;

    public static Cardinality aggregateCardinalityEstimation(Cardinality in, Map<LogicalVariable, Expression> groupingExpressions) {
        return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityEstimation(in, groupingExpressions);
    }

    @Override
    public final Cardinality apply(PlannerQuery plannerQuery, Map<LogicalVariable, Set<LabelName>> labelInfo, Map<LogicalVariable, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexCompatiblePredicatesProviderContext, GraphSchemaOptimizations graphSchemaOptimizations) {
        return Metrics.CardinalityModel.apply$(this, plannerQuery, labelInfo, relTypeInfo, semanticTable, indexCompatiblePredicatesProviderContext, graphSchemaOptimizations);
    }

    @Override
    public Cardinality apply(PlannerQuery query, Map<LogicalVariable, Set<LabelName>> labelInfo, Map<LogicalVariable, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel, GraphSchemaOptimizations graphSchemaOptimizations) {
        PlannerQuery plannerQuery = query;
        if (plannerQuery instanceof SinglePlannerQuery) {
            SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)plannerQuery;
            return this.singlePlannerQueryCardinality(singlePlannerQuery, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel, graphSchemaOptimizations);
        }
        if (plannerQuery instanceof UnionQuery) {
            UnionQuery unionQuery = (UnionQuery)plannerQuery;
            PlannerQuery lhs = unionQuery.lhs();
            SinglePlannerQuery rhs = unionQuery.rhs();
            return this.combineUnion(unionQuery, this.apply(lhs, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel, graphSchemaOptimizations), this.apply((PlannerQuery)rhs, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel, graphSchemaOptimizations));
        }
        throw new MatchError((Object)plannerQuery);
    }

    public Cardinality singlePlannerQueryCardinality(SinglePlannerQuery query, Map<LogicalVariable, Set<LabelName>> labelInfo, Map<LogicalVariable, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel, GraphSchemaOptimizations graphSchemaOptimizations) {
        CardinalityAndInput output = (CardinalityAndInput)query.fold((Object)new CardinalityAndInput(Cardinality$.MODULE$.SINGLE(), labelInfo, relTypeInfo), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                CardinalityAndInput cardinalityAndInput = (CardinalityAndInput)tuple2._1();
                SinglePlannerQuery plannerQuery = (SinglePlannerQuery)tuple2._2();
                if (cardinalityAndInput != null) {
                    Cardinality inboundCardinality = cardinalityAndInput.cardinality();
                    Map<LogicalVariable, Set<LabelName>> labelInfo = cardinalityAndInput.labelInfo();
                    Map<LogicalVariable, RelTypeName> relTypeInfo = cardinalityAndInput.relTypeInfo();
                    CardinalityAndInput cardinalityAndInput2 = this.calculateCardinalityForQueryGraph(plannerQuery.queryGraph(), labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel, graphSchemaOptimizations);
                    if (cardinalityAndInput2 == null) {
                        throw new MatchError((Object)cardinalityAndInput2);
                    }
                    Cardinality qgCardinality = cardinalityAndInput2.cardinality();
                    Map<LogicalVariable, Set<LabelName>> labelInfoAfterQG = cardinalityAndInput2.labelInfo();
                    Map<LogicalVariable, RelTypeName> relTypeInfoAfterQG = cardinalityAndInput2.relTypeInfo();
                    Tuple3 tuple3 = new Tuple3((Object)qgCardinality, labelInfoAfterQG, relTypeInfoAfterQG);
                    Cardinality qgCardinality2 = (Cardinality)tuple3._1();
                    Map labelInfoAfterQG2 = (Map)tuple3._2();
                    Map relTypeInfoAfterQG2 = (Map)tuple3._3();
                    Cardinality beforeHorizonCardinality = qgCardinality2.$times(inboundCardinality);
                    CardinalityAndInput afterHorizon = this.calculateCardinalityForQueryHorizon(new CardinalityAndInput(beforeHorizonCardinality, (Map<LogicalVariable, Set<LabelName>>)labelInfoAfterQG2, (Map<LogicalVariable, RelTypeName>)relTypeInfoAfterQG2), plannerQuery.horizon(), semanticTable, indexPredicateProviderContext, cardinalityModel, (Set<LogicalVariable>)plannerQuery.queryGraph().argumentIds(), graphSchemaOptimizations);
                    return afterHorizon.withFusedLabelInfo((Map<LogicalVariable, Set<LabelName>>)plannerQuery.addHeadQueryLabelInfo(afterHorizon.labelInfo()));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return output.cardinality();
    }

    public Cardinality combineUnion(UnionQuery unionQuery, Cardinality lhsCardinality, Cardinality rhsCardinality) {
        Cardinality unionCardinality = lhsCardinality.$plus(rhsCardinality);
        if (unionQuery.distinct()) {
            return unionCardinality.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
        }
        return unionCardinality;
    }

    /*
     * Unable to fully structure code
     */
    private CardinalityAndInput calculateCardinalityForQueryHorizon(CardinalityAndInput cardinalityAndInput, QueryHorizon horizon, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel, Set<LogicalVariable> argumentIds, GraphSchemaOptimizations graphSchemaOptimizations) {
        block10: {
            block12: {
                block13: {
                    block11: {
                        var10_8 = false;
                        var11_9 = null;
                        var12_10 = horizon;
                        if (var12_10 instanceof QueryProjection) {
                            var13_11 = (QueryProjection)var12_10;
                            cardinalityBeforeSkip = this.queryProjectionCardinalityBeforeLimit(cardinalityAndInput.cardinality(), var13_11);
                            cardinalityBeforeLimit = this.queryProjectionCardinalityWithSkip(cardinalityBeforeSkip, var13_11.queryPagination());
                            cardinalityBeforeSelection = this.queryProjectionCardinalityWithLimit(cardinalityBeforeLimit, var13_11.queryPagination());
                            return this.queryProjectionCardinalityWithSelections(new CardinalityAndInput(cardinalityBeforeSelection, cardinalityAndInput.labelInfo(), cardinalityAndInput.relTypeInfo()), var13_11.selections(), semanticTable, indexPredicateProviderContext, cardinalityModel, argumentIds, graphSchemaOptimizations);
                        }
                        if (!(var12_10 instanceof UnwindProjection)) break block10;
                        var17_15 = (UnwindProjection)var12_10;
                        expression = var17_15.exp();
                        var20_17 = false;
                        var21_18 = null;
                        var22_19 = expression;
                        if (!(var22_19 instanceof ListLiteral)) break block11;
                        var23_20 = (ListLiteral)var22_19;
                        expressions = var23_20.expressions();
                        v0 = new Multiplier((double)expressions.size());
                        break block12;
                    }
                    if (!(var22_19 instanceof FunctionInvocation)) break block13;
                    var20_17 = true;
                    var21_18 = (FunctionInvocation)var22_19;
                    var25_22 = var21_18.functionName();
                    var26_23 = var21_18.args();
                    if (var25_22 == null) break block13;
                    var27_24 = var25_22.namespace();
                    var28_25 = var25_22.name();
                    if (var27_24 == null || (var29_26 = var27_24.parts()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var30_27 = package$.MODULE$.Seq().unapplySeq((SeqOps)var29_26)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var30_27)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var30_27), 0) != 0 || !"range".equals(var28_25) || var26_23 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var31_28 = package$.MODULE$.Seq().unapplySeq((SeqOps)var26_23)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var31_28)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var31_28), 2) != 0) break block13;
                    from = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var31_28), 0);
                    to = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var31_28), 1);
                    if (!(from instanceof IntegerLiteral)) break block13;
                    var34_31 = (IntegerLiteral)from;
                    if (!(to instanceof IntegerLiteral)) break block13;
                    var35_32 = (IntegerLiteral)to;
                    diff = Predef$.MODULE$.Long2long(var35_32.value()) - Predef$.MODULE$.Long2long(var34_31.value()) + 1L;
                    v0 = new Multiplier((double)Math.max(0L, diff));
                    break block12;
                }
                if (!var20_17) ** GOTO lbl-1000
                var38_34 = var21_18.functionName();
                var39_35 = var21_18.args();
                if (var38_34 == null) ** GOTO lbl-1000
                var40_36 = var38_34.namespace();
                var41_37 = var38_34.name();
                if (var40_36 == null || (var42_38 = var40_36.parts()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var43_39 = package$.MODULE$.Seq().unapplySeq((SeqOps)var42_38)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var43_39)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var43_39), 0) != 0 || !"range".equals(var41_37) || var39_35 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var44_40 = package$.MODULE$.Seq().unapplySeq((SeqOps)var39_35)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var44_40)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var44_40), 3) != 0) ** GOTO lbl-1000
                from = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var44_40), 0);
                to = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var44_40), 1);
                step = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var44_40), 2);
                if (!(from instanceof IntegerLiteral)) ** GOTO lbl-1000
                var48_44 = (IntegerLiteral)from;
                if (!(to instanceof IntegerLiteral)) ** GOTO lbl-1000
                var49_45 = (IntegerLiteral)to;
                if (step instanceof IntegerLiteral) {
                    var50_46 = (IntegerLiteral)step;
                    diff = Predef$.MODULE$.Long2long(var49_45.value()) - Predef$.MODULE$.Long2long(var48_44.value());
                    steps = diff / Predef$.MODULE$.Long2long(var50_46.value()) + 1L;
                    v0 = new Multiplier((double)Math.max(0L, steps));
                } else lbl-1000:
                // 6 sources

                {
                    v0 = PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER();
                }
            }
            multiplier = v0;
            return cardinalityAndInput.copy(cardinalityAndInput.cardinality().$times(multiplier), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var12_10 instanceof AbstractProcedureCallProjection) {
            return cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var12_10 instanceof CommandProjection) {
            return cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var12_10 instanceof LoadCSVProjection) {
            return cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var12_10 instanceof PassthroughAllHorizon) {
            return cardinalityAndInput;
        }
        if (var12_10 instanceof CallSubqueryHorizon) {
            var10_8 = true;
            var11_9 = (CallSubqueryHorizon)var12_10;
            subquery = var11_9.callSubquery();
            var56_51 = var11_9.yielding();
            if (var56_51) {
                subQueryCardinality = this.apply(subquery, cardinalityAndInput.labelInfo(), cardinalityAndInput.relTypeInfo(), semanticTable, indexPredicateProviderContext, cardinalityModel, graphSchemaOptimizations);
                return cardinalityAndInput.copy(cardinalityAndInput.cardinality().$times(subQueryCardinality), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
            }
        }
        if (var10_8 && !(var58_53 = var11_9.yielding())) {
            return cardinalityAndInput;
        }
        throw new MatchError((Object)var12_10);
    }

    private Cardinality queryProjectionCardinalityBeforeLimit(Cardinality in, QueryProjection projection2) {
        boolean bl = false;
        AggregatingQueryProjection aggregatingQueryProjection = null;
        QueryProjection queryProjection = projection2;
        if (queryProjection instanceof RegularQueryProjection) {
            return in;
        }
        if (queryProjection instanceof DistinctQueryProjection) {
            return in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
        }
        if (queryProjection instanceof AggregatingQueryProjection) {
            bl = true;
            aggregatingQueryProjection = (AggregatingQueryProjection)queryProjection;
            if (aggregatingQueryProjection.aggregationExpressions().isEmpty()) {
                return in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
            }
        }
        if (bl) {
            return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityEstimation(in, (Map<LogicalVariable, Expression>)aggregatingQueryProjection.groupingExpressions());
        }
        if (queryProjection instanceof RunQueryAtProjection) {
            return in;
        }
        throw new MatchError((Object)queryProjection);
    }

    private Cardinality queryProjectionCardinalityWithLimit(Cardinality cardinalityBeforeLimit, QueryPagination queryPagination) {
        Option option = queryPagination.limit();
        if (None$.MODULE$.equals(option)) {
            return cardinalityBeforeLimit;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression limitExpression = (Expression)some.value();
            long limitRowCount = BoxesRunTime.unboxToLong((Object)this.simpleExpressionEvaluator.evaluateLongIfStable(limitExpression).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_LIMIT_ROW_COUNT()));
            if ((double)limitRowCount >= cardinalityBeforeLimit.amount()) {
                return cardinalityBeforeLimit;
            }
            return new Cardinality((double)limitRowCount);
        }
        throw new MatchError((Object)option);
    }

    private Cardinality queryProjectionCardinalityWithSkip(Cardinality cardinalityBeforeSkip, QueryPagination queryPagination) {
        Option option = queryPagination.skip();
        if (None$.MODULE$.equals(option)) {
            return cardinalityBeforeSkip;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression skipExpression = (Expression)some.value();
            long skipRowCount = BoxesRunTime.unboxToLong((Object)this.simpleExpressionEvaluator.evaluateLongIfStable(skipExpression).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_SKIP_ROW_COUNT()));
            if (skipRowCount == 0L) {
                return cardinalityBeforeSkip;
            }
            if ((double)skipRowCount >= cardinalityBeforeSkip.amount()) {
                return Cardinality$.MODULE$.EMPTY();
            }
            return cardinalityBeforeSkip.map((Function1)(JFunction1.mcDD.sp & Serializable)c -> c - (double)skipRowCount);
        }
        throw new MatchError((Object)option);
    }

    private CardinalityAndInput queryProjectionCardinalityWithSelections(CardinalityAndInput inputBeforeSelection, Selections where, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel, Set<LogicalVariable> argumentIds, GraphSchemaOptimizations graphSchemaOptimizations) {
        Cardinality inboundCardinality = inputBeforeSelection.cardinality();
        CardinalityAndInput fusedInput = inputBeforeSelection.withFusedLabelInfo((Map<LogicalVariable, Set<LabelName>>)where.labelInfo());
        Selectivity whereSelectivity = this.selectivityCalculator.apply(where, fusedInput.labelInfo(), fusedInput.relTypeInfo(), semanticTable, indexPredicateProviderContext, cardinalityModel, argumentIds, graphSchemaOptimizations);
        Cardinality cardinality = inboundCardinality.$times(whereSelectivity);
        return new CardinalityAndInput(cardinality, fusedInput.labelInfo(), fusedInput.relTypeInfo());
    }

    private CardinalityAndInput calculateCardinalityForQueryGraph(QueryGraph graph, Map<LogicalVariable, Set<LabelName>> labelInfo, Map<LogicalVariable, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel, GraphSchemaOptimizations graphSchemaOptimizations) {
        Map fusedRelTypeInfo = (Map)relTypeInfo.$plus$plus((IterableOnce)graph.patternRelationshipTypes());
        Cardinality cardinality = this.queryGraphCardinalityModel.apply(graph, labelInfo, (Map<LogicalVariable, RelTypeName>)fusedRelTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel, graphSchemaOptimizations);
        Map fusedLabelInfo = MapSupport$.MODULE$.PowerMap(labelInfo).fuse(graph.patternNodeLabels(), (Function2 & Serializable)(x$2, x$3) -> (Set)x$2.$plus$plus((IterableOnce)x$3));
        return new CardinalityAndInput(cardinality, (Map<LogicalVariable, Set<LabelName>>)fusedLabelInfo, (Map<LogicalVariable, RelTypeName>)fusedRelTypeInfo);
    }

    public StatisticsBackedCardinalityModel(Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel, Metrics.SelectivityCalculator selectivityCalculator, ExpressionEvaluator simpleExpressionEvaluator2) {
        this.queryGraphCardinalityModel = queryGraphCardinalityModel;
        this.selectivityCalculator = selectivityCalculator;
        this.simpleExpressionEvaluator = simpleExpressionEvaluator2;
        Metrics.CardinalityModel.$init$(this);
    }

    public static class CardinalityAndInput
    implements Product,
    Serializable {
        private final Cardinality cardinality;
        private final Map<LogicalVariable, Set<LabelName>> labelInfo;
        private final Map<LogicalVariable, RelTypeName> relTypeInfo;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Cardinality cardinality() {
            return this.cardinality;
        }

        public Map<LogicalVariable, Set<LabelName>> labelInfo() {
            return this.labelInfo;
        }

        public Map<LogicalVariable, RelTypeName> relTypeInfo() {
            return this.relTypeInfo;
        }

        public CardinalityAndInput withFusedLabelInfo(Map<LogicalVariable, Set<LabelName>> newLabelInfo) {
            Map x$1 = MapSupport$.MODULE$.PowerMap(this.labelInfo()).fuse(newLabelInfo, (Function2 & Serializable)(x$4, x$5) -> (Set)x$4.$plus$plus((IterableOnce)x$5));
            Cardinality x$2 = this.copy$default$1();
            Map<LogicalVariable, RelTypeName> x$3 = this.copy$default$3();
            return this.copy(x$2, (Map<LogicalVariable, Set<LabelName>>)x$1, x$3);
        }

        public CardinalityAndInput withFusedRelTypeInfo(Map<LogicalVariable, RelTypeName> newRelTypeInfo) {
            Map x$1 = (Map)this.relTypeInfo().$plus$plus(newRelTypeInfo);
            Cardinality x$2 = this.copy$default$1();
            Map<LogicalVariable, Set<LabelName>> x$3 = this.copy$default$2();
            return this.copy(x$2, x$3, (Map<LogicalVariable, RelTypeName>)x$1);
        }

        public CardinalityAndInput copy(Cardinality cardinality, Map<LogicalVariable, Set<LabelName>> labelInfo, Map<LogicalVariable, RelTypeName> relTypeInfo) {
            return new CardinalityAndInput(cardinality, labelInfo, relTypeInfo);
        }

        public Cardinality copy$default$1() {
            return this.cardinality();
        }

        public Map<LogicalVariable, Set<LabelName>> copy$default$2() {
            return this.labelInfo();
        }

        public Map<LogicalVariable, RelTypeName> copy$default$3() {
            return this.relTypeInfo();
        }

        public String productPrefix() {
            return "CardinalityAndInput";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.cardinality();
                }
                case 1: {
                    return this.labelInfo();
                }
                case 2: {
                    return this.relTypeInfo();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CardinalityAndInput;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "cardinality";
                }
                case 1: {
                    return "labelInfo";
                }
                case 2: {
                    return "relTypeInfo";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CardinalityAndInput)) return false;
            boolean bl = true;
            if (!bl) return false;
            CardinalityAndInput cardinalityAndInput = (CardinalityAndInput)x$1;
            Cardinality cardinality = this.cardinality();
            Cardinality cardinality2 = cardinalityAndInput.cardinality();
            if (cardinality == null) {
                if (cardinality2 != null) {
                    return false;
                }
            } else if (!cardinality.equals(cardinality2)) return false;
            Map<LogicalVariable, Set<LabelName>> map2 = this.labelInfo();
            Map<LogicalVariable, Set<LabelName>> map3 = cardinalityAndInput.labelInfo();
            if (map2 == null) {
                if (map3 != null) {
                    return false;
                }
            } else if (!map2.equals(map3)) return false;
            Map<LogicalVariable, RelTypeName> map4 = this.relTypeInfo();
            Map<LogicalVariable, RelTypeName> map5 = cardinalityAndInput.relTypeInfo();
            if (map4 == null) {
                if (map5 != null) {
                    return false;
                }
            } else if (!map4.equals(map5)) return false;
            if (!cardinalityAndInput.canEqual(this)) return false;
            return true;
        }

        public CardinalityAndInput(Cardinality cardinality, Map<LogicalVariable, Set<LabelName>> labelInfo, Map<LogicalVariable, RelTypeName> relTypeInfo) {
            this.cardinality = cardinality;
            this.labelInfo = labelInfo;
            this.relTypeInfo = relTypeInfo;
            Product.$init$((Product)this);
        }
    }
}

