/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.physicalplanning.ast.prettifier;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.physicalplanning.ast.prettifier.RuntimeExpressionStringifier;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.ModuleSerializationProxy;

public final class RuntimeExpressionStringifier$
implements Serializable {
    public static final RuntimeExpressionStringifier$ MODULE$ = new RuntimeExpressionStringifier$();

    public String nameFromSlotOrAlias(SlotConfiguration slots, String variableName, ExpressionStringifier ctx) {
        SlotConfiguration.SlotKey slotKey;
        SlotConfiguration.KeyedSlot keyedSlot = (SlotConfiguration.KeyedSlot)slots.apply(variableName);
        if (keyedSlot != null && (slotKey = keyedSlot.key()) instanceof SlotConfiguration.VariableSlotKey) {
            SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
            String name = variableSlotKey.name();
            return ctx.backtick(name);
        }
        if (keyedSlot != null) {
            SlotConfiguration.SlotKey key = keyedSlot.key();
            throw new IllegalStateException("Expected a VariableSlotKey for `" + variableName + "` but found " + key);
        }
        throw new MatchError((Object)keyedSlot);
    }

    public String nameFromLongSlot(SlotConfiguration slots, int offset, ExpressionStringifier ctx) {
        Option<String> option = slots.nameOfSlot(offset, true);
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return ctx.backtick(value);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("No LongSlot with offset " + offset + ".");
        }
        throw new MatchError(option);
    }

    public String nameFromRefSlot(SlotConfiguration slots, int offset, ExpressionStringifier ctx) {
        Option<String> option = slots.nameOfSlot(offset, false);
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return ctx.backtick(value);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("No RefSlot with offset " + offset + ".");
        }
        throw new MatchError(option);
    }

    public RuntimeExpressionStringifier apply(ReadTokenContext tokenContext, SlotConfiguration slots) {
        return new RuntimeExpressionStringifier(tokenContext, slots);
    }

    public Option<Tuple2<ReadTokenContext, SlotConfiguration>> unapply(RuntimeExpressionStringifier x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.tokenContext(), (Object)x$0.slots()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RuntimeExpressionStringifier$.class);
    }

    private RuntimeExpressionStringifier$() {
    }
}

