/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.converters;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FixedQuantifier;
import org.neo4j.cypher.internal.expressions.GraphPatternQuantifier;
import org.neo4j.cypher.internal.expressions.IntervalQuantifier;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.NamedPatternPart;
import org.neo4j.cypher.internal.expressions.NodePattern;
import org.neo4j.cypher.internal.expressions.NonPrefixedPatternPart;
import org.neo4j.cypher.internal.expressions.ParenthesizedPath;
import org.neo4j.cypher.internal.expressions.PathConcatenation;
import org.neo4j.cypher.internal.expressions.PathPatternPart;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PlusQuantifier;
import org.neo4j.cypher.internal.expressions.QuantifiedPath;
import org.neo4j.cypher.internal.expressions.RelationshipChain;
import org.neo4j.cypher.internal.expressions.ShortestPathsPatternPart;
import org.neo4j.cypher.internal.expressions.StarQuantifier;
import org.neo4j.cypher.internal.expressions.UnsignedIntegerLiteral;
import org.neo4j.cypher.internal.expressions.VariableGrouping;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QuantifiedPathPattern;
import org.neo4j.cypher.internal.ir.Selections$;
import org.neo4j.cypher.internal.ir.converters.QuantifiedPathPatternConverters;
import org.neo4j.cypher.internal.ir.converters.QuantifiedPathPatternConverters$QuantifiedPathPatternBuilder$;
import org.neo4j.cypher.internal.ir.converters.QuantifiedPathPatternConverters$VariableGroupings$;
import org.neo4j.cypher.internal.ir.converters.SimplePatternConverters$;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.Repetition;
import org.neo4j.cypher.internal.util.UpperBound;
import org.neo4j.cypher.internal.util.UpperBound$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class QuantifiedPathPatternConverters$ {
    public static final QuantifiedPathPatternConverters$ MODULE$ = new QuantifiedPathPatternConverters$();

    public QuantifiedPathPattern convertQuantifiedPath(LogicalVariable outerLeft, QuantifiedPath quantifiedPath, LogicalVariable outerRight) {
        PathPatternPart patternPart = this.getPathPattern(quantifiedPath);
        PatternElement patternElement = patternPart.element();
        NonEmptyList<PatternRelationship> patternRelationships = this.getPatternRelationships(patternElement);
        Map<LogicalVariable, LogicalVariable> groupings = QuantifiedPathPatternConverters$VariableGroupings$.MODULE$.build((Set<VariableGrouping>)quantifiedPath.variableGroupings());
        return ((QuantifiedPathPatternConverters.QuantifiedPathPatternBuilder)patternRelationships.map((Function1 & Serializable)relationship -> QuantifiedPathPatternConverters$QuantifiedPathPatternBuilder$.MODULE$.fromPatternRelationship((Map)groupings, (PatternRelationship)relationship)).reduceLeft((Function2 & Serializable)(x$1, x$2) -> x$1.append((QuantifiedPathPatternConverters.QuantifiedPathPatternBuilder)x$2))).build(outerLeft, outerRight, Selections$.MODULE$.from((Iterable<Expression>)Option$.MODULE$.option2Iterable(quantifiedPath.optionalWhereExpression())), this.convertGraphPatternQuantifier(quantifiedPath.quantifier()));
    }

    public Repetition convertGraphPatternQuantifier(GraphPatternQuantifier quantifier) {
        GraphPatternQuantifier graphPatternQuantifier = quantifier;
        if (graphPatternQuantifier instanceof PlusQuantifier) {
            return new Repetition(1L, (UpperBound)UpperBound.Unlimited$.MODULE$);
        }
        if (graphPatternQuantifier instanceof StarQuantifier) {
            return new Repetition(0L, (UpperBound)UpperBound.Unlimited$.MODULE$);
        }
        if (graphPatternQuantifier instanceof FixedQuantifier) {
            FixedQuantifier fixedQuantifier = (FixedQuantifier)graphPatternQuantifier;
            UnsignedIntegerLiteral value = fixedQuantifier.value();
            return new Repetition(Predef$.MODULE$.Long2long(value.value()), (UpperBound)new UpperBound.Limited(Predef$.MODULE$.Long2long(value.value())));
        }
        if (graphPatternQuantifier instanceof IntervalQuantifier) {
            IntervalQuantifier intervalQuantifier = (IntervalQuantifier)graphPatternQuantifier;
            Option lower = intervalQuantifier.lower();
            Option upper = intervalQuantifier.upper();
            return new Repetition(BoxesRunTime.unboxToLong((Object)lower.fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$3.value())))), (UpperBound)upper.fold((Function0 & Serializable)() -> UpperBound$.MODULE$.unlimited(), (Function1 & Serializable)x -> new UpperBound.Limited(Predef$.MODULE$.Long2long(x.value()))));
        }
        throw new MatchError((Object)graphPatternQuantifier);
    }

    private PathPatternPart getPathPattern(QuantifiedPath quantifiedPath) {
        NonPrefixedPatternPart nonPrefixedPatternPart = quantifiedPath.part();
        if (nonPrefixedPatternPart instanceof PathPatternPart) {
            PathPatternPart pathPatternPart = (PathPatternPart)nonPrefixedPatternPart;
            return pathPatternPart;
        }
        if (nonPrefixedPatternPart instanceof ShortestPathsPatternPart) {
            ShortestPathsPatternPart shortestPathsPatternPart = (ShortestPathsPatternPart)nonPrefixedPatternPart;
            throw new IllegalArgumentException(shortestPathsPatternPart.name() + "() is not allowed inside of a quantified path pattern");
        }
        if (nonPrefixedPatternPart instanceof NamedPatternPart) {
            throw new IllegalArgumentException("sub-path assignment is not currently supported");
        }
        throw new MatchError((Object)nonPrefixedPatternPart);
    }

    private NonEmptyList<PatternRelationship> getPatternRelationships(PatternElement patternElement) {
        PatternElement patternElement2 = patternElement;
        if (patternElement2 instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)patternElement2;
            return SimplePatternConverters$.MODULE$.convertRelationshipChain(relationshipChain);
        }
        if (patternElement2 instanceof NodePattern) {
            throw new IllegalArgumentException("quantified path patterns must contain at least one relationship");
        }
        if (patternElement2 instanceof PathConcatenation) {
            throw new IllegalArgumentException("path concatenation is not currently supported inside of quantified path patterns");
        }
        if (patternElement2 instanceof QuantifiedPath) {
            throw new IllegalArgumentException("nested quantified path patterns are not currently supported");
        }
        if (patternElement2 instanceof ParenthesizedPath) {
            throw new IllegalArgumentException("parenthesised path patterns are not currently supported inside of quantified path patterns");
        }
        throw new MatchError((Object)patternElement2);
    }

    private QuantifiedPathPatternConverters$() {
    }
}

