/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.CollectExpression;
import org.neo4j.cypherdsl.core.CountExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;

@API(status=API.Status.DEPRECATED, since="2023.9.0")
@Deprecated(since="2023.9.0")
public final class Expressions {
    @NotNull
    public static CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
        return CountExpression.count(Pattern.of(requiredPattern, patternElement));
    }

    @NotNull
    public static CountExpression count(Statement.UnionQuery union) {
        return CountExpression.count(union);
    }

    @NotNull
    public static CountExpression count(Statement statement, IdentifiableElement ... imports) {
        return CountExpression.count(statement, imports);
    }

    public static CountExpression count(List<PatternElement> pattern, @Nullable Where where) {
        return CountExpression.count(pattern, where);
    }

    @Deprecated
    public static SubqueryExpressionBuilder with(String ... identifiableElements) {
        return Expressions.with((IdentifiableElement[])Arrays.stream(identifiableElements).map(SymbolicName::of).toArray(SymbolicName[]::new));
    }

    @Deprecated
    public static SubqueryExpressionBuilder with(IdentifiableElement ... identifiableElements) {
        ExpressionList returnItems = new ExpressionList(Arrays.stream(identifiableElements).map(IdentifiableElement::asExpression).toList());
        final With with = new With(false, returnItems, null, null, null, null);
        return new SubqueryExpressionBuilder(){

            @Override
            @NotNull
            public CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
                return CountExpression.count(with, Pattern.of(requiredPattern, patternElement));
            }

            @Override
            @NotNull
            public CountExpression count(Statement.UnionQuery union) {
                return CountExpression.count(with, union);
            }

            @Override
            public CollectExpression collect(Statement statement) {
                return CollectExpression.collect(with, statement);
            }
        };
    }

    @NotNull
    public static Expression collect(Statement statement) {
        if (!statement.doesReturnOrYield()) {
            throw new IllegalArgumentException("The final RETURN clause in a subquery used with COLLECT is mandatory and the RETURN clause must return exactly one column.");
        }
        return CollectExpression.collect(statement);
    }

    static <T extends Expression> Expression nameOrExpression(T expression) {
        if (expression instanceof Named) {
            Named named = (Named)((Object)expression);
            return named.getSymbolicName().map(Expression.class::cast).orElse(expression);
        }
        return expression;
    }

    static SymbolicName[] createSymbolicNames(String[] variables) {
        return (SymbolicName[])Arrays.stream(variables).map(SymbolicName::of).toArray(SymbolicName[]::new);
    }

    static SymbolicName[] createSymbolicNames(Named[] variables) {
        return (SymbolicName[])Arrays.stream(variables).map(Named::getRequiredSymbolicName).toArray(SymbolicName[]::new);
    }

    static String format(Expression expression) {
        if (expression instanceof Named) {
            Named named = (Named)((Object)expression);
            return named.getRequiredSymbolicName().getValue();
        }
        if (expression instanceof AliasedExpression) {
            AliasedExpression aliasedExpression = (AliasedExpression)expression;
            return aliasedExpression.getAlias();
        }
        if (expression instanceof SymbolicName) {
            SymbolicName symbolicName = (SymbolicName)expression;
            return symbolicName.getValue();
        }
        if (expression instanceof Property) {
            StringBuilder ref = new StringBuilder();
            expression.accept(segment -> {
                if (segment instanceof SymbolicName) {
                    SymbolicName symbolicName = (SymbolicName)segment;
                    if (!ref.isEmpty()) {
                        ref.append(".");
                    }
                    ref.append(symbolicName.getValue());
                }
            });
            return ref.toString();
        }
        throw new IllegalArgumentException("Cannot format expression " + expression.toString());
    }

    private Expressions() {
    }

    @API(status=API.Status.DEPRECATED, since="2023.9.0")
    @Deprecated(since="2023.9.0")
    public static interface SubqueryExpressionBuilder
    extends org.neo4j.cypherdsl.core.SubqueryExpressionBuilder {
    }
}

