/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.function.Predicate;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.AbstractStoreProcessor;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.SchemaRecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.CheckStage;
import org.neo4j.consistency.checking.full.CloningRecordIterator;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.consistency.checking.full.RecordDistributor;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.Scanner;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class StoreProcessor
extends AbstractStoreProcessor {
    private final int qSize = 1000;
    protected final CacheAccess cacheAccess;
    private final ConsistencyReport.Reporter report;
    private SchemaRecordCheck schemaRecordCheck;
    private final Stage stage;

    public StoreProcessor(CheckDecorator decorator, ConsistencyReport.Reporter report, Stage stage, CacheAccess cacheAccess) {
        super(decorator);
        assert (stage != null);
        this.report = report;
        this.stage = stage;
        this.cacheAccess = cacheAccess;
    }

    public Stage getStage() {
        return this.stage;
    }

    @Override
    public void processNode(RecordStore<NodeRecord> store, NodeRecord node) {
        this.cacheAccess.client().incAndGetCount(node.isDense() ? Counts.Type.nodeDense : Counts.Type.nodeSparse);
        super.processNode(store, node);
    }

    protected void checkSchema(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord schema, RecordCheck<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> checker) {
        this.report.forSchema(schema, checker);
    }

    @Override
    protected void checkNode(RecordStore<NodeRecord> store, NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.report.forNode(node, checker);
    }

    public void countLinks(long id1, long id2, CacheAccess.Client client) {
        Counts.Type type = null;
        type = id2 == -1L ? Counts.Type.nullLinks : (id2 > id1 ? Counts.Type.forwardLinks : Counts.Type.backLinks);
        client.incAndGetCount(type);
    }

    @Override
    protected void checkRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        if (this.stage != null && (this.stage == CheckStage.Stage6_RS_Forward || this.stage == CheckStage.Stage7_RS_Backward)) {
            long id = rel.getId();
            CacheAccess.Client client = this.cacheAccess.client();
            this.countLinks(id, rel.getFirstNextRel(), client);
            this.countLinks(id, rel.getFirstPrevRel(), client);
            this.countLinks(id, rel.getSecondNextRel(), client);
            this.countLinks(id, rel.getSecondPrevRel(), client);
        }
        this.report.forRelationship(rel, checker);
    }

    @Override
    protected void checkProperty(RecordStore<PropertyRecord> store, PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.report.forProperty(property, checker);
    }

    @Override
    protected void checkRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord relationshipType, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        this.report.forRelationshipTypeName(relationshipType, checker);
    }

    @Override
    protected void checkLabelToken(RecordStore<LabelTokenRecord> store, LabelTokenRecord label, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
        this.report.forLabelName(label, checker);
    }

    @Override
    protected void checkPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord key, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
        this.report.forPropertyKey(key, checker);
    }

    @Override
    protected void checkDynamic(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.report.forDynamicBlock(type, string, checker);
    }

    @Override
    protected void checkDynamicLabel(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> checker) {
        this.report.forDynamicLabelBlock(type, string, checker);
    }

    @Override
    protected void checkRelationshipGroup(RecordStore<RelationshipGroupRecord> store, RelationshipGroupRecord record, RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
        this.report.forRelationshipGroup(record, checker);
    }

    void setSchemaRecordCheck(SchemaRecordCheck schemaRecordCheck) {
        this.schemaRecordCheck = schemaRecordCheck;
    }

    @Override
    public void processSchema(RecordStore<DynamicRecord> store, DynamicRecord schema) {
        if (null == this.schemaRecordCheck) {
            super.processSchema(store, schema);
        } else {
            this.checkSchema(RecordType.SCHEMA, store, schema, this.schemaRecordCheck);
        }
    }

    public <R extends AbstractBaseRecord> void applyFilteredParallel(final RecordStore<R> store, ProgressListener progressListener, int numberOfThreads, long recordsPerCpu, QueueDistribution.QueueDistributor<R> distributor) {
        this.cacheAccess.prepareForProcessingOfSingleStore(recordsPerCpu);
        RecordProcessor.Adapter processor = new RecordProcessor.Adapter<R>(){

            @Override
            public void init(int id) {
                StoreProcessor.this.cacheAccess.client();
            }

            @Override
            public void process(R record) {
                store.accept((RecordStore.Processor)StoreProcessor.this, record);
            }
        };
        ResourceIterable scan = Scanner.scan(store, (boolean)this.stage.isForward(), (Predicate[])new Predicate[0]);
        try (ResourceIterator records = scan.iterator();){
            RecordDistributor.distributeRecords(numberOfThreads, ((Object)((Object)this)).getClass().getSimpleName(), 1000, CloningRecordIterator.cloned(records), progressListener, processor, distributor);
        }
    }
}

