/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

public class LockingExecutor
implements Executor {
    private final JobScheduler jobScheduler;
    private final Group group;
    private final AtomicBoolean latch = new AtomicBoolean(false);

    public LockingExecutor(JobScheduler jobScheduler, Group group) {
        this.jobScheduler = jobScheduler;
        this.group = group;
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.latch.compareAndSet(false, true)) {
            this.jobScheduler.schedule(this.group, () -> {
                try {
                    runnable.run();
                }
                finally {
                    this.latch.set(false);
                }
            });
        }
    }
}

