/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.register;

import org.neo4j.register.Register;

public class Registers {
    private Registers() {
    }

    public static Register.DoubleLongRegister newDoubleLongRegister() {
        return Registers.newDoubleLongRegister(-1L, -1L);
    }

    public static Register.DoubleLongRegister newDoubleLongRegister(final long initialFirst, final long initialSecond) {
        return new Register.DoubleLongRegister(){
            private long first;
            private long second;
            {
                this.first = initialFirst;
                this.second = initialSecond;
            }

            @Override
            public long readFirst() {
                return this.first;
            }

            @Override
            public long readSecond() {
                return this.second;
            }

            @Override
            public void copyTo(Register.DoubleLong.Out target) {
                target.write(this.first, this.second);
            }

            @Override
            public boolean hasValues(long first, long second) {
                return this.first == first && this.second == second;
            }

            @Override
            public void write(long first, long second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public void increment(long firstDelta, long secondDelta) {
                this.first += firstDelta;
                this.second += secondDelta;
            }

            public String toString() {
                return "DoubleLongRegister{first=" + this.first + ", second=" + this.second + "}";
            }
        };
    }
}

