/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.scheduler.ExecutorServiceFactory;
import org.neo4j.scheduler.SchedulerThreadFactory;

public enum Group {
    TASK_SCHEDULER("Scheduler", ExecutorServiceFactory.unschedulable()),
    PAGE_CACHE("PageCacheWorker"),
    FILE_WATCHER("FileWatcher"),
    VM_PAUSE_MONITOR("VmPauseMonitor"),
    LOG_ROTATION("LogRotation"),
    CHECKPOINT("CheckPoint"),
    STORAGE_MAINTENANCE("StorageMaintenance"),
    TRANSACTION_TIMEOUT_MONITOR("TransactionTimeoutMonitor"),
    INDEX_POPULATION("IndexPopulation"),
    INDEX_SAMPLING("IndexSampling"),
    INDEX_UPDATING("IndexUpdating", ExecutorServiceFactory.singleThread()),
    FILE_IO_HELPER("FileIOHelper"),
    NATIVE_SECURITY("NativeSecurity"),
    METRICS_EVENT("MetricsEvent"),
    CYPHER_WORKER("CypherWorker", ExecutorServiceFactory.workStealing()),
    BOLT_NETWORK_IO("BoltNetworkIO"),
    BOLT_WORKER("BoltWorker"),
    RAFT_TIMER("RaftTimer"),
    RAFT_LOG_PRUNING("RaftLogPruning"),
    RAFT_BATCH_HANDLER("RaftBatchHandler"),
    RAFT_READER_POOL_PRUNER("RaftReaderPoolPruner"),
    HZ_TOPOLOGY_HEALTH("HazelcastHealth"),
    HZ_TOPOLOGY_KEEP_ALIVE("KeepAlive"),
    HZ_TOPOLOGY_REFRESH("TopologyRefresh"),
    AKKA_TOPOLOGY_WORKER("AkkaTopologyWorkers", ExecutorServiceFactory.workStealing()),
    MEMBERSHIP_WAITER("MembershipWaiter"),
    DOWNLOAD_SNAPSHOT("DownloadSnapshot"),
    MASTER_TRANSACTION_PUSHING("TransactionPushing"),
    SERVER_TRANSACTION_TIMEOUT("ServerTransactionTimeout"),
    SLAVE_LOCKS_TIMEOUT("SlaveLocksTimeout"),
    PULL_UPDATES("PullUpdates"),
    UDC("UsageDataCollector");

    private final String name;
    private final ExecutorServiceFactory executorServiceFactory;
    private final AtomicInteger threadCounter;

    private Group(String name, ExecutorServiceFactory executorServiceFactory) {
        this.name = name;
        this.executorServiceFactory = executorServiceFactory;
        this.threadCounter = new AtomicInteger();
    }

    private Group(String name) {
        this(name, ExecutorServiceFactory.cached());
    }

    public String groupName() {
        return this.name;
    }

    public String threadName() {
        return "neo4j." + this.groupName() + "-" + this.threadCounter.incrementAndGet();
    }

    public ExecutorService buildExecutorService(SchedulerThreadFactory factory) {
        return this.executorServiceFactory.build(this, factory);
    }
}

