/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class HeapTrackingArrayList<E>
implements List<E>,
AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingArrayList.class);
    private final MemoryTracker memoryTracker;
    private long trackedSize;
    private int size;
    private int modCount;
    private Object[] elementData;

    public static <T> HeapTrackingArrayList<T> newArrayList(MemoryTracker memoryTracker) {
        return HeapTrackingArrayList.newArrayListWithInitialTrackedSize(1, memoryTracker, 0L);
    }

    public static <T> HeapTrackingArrayList<T> newArrayListWithInitialTrackedSize(MemoryTracker memoryTracker, long initialTrackedSize) {
        return HeapTrackingArrayList.newArrayListWithInitialTrackedSize(1, memoryTracker, initialTrackedSize);
    }

    public static <T> HeapTrackingArrayList<T> newArrayList(int initialCapacity, MemoryTracker memoryTracker) {
        return HeapTrackingArrayList.newArrayListWithInitialTrackedSize(initialCapacity, memoryTracker, 0L);
    }

    public static <T> HeapTrackingArrayList<T> newEmptyArrayList(int exactSize, MemoryTracker memoryTracker) {
        HeapTrackingArrayList<T> list = HeapTrackingArrayList.newArrayListWithInitialTrackedSize(exactSize, memoryTracker, exactSize);
        list.size = exactSize;
        return list;
    }

    public static <T> HeapTrackingArrayList<T> newArrayListWithInitialTrackedSize(int initialCapacity, MemoryTracker memoryTracker, long initialTrackedSize) {
        Preconditions.requireNonNegative((int)initialCapacity);
        long trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)initialCapacity) + initialTrackedSize;
        memoryTracker.allocateHeap(SHALLOW_SIZE + trackedSize);
        return new HeapTrackingArrayList(initialCapacity, memoryTracker, trackedSize);
    }

    private HeapTrackingArrayList(HeapTrackingArrayList<E> other) {
        int otherSize;
        this.size = otherSize = other.size;
        this.elementData = new Object[otherSize];
        System.arraycopy(other.elementData, 0, this.elementData, 0, otherSize);
        this.memoryTracker = other.memoryTracker;
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)otherSize);
        this.memoryTracker.allocateHeap(SHALLOW_SIZE + this.trackedSize);
    }

    private HeapTrackingArrayList(int initialSize, MemoryTracker memoryTracker, long trackedSize) {
        this.elementData = new Object[initialSize];
        this.memoryTracker = memoryTracker;
        this.trackedSize = trackedSize;
    }

    public HeapTrackingArrayList<E> clone() {
        return new HeapTrackingArrayList<E>(this);
    }

    @Override
    public boolean add(E item) {
        ++this.modCount;
        this.add(item, this.elementData, this.size);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        ++this.modCount;
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        Object[] elementData = this.elementData;
        int s = this.size;
        if (numNew > this.elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        System.arraycopy(a, 0, elementData, s, numNew);
        this.size = s + numNew;
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int numMoved;
        this.rangeCheckForAdd(index);
        Object[] a = c.toArray();
        ++this.modCount;
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        Object[] elementData = this.elementData;
        int s = this.size;
        if (numNew > this.elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        if ((numMoved = s - index) > 0) {
            System.arraycopy(elementData, index, elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, elementData, index, numNew);
        this.size = s + numNew;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchRemove(c, false, 0, this.size);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchRemove(c, true, 0, this.size);
    }

    @Override
    public E get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elementData(index);
    }

    public E last() {
        return this.get(this.size - 1);
    }

    @Override
    public E set(int index, E element) {
        Objects.checkIndex(index, this.size);
        E oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        ++this.modCount;
        int s = this.size;
        Object[] elementData = this.elementData;
        if (s == this.elementData.length) {
            elementData = this.grow(this.size + 1);
        }
        System.arraycopy(elementData, index, elementData, index + 1, s - index);
        elementData[index] = element;
        this.size = s + 1;
    }

    @Override
    public E remove(int index) {
        Objects.checkIndex(index, this.size);
        Object[] es = this.elementData;
        Object oldValue = es[index];
        this.fastRemove(es, index);
        return (E)oldValue;
    }

    @Override
    public E removeLast() {
        return this.remove(this.size - 1);
    }

    @Override
    public int indexOf(Object o) {
        Object[] es = this.elementData;
        int size = this.size;
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] es = this.elementData;
        int size = this.size;
        if (o == null) {
            for (int i = size - 1; i >= 0; --i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.rangeCheckForAdd(index);
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public void truncate(int newSize) {
        if (newSize >= this.size) {
            return;
        }
        for (int i = newSize; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = newSize;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public void close() {
        if (this.elementData != null) {
            this.memoryTracker.releaseHeap(this.trackedSize + SHALLOW_SIZE);
            this.elementData = null;
        }
    }

    public Iterator<E> autoClosingIterator() {
        return new Iterator<E>(){
            int index;

            @Override
            public boolean hasNext() {
                if (this.index >= HeapTrackingArrayList.this.size) {
                    HeapTrackingArrayList.this.close();
                    return false;
                }
                return true;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return HeapTrackingArrayList.this.elementData(this.index++);
            }
        };
    }

    @Override
    public void sort(Comparator<? super E> c) {
        int expectedModCount = this.modCount;
        Arrays.sort(this.elementData, 0, this.size, c);
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean remove(Object o) {
        int i;
        Object[] es;
        block6: {
            es = this.elementData;
            int size = this.size;
            if (o == null) {
                for (i = 0; i < size; ++i) {
                    if (es[i] != null) {
                        continue;
                    }
                    break block6;
                }
            } else {
                while (i < size) {
                    if (!o.equals(es[i])) {
                        ++i;
                        continue;
                    }
                    break block6;
                }
            }
            return false;
        }
        this.fastRemove(es, i);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        int expectedModCount = this.modCount;
        boolean equal = o.getClass() == HeapTrackingArrayList.class ? this.equalsArrayList((HeapTrackingArrayList)o) : this.equalsRange((List)o, 0, this.size);
        this.checkForComodification(expectedModCount);
        return equal;
    }

    @Override
    public int hashCode() {
        int expectedModCount = this.modCount;
        int hash = this.hashCodeRange(0, this.size);
        this.checkForComodification(expectedModCount);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        this.forEach((Consumer<? super E>)((Consumer<Object>)elem -> sb.append(elem).append(",")));
        if (this.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] es = this.elementData;
        int to = this.size;
        this.size = 0;
        for (int i = 0; i < to; ++i) {
            es[i] = null;
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Object[] es = this.elementData;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            action.accept(HeapTrackingArrayList.elementAt(es, i));
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private Object[] grow(int minimumCapacity) {
        int newCapacity = HeapTrackingArrayList.newCapacity(minimumCapacity, this.elementData.length);
        long oldHeapUsage = this.trackedSize;
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)newCapacity);
        this.memoryTracker.allocateHeap(this.trackedSize);
        Object[] newItems = new Object[newCapacity];
        System.arraycopy(this.elementData, 0, newItems, 0, Math.min(this.size, newCapacity));
        this.elementData = newItems;
        this.memoryTracker.releaseHeap(oldHeapUsage);
        return this.elementData;
    }

    static int newCapacity(int minimumCapacity, int oldCapacity) {
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minimumCapacity <= 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minimumCapacity;
        }
        return newCapacity - 0x7FFFFFF7 <= 0 ? newCapacity : HeapTrackingArrayList.hugeCapacity(minimumCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    private E elementData(int index) {
        return (E)this.elementData[index];
    }

    private static <E> E elementAt(Object[] es, int index) {
        return (E)es[index];
    }

    private void add(E e, Object[] elementData, int s) {
        if (s == elementData.length) {
            elementData = this.grow(this.size + 1);
        }
        elementData[s] = e;
        this.size = s + 1;
    }

    private void fastRemove(Object[] es, int i) {
        ++this.modCount;
        int newSize = this.size - 1;
        if (newSize > i) {
            System.arraycopy(es, i + 1, es, i, newSize - i);
        }
        this.size = newSize;
        es[this.size] = null;
    }

    private void checkForComodification(int expectedModCount) {
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private boolean equalsRange(List<?> other, int from, int to) {
        Object[] es = this.elementData;
        if (to > es.length) {
            throw new ConcurrentModificationException();
        }
        Iterator<?> oit = other.iterator();
        while (from < to) {
            if (!oit.hasNext() || !Objects.equals(es[from], oit.next())) {
                return false;
            }
            ++from;
        }
        return !oit.hasNext();
    }

    private boolean equalsArrayList(HeapTrackingArrayList<?> other) {
        int otherModCount = other.modCount;
        int s = this.size;
        boolean equal = s == other.size;
        if (equal) {
            Object[] otherEs = other.elementData;
            Object[] es = this.elementData;
            if (s > es.length || s > otherEs.length) {
                throw new ConcurrentModificationException();
            }
            for (int i = 0; i < s; ++i) {
                if (Objects.equals(es[i], otherEs[i])) continue;
                equal = false;
                break;
            }
        }
        other.checkForComodification(otherModCount);
        return equal;
    }

    private int hashCodeRange(int from, int to) {
        Object[] es = this.elementData;
        if (to > es.length) {
            throw new ConcurrentModificationException();
        }
        int hashCode = 1;
        for (int i = from; i < to; ++i) {
            Object e = es[i];
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    private boolean batchRemove(Collection<?> c, boolean complement, int from, int end) {
        Objects.requireNonNull(c);
        Object[] es = this.elementData;
        int r = from;
        while (true) {
            if (r == end) {
                return false;
            }
            if (c.contains(es[r]) != complement) break;
            ++r;
        }
        int w = r++;
        try {
            while (r < end) {
                Object e = es[r];
                if (c.contains(e) == complement) {
                    es[w++] = e;
                }
                ++r;
            }
        }
        catch (Throwable ex) {
            System.arraycopy(es, r, es, w, end - r);
            w += end - r;
            throw ex;
        }
        finally {
            this.modCount += end - w;
            this.shiftTailOverGap(es, w, end);
        }
        return true;
    }

    private void shiftTailOverGap(Object[] es, int lo, int hi) {
        System.arraycopy(es, hi, es, lo, this.size - hi);
        int to = this.size;
        for (int i = this.size -= hi - lo; i < to; ++i) {
            es[i] = null;
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = HeapTrackingArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                HeapTrackingArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                HeapTrackingArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = HeapTrackingArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = HeapTrackingArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != HeapTrackingArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= HeapTrackingArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = HeapTrackingArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                HeapTrackingArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = HeapTrackingArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int size = HeapTrackingArrayList.this.size;
            if (i < size) {
                Object[] es = HeapTrackingArrayList.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                for (i = this.cursor; i < size && HeapTrackingArrayList.this.modCount == this.expectedModCount; ++i) {
                    action.accept(HeapTrackingArrayList.elementAt(es, i));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (HeapTrackingArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

