/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public final class HeapTrackingIntHashSet
extends IntHashSet
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingIntHashSet.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final MemoryTracker memoryTracker;
    private int trackedCapacity;

    public static HeapTrackingIntHashSet createIntHashSet(MemoryTracker memoryTracker) {
        return HeapTrackingIntHashSet.createIntHashSet(memoryTracker, 16);
    }

    static HeapTrackingIntHashSet createIntHashSet(MemoryTracker memoryTracker, HeapTrackingIntHashSet set) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingIntHashSet.arrayHeapSize(set.trackedCapacity));
        return new HeapTrackingIntHashSet(memoryTracker, set);
    }

    static HeapTrackingIntHashSet createIntHashSet(MemoryTracker memoryTracker, IntSet set) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new HeapTrackingIntHashSet(memoryTracker, set);
    }

    static HeapTrackingIntHashSet createIntHashSet(MemoryTracker memoryTracker, int initialCapacity) {
        int capacity = Numbers.ceilingPowerOfTwo((int)(initialCapacity << 1));
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingIntHashSet.arrayHeapSize(capacity));
        return new HeapTrackingIntHashSet(memoryTracker, initialCapacity, capacity);
    }

    private HeapTrackingIntHashSet(MemoryTracker memoryTracker, int initialCapacity, int actualCapacity) {
        super(initialCapacity);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = actualCapacity;
    }

    private HeapTrackingIntHashSet(MemoryTracker memoryTracker, HeapTrackingIntHashSet set) {
        super((IntHashSet)set);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = set.trackedCapacity;
    }

    private HeapTrackingIntHashSet(MemoryTracker memoryTracker, IntSet set) {
        super((IntIterable)set);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingIntHashSet.arrayHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingIntHashSet.arrayHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingIntHashSet.arrayHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    @VisibleForTesting
    public static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 4L));
    }
}

