/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.block.factory.HashingStrategies;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

class HeapTrackingUnifiedIdentityHashingSet<T>
extends UnifiedSetWithHashingStrategy<T>
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingUnifiedIdentityHashingSet.class);
    private final MemoryTracker memoryTracker;
    private int trackedCapacity;

    static <T> HeapTrackingUnifiedIdentityHashingSet<T> createUnifiedIdentityHashingSet(MemoryTracker memoryTracker) {
        int initialSizeToAllocate = 16;
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingUnifiedIdentityHashingSet.arrayHeapSize(initialSizeToAllocate));
        return new HeapTrackingUnifiedIdentityHashingSet<T>(memoryTracker, initialSizeToAllocate);
    }

    private HeapTrackingUnifiedIdentityHashingSet(MemoryTracker memoryTracker, int trackedCapacity) {
        super(HashingStrategies.identityStrategy());
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingUnifiedIdentityHashingSet.arrayHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingUnifiedIdentityHashingSet.arrayHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE + HeapTrackingUnifiedIdentityHashingSet.arrayHeapSize(this.trackedCapacity));
    }

    @VisibleForTesting
    int getIndex(T key) {
        return this.index(key);
    }

    static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * (long)HeapEstimator.OBJECT_REFERENCE_BYTES));
    }
}

