/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class PrefetchingIterator<T>
implements Iterator<T> {
    boolean hasFetchedNext;
    T nextObject;

    @Override
    public boolean hasNext() {
        return this.peek() != null;
    }

    public T peek() {
        if (this.hasFetchedNext) {
            return this.nextObject;
        }
        this.nextObject = this.fetchNextOrNull();
        this.hasFetchedNext = true;
        return this.nextObject;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextObject;
        this.nextObject = null;
        this.hasFetchedNext = false;
        return result;
    }

    protected abstract T fetchNextOrNull();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

