/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.ResourceIteratorCloseFailedException;

public abstract class AbstractResourceIterable<T>
implements ResourceIterable<T> {
    private TrackingResourceIterator<?>[] trackedIterators = new TrackingResourceIterator[2];
    private long trackedIteratorsInUse;
    private boolean closed;

    protected abstract ResourceIterator<T> newIterator();

    public final ResourceIterator<T> iterator() {
        if (this.closed) {
            throw new ResourceIteratorCloseFailedException(ResourceIterable.class.getSimpleName() + " has already been closed");
        }
        return new TrackingResourceIterator<T>(Objects.requireNonNull(this.newIterator()), this::register, this::unregister);
    }

    public final void close() {
        if (!this.closed) {
            try {
                this.internalClose();
            }
            finally {
                this.closed = true;
                this.onClosed();
            }
        }
    }

    protected void onClosed() {
    }

    private int register(TrackingResourceIterator<?> iterator) {
        assert (Long.bitCount(this.trackedIteratorsInUse) < 64);
        if (Long.bitCount(this.trackedIteratorsInUse) == this.trackedIterators.length) {
            this.trackedIterators = Arrays.copyOf(this.trackedIterators, this.trackedIterators.length << 1);
        }
        int index = Long.numberOfTrailingZeros(this.trackedIteratorsInUse ^ 0xFFFFFFFFFFFFFFFFL);
        this.trackedIterators[index] = iterator;
        this.trackedIteratorsInUse |= AbstractResourceIterable.trackBit(index);
        return index;
    }

    private void unregister(TrackingResourceIterator<?> iterator) {
        assert ((this.trackedIteratorsInUse & AbstractResourceIterable.trackBit(iterator.registerIndex)) != 0L);
        this.trackedIterators[iterator.registerIndex] = null;
        this.untrack(iterator.registerIndex);
    }

    private static long trackBit(int index) {
        return 1L << index;
    }

    private void untrack(int index) {
        this.trackedIteratorsInUse ^= AbstractResourceIterable.trackBit(index);
    }

    private void internalClose() {
        Throwable closeThrowable = null;
        while (this.trackedIteratorsInUse != 0L) {
            int index = Long.numberOfTrailingZeros(this.trackedIteratorsInUse);
            try {
                this.trackedIterators[index].internalClose();
            }
            catch (Exception e) {
                if (closeThrowable == null) {
                    closeThrowable = new ResourceIteratorCloseFailedException("Exception closing a resource iterator.", e);
                }
                closeThrowable.addSuppressed(e);
            }
            this.untrack(index);
        }
        this.trackedIterators = null;
        if (closeThrowable != null) {
            throw closeThrowable;
        }
    }

    private static final class TrackingResourceIterator<T>
    implements ResourceIterator<T> {
        private final ResourceIterator<T> delegate;
        private final ToIntFunction<TrackingResourceIterator<?>> registerCallback;
        private final Consumer<TrackingResourceIterator<?>> unregisterCallback;
        private final int registerIndex;
        private boolean closed;

        private TrackingResourceIterator(ResourceIterator<T> delegate, ToIntFunction<TrackingResourceIterator<?>> registerCallback, Consumer<TrackingResourceIterator<?>> unregisterCallback) {
            this.delegate = delegate;
            this.registerCallback = registerCallback;
            this.unregisterCallback = unregisterCallback;
            this.registerIndex = registerCallback.applyAsInt(this);
        }

        public boolean hasNext() {
            boolean hasNext = this.delegate.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        public T next() {
            return (T)this.delegate.next();
        }

        public <R> ResourceIterator<R> map(Function<T, R> map) {
            return new TrackingResourceIterator<T>(super.map(map), this.registerCallback, this.unregisterCallback);
        }

        public void close() {
            if (!this.closed) {
                this.internalClose();
                this.unregisterCallback.accept(this);
            }
        }

        private void internalClose() {
            try {
                this.delegate.close();
            }
            finally {
                this.closed = true;
            }
        }
    }
}

