/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.trackable.HeapTrackingArrayDeque;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntHashSet;
import org.neo4j.collection.trackable.HeapTrackingIntIntHashMap;
import org.neo4j.collection.trackable.HeapTrackingIntObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.collection.trackable.HeapTrackingLongIntHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongLongHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongStack;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.memory.MemoryTracker;

public final class HeapTrackingCollections {
    private HeapTrackingCollections() {
    }

    public static HeapTrackingIntHashSet newIntSet(MemoryTracker memoryTracker) {
        return HeapTrackingIntHashSet.createIntHashSet(memoryTracker);
    }

    public static HeapTrackingIntHashSet newIntSet(MemoryTracker memoryTracker, int initialCapacity) {
        return HeapTrackingIntHashSet.createIntHashSet(memoryTracker, initialCapacity);
    }

    public static HeapTrackingIntHashSet newIntSet(MemoryTracker memoryTracker, HeapTrackingIntHashSet set) {
        return HeapTrackingIntHashSet.createIntHashSet(memoryTracker, set);
    }

    public static HeapTrackingIntHashSet newIntSet(MemoryTracker memoryTracker, IntSet set) {
        return HeapTrackingIntHashSet.createIntHashSet(memoryTracker, set);
    }

    public static HeapTrackingIntHashSet newIntSet(MemoryTracker memoryTracker, IntIterable iterable) {
        return HeapTrackingIntHashSet.createIntHashSet(memoryTracker, iterable);
    }

    public static <V> HeapTrackingIntObjectHashMap<V> newIntObjectHashMap(MemoryTracker memoryTracker) {
        return HeapTrackingIntObjectHashMap.createIntObjectHashMap(memoryTracker);
    }

    public static HeapTrackingLongHashSet newLongSet(MemoryTracker memoryTracker) {
        return HeapTrackingLongHashSet.createLongHashSet(memoryTracker);
    }

    public static HeapTrackingLongHashSet newLongSet(MemoryTracker memoryTracker, int initialCapacity) {
        return HeapTrackingLongHashSet.createLongHashSet(memoryTracker, initialCapacity);
    }

    public static HeapTrackingLongHashSet newLongSet(MemoryTracker memoryTracker, HeapTrackingLongHashSet set) {
        return HeapTrackingLongHashSet.createLongHashSet(memoryTracker, set);
    }

    public static HeapTrackingLongHashSet newLongSet(MemoryTracker memoryTracker, LongSet set) {
        return HeapTrackingLongHashSet.createLongHashSet(memoryTracker, set);
    }

    public static <V> HeapTrackingLongObjectHashMap<V> newLongObjectMap(MemoryTracker memoryTracker) {
        return HeapTrackingLongObjectHashMap.createLongObjectHashMap(memoryTracker);
    }

    public static <V> HeapTrackingLongObjectHashMap<V> newLongObjectMap(MemoryTracker memoryTracker, int initialCapacity) {
        return HeapTrackingLongObjectHashMap.createLongObjectHashMap(memoryTracker, initialCapacity);
    }

    public static HeapTrackingLongIntHashMap newLongIntMap(MemoryTracker memoryTracker) {
        return HeapTrackingLongIntHashMap.createLongIntHashMap(memoryTracker);
    }

    public static HeapTrackingIntIntHashMap newIntIntMap(MemoryTracker memoryTracker) {
        return HeapTrackingIntIntHashMap.createIntIntHashMap(memoryTracker);
    }

    public static <K, V> HeapTrackingUnifiedMap<K, V> newMap(MemoryTracker memoryTracker) {
        return HeapTrackingUnifiedMap.createUnifiedMap(memoryTracker);
    }

    public static <K, V> HeapTrackingUnifiedMap<K, V> newMap(int initialCapacity, MemoryTracker memoryTracker) {
        return HeapTrackingUnifiedMap.createUnifiedMap(initialCapacity, memoryTracker);
    }

    public static HeapTrackingLongLongHashMap newLongLongMap(MemoryTracker memoryTracker) {
        return HeapTrackingLongLongHashMap.createLongLongHashMap(memoryTracker);
    }

    public static <T> HeapTrackingUnifiedSet<T> newSet(MemoryTracker memoryTracker) {
        return HeapTrackingUnifiedSet.createUnifiedSet(memoryTracker);
    }

    public static <T> HeapTrackingUnifiedSet<T> newSet(MemoryTracker memoryTracker, Iterable<T> iterable) {
        return HeapTrackingUnifiedSet.createUnifiedSet(memoryTracker, iterable);
    }

    public static <T> HeapTrackingArrayList<T> newArrayList(int initialSize, MemoryTracker memoryTracker) {
        return HeapTrackingArrayList.newArrayList(initialSize, memoryTracker);
    }

    public static <T> HeapTrackingArrayList<T> newArrayList(MemoryTracker memoryTracker) {
        return HeapTrackingArrayList.newArrayList(memoryTracker);
    }

    public static HeapTrackingLongStack newLongStack(MemoryTracker memoryTracker) {
        return new HeapTrackingLongStack(HeapTrackingLongArrayList.newLongArrayList(memoryTracker));
    }

    public static <T> HeapTrackingArrayDeque<T> newArrayDeque(MemoryTracker memoryTracker) {
        return HeapTrackingArrayDeque.newArrayDeque(memoryTracker);
    }
}

