/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class HeapTrackingObjectMap<T extends Measurable>
extends HeapTrackingLongObjectHashMap<T> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingObjectMap.class);
    private long valuesHeapSize;

    public static <T extends Measurable> HeapTrackingObjectMap<T> createObjectMap(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingObjectMap.arraysHeapSize(16));
        return new HeapTrackingObjectMap<T>(memoryTracker, 16);
    }

    private HeapTrackingObjectMap(MemoryTracker memoryTracker, int trackedCapacity) {
        super(memoryTracker, trackedCapacity);
    }

    public T put(long key, T value) {
        this.allocate(value);
        Measurable old = (Measurable)super.put(key, value);
        if (old != null) {
            this.release(old);
        }
        return (T)old;
    }

    public T remove(long key) {
        Measurable remove = (Measurable)super.remove(key);
        if (remove != null) {
            this.release(remove);
        }
        return (T)remove;
    }

    public void clear() {
        super.clear();
        this.memoryTracker.releaseHeap(this.valuesHeapSize);
        this.valuesHeapSize = 0L;
    }

    private void allocate(T value) {
        long valueHeapSize = value.estimatedHeapUsage();
        this.valuesHeapSize += valueHeapSize;
        this.memoryTracker.allocateHeap(valueHeapSize);
    }

    private void release(T old) {
        long oldHeapSize = old.estimatedHeapUsage();
        this.valuesHeapSize -= oldHeapSize;
        this.memoryTracker.releaseHeap(oldHeapSize);
    }
}

