/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.function.Predicates;

public abstract class StoragePathAttributes
implements BasicFileAttributes {
    private static final List<Method> ATTRIBUTES = Stream.of("size", "lastModifiedTime", "lastAccessTime", "creationTime", "isRegularFile", "isDirectory", "isSymbolicLink", "isOther", "fileKey").map(name -> {
        try {
            return BasicFileAttributes.class.getMethod((String)name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }).toList();
    protected final StoragePath path;

    protected StoragePathAttributes(StoragePath path) {
        this.path = path;
    }

    @Override
    public FileTime lastAccessTime() {
        return this.creationTime();
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.creationTime();
    }

    @Override
    public boolean isRegularFile() {
        return !this.path.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.path.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    public Map<String, Object> asMap() {
        return this.asMap(Predicates.alwaysTrue());
    }

    public Map<String, Object> asMap(Predicate<String> attributeFilter) {
        StoragePathAttributes self = this;
        MutableMap attrs = Maps.mutable.empty();
        ATTRIBUTES.stream().filter(method -> attributeFilter.test(method.getName())).forEach(method -> {
            try {
                attrs.put((Object)method.getName(), method.invoke((Object)self, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        return attrs;
    }
}

