/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.throttle;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.util.Preconditions;

public class ChannelReadThrottleHandler
extends ChannelDuplexHandler {
    private final int lowWatermark;
    private final int highWatermark;
    private final InternalLog log;
    private boolean throttled;
    private int size;

    public ChannelReadThrottleHandler(int lowWatermark, int highWatermark, InternalLogProvider logging) {
        Preconditions.checkArgument((lowWatermark > 0 ? 1 : 0) != 0, (String)"lowWatermark must be positive");
        Preconditions.checkArgument((lowWatermark <= highWatermark ? 1 : 0) != 0, (String)"lowWatermark must be less than or equal to highWatermark");
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
        this.log = logging.getLog(ChannelReadThrottleHandler.class);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (++this.size >= this.highWatermark) {
            this.log.warn("[%s] Inbound message queue has exceeded high watermark - Disabling message processing", new Object[]{ctx.channel().remoteAddress()});
            ctx.channel().config().setAutoRead(false);
            this.throttled = true;
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg == StateSignal.END_JOB_PROCESSING && --this.size <= this.lowWatermark && this.throttled) {
            this.log.info("[%s] Inbound message queue has reached low watermark - Enabling message processing", new Object[]{ctx.channel().remoteAddress()});
            ctx.channel().config().setAutoRead(true);
            this.throttled = false;
        }
        ctx.write(msg, promise);
    }
}

