/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum AccessMode {
    WRITE("w"),
    READ("r");

    private static final Map<String, AccessMode> flagToModeMap;
    private final String flag;

    private AccessMode(String flag) {
        this.flag = flag;
    }

    public String getFlag() {
        return this.flag;
    }

    public static Optional<AccessMode> byFlag(String flag) {
        return Optional.ofNullable(flagToModeMap.get(flag));
    }

    static {
        AccessMode[] values = AccessMode.values();
        HashMap<String, AccessMode> mutableFlagMap = new HashMap<String, AccessMode>(1 + values.length);
        mutableFlagMap.put("a", WRITE);
        for (AccessMode mode : values) {
            mutableFlagMap.put(mode.flag, mode);
        }
        flagToModeMap = Map.copyOf(mutableFlagMap);
    }
}

