/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.error.TransactionStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.StreamingStateTransition;
import org.neo4j.bolt.protocol.common.message.request.streaming.AbstractStreamingMessage;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.statement.Statement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AutocommitStateTransition<R extends AbstractStreamingMessage>
extends StreamingStateTransition<R> {
    protected AutocommitStateTransition(Class<R> requestType) {
        super(requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateReference process(Context ctx, Transaction tx, Statement statement, R message, ResponseHandler handler) throws StateMachineException {
        String bookmark;
        super.process(ctx, tx, statement, message, handler);
        if (statement.hasRemaining()) {
            return ctx.state();
        }
        try {
            try {
                bookmark = tx.commit();
            }
            finally {
                ctx.connection().closeTransaction();
                ctx.connection().clearImpersonation();
            }
        }
        catch (TransactionException ex) {
            throw new TransactionStateTransitionException(ex);
        }
        handler.onBookmark(bookmark);
        return States.READY;
    }
}

