/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.ready;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.error.AuthenticationStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.error.TransactionStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.transaction.BeginMessage;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.bolt.tx.error.TransactionException;

public final class CreateTransactionStateTransition
extends AbstractStateTransition<BeginMessage> {
    private static final CreateTransactionStateTransition INSTANCE = new CreateTransactionStateTransition();

    private CreateTransactionStateTransition() {
        super(BeginMessage.class);
    }

    public static CreateTransactionStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    public StateReference process(Context ctx, BeginMessage message, ResponseHandler handler) throws StateMachineException {
        if (message.impersonatedUser() != null) {
            try {
                ctx.connection().impersonate(message.impersonatedUser());
            }
            catch (AuthenticationException ex) {
                throw new AuthenticationStateTransitionException(ex);
            }
        }
        try {
            ctx.connection().beginTransaction(message.type(), message.databaseName(), message.getAccessMode(), message.bookmarks(), message.transactionTimeout(), message.transactionMetadata(), message.notificationsConfig());
        }
        catch (TransactionException ex) {
            throw new TransactionStateTransitionException(ex);
        }
        return States.IN_TRANSACTION;
    }
}

