/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.codec.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.function.Predicate;
import org.neo4j.packstream.signal.FrameSignal;

public class FrameSignalEncoder
extends MessageToByteEncoder<FrameSignal> {
    private final Predicate<FrameSignal> filterPredicate;
    private boolean dirty;

    public FrameSignalEncoder(Predicate<FrameSignal> filterPredicate) {
        this.filterPredicate = filterPredicate;
    }

    public FrameSignalEncoder() {
        this(null);
    }

    protected void encode(ChannelHandlerContext ctx, FrameSignal msg, ByteBuf out) throws Exception {
        if (this.filterPredicate != null && this.filterPredicate.test(msg)) {
            return;
        }
        if (this.dirty && msg.requiresCleanState()) {
            return;
        }
        if (msg == FrameSignal.MESSAGE_END) {
            this.dirty = false;
        }
        out.writeShort(msg.getTag());
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.dirty = true;
        }
        super.write(ctx, msg, promise);
    }
}

