/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v51.fsm.state;

import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.connector.connection.MutableConnectionState;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.authentication.HelloMessage;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValueBuilder;

public class NegotiationState
implements State {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NegotiationState.class);
    private static final String CONNECTION_ID_KEY = "connection_id";
    protected State authenticationState;

    @Override
    public String name() {
        return "NEGOTIATION";
    }

    @Override
    public State process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        Preconditions.checkState((this.authenticationState != null ? 1 : 0) != 0, (String)"Authentication state not set");
        if (message instanceof HelloMessage) {
            HelloMessage helloMessage = (HelloMessage)message;
            List<Feature> features = helloMessage.features();
            String userAgent = helloMessage.userAgent();
            RoutingContext routingContext = helloMessage.routingContext();
            NotificationsConfig notificationsConfig = helloMessage.notificationsConfig();
            Map<String, String> boltAgent = helloMessage.boltAgent();
            List<Feature> enabledFeatures = context.connection().negotiate(features, userAgent, routingContext, notificationsConfig, boltAgent);
            MutableConnectionState connectionState = context.connectionState();
            StateMachineSPI boltSpi = context.boltSpi();
            connectionState.onMetadata(CONNECTION_ID_KEY, (AnyValue)Values.utf8Value((String)context.connectionId()));
            connectionState.onMetadata("server", (AnyValue)Values.utf8Value((String)boltSpi.version()));
            MapValueBuilder connectionHints = new MapValueBuilder();
            context.connection().connector().connectionHintProvider().append(connectionHints);
            connectionState.onMetadata("hints", (AnyValue)connectionHints.build());
            if (!enabledFeatures.isEmpty()) {
                ListValueBuilder builder = ListValueBuilder.newListBuilder((int)enabledFeatures.size());
                enabledFeatures.forEach(feature -> builder.add((AnyValue)Values.stringValue((String)feature.getId())));
                context.connectionState().onMetadata("patch_bolt", (AnyValue)builder.build());
            }
            return this.authenticationState;
        }
        return null;
    }

    public void setAuthenticationState(State authenticationState) {
        this.authenticationState = authenticationState;
    }
}

