/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v51.fsm;

import java.time.Clock;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.AbstractStateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.fsm.state.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.state.AutoCommitState;
import org.neo4j.bolt.protocol.v43.fsm.state.FailedState;
import org.neo4j.bolt.protocol.v44.fsm.state.InTransactionState;
import org.neo4j.bolt.protocol.v51.fsm.state.AuthenticationState;
import org.neo4j.bolt.protocol.v51.fsm.state.NegotiationState;
import org.neo4j.bolt.protocol.v51.fsm.state.ReadyState;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class StateMachineV51
extends AbstractStateMachine {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StateMachineV51.class);

    public StateMachineV51(StateMachineSPI spi, Connection connection, Clock clock) {
        super(spi, connection, clock);
    }

    @Override
    protected AbstractStateMachine.States buildStates(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(NegotiationState.SHALLOW_SIZE + ReadyState.SHALLOW_SIZE + AuthenticationState.SHALLOW_SIZE + AutoCommitState.SHALLOW_SIZE + InTransactionState.SHALLOW_SIZE + FailedState.SHALLOW_SIZE + InterruptedState.SHALLOW_SIZE);
        NegotiationState negotiation = new NegotiationState();
        AuthenticationState authentication = new AuthenticationState();
        AutoCommitState autoCommitState = new AutoCommitState();
        InTransactionState inTransaction = new InTransactionState();
        FailedState failed = new FailedState();
        ReadyState ready = new ReadyState();
        InterruptedState interrupted = new InterruptedState();
        negotiation.setAuthenticationState(authentication);
        authentication.setReadyState(ready);
        authentication.setFailedState(failed);
        ready.setTransactionReadyState(inTransaction);
        ready.setStreamingState(autoCommitState);
        ready.setFailedState(failed);
        ready.setAuthenticationState(authentication);
        autoCommitState.setReadyState(ready);
        autoCommitState.setFailedState(failed);
        inTransaction.setReadyState(ready);
        inTransaction.setFailedState(failed);
        interrupted.setReadyState(ready);
        return new AbstractStateMachine.States(negotiation, failed, interrupted);
    }
}

