/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.packstream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.bolt.messaging.StructType;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackType;
import org.neo4j.bolt.v1.packstream.utf8.UTF8Encoder;

public class PackStream {
    public static final byte TINY_STRING = -128;
    public static final byte TINY_LIST = -112;
    public static final byte TINY_MAP = -96;
    public static final byte TINY_STRUCT = -80;
    public static final byte NULL = -64;
    public static final byte FLOAT_64 = -63;
    public static final byte FALSE = -62;
    public static final byte TRUE = -61;
    public static final byte RESERVED_C4 = -60;
    public static final byte RESERVED_C5 = -59;
    public static final byte RESERVED_C6 = -58;
    public static final byte RESERVED_C7 = -57;
    public static final byte INT_8 = -56;
    public static final byte INT_16 = -55;
    public static final byte INT_32 = -54;
    public static final byte INT_64 = -53;
    public static final byte BYTES_8 = -52;
    public static final byte BYTES_16 = -51;
    public static final byte BYTES_32 = -50;
    public static final byte RESERVED_CF = -49;
    public static final byte STRING_8 = -48;
    public static final byte STRING_16 = -47;
    public static final byte STRING_32 = -46;
    public static final byte RESERVED_D3 = -45;
    public static final byte LIST_8 = -44;
    public static final byte LIST_16 = -43;
    public static final byte LIST_32 = -42;
    public static final byte LIST_STREAM = -41;
    public static final byte MAP_8 = -40;
    public static final byte MAP_16 = -39;
    public static final byte MAP_32 = -38;
    public static final byte MAP_STREAM = -37;
    public static final byte STRUCT_8 = -36;
    public static final byte STRUCT_16 = -35;
    public static final byte RESERVED_DE = -34;
    public static final byte END_OF_STREAM = -33;
    public static final byte RESERVED_E0 = -32;
    public static final byte RESERVED_E1 = -31;
    public static final byte RESERVED_E2 = -30;
    public static final byte RESERVED_E3 = -29;
    public static final byte RESERVED_E4 = -28;
    public static final byte RESERVED_E5 = -27;
    public static final byte RESERVED_E6 = -26;
    public static final byte RESERVED_E7 = -25;
    public static final byte RESERVED_E8 = -24;
    public static final byte RESERVED_E9 = -23;
    public static final byte RESERVED_EA = -22;
    public static final byte RESERVED_EB = -21;
    public static final byte RESERVED_EC = -20;
    public static final byte RESERVED_ED = -19;
    public static final byte RESERVED_EE = -18;
    public static final byte RESERVED_EF = -17;
    public static final long UNKNOWN_SIZE = -1L;
    private static final long PLUS_2_TO_THE_31 = 0x80000000L;
    private static final long PLUS_2_TO_THE_15 = 32768L;
    private static final long PLUS_2_TO_THE_7 = 128L;
    private static final long MINUS_2_TO_THE_4 = -16L;
    private static final long MINUS_2_TO_THE_7 = -128L;
    private static final long MINUS_2_TO_THE_15 = -32768L;
    private static final long MINUS_2_TO_THE_31 = Integer.MIN_VALUE;

    private PackStream() {
    }

    private static PackType type(byte markerByte) {
        byte markerHighNibble = (byte)(markerByte & 0xF0);
        switch (markerHighNibble) {
            case -128: {
                return PackType.STRING;
            }
            case -112: {
                return PackType.LIST;
            }
            case -96: {
                return PackType.MAP;
            }
            case -80: {
                return PackType.STRUCT;
            }
        }
        if ((long)markerByte >= -16L) {
            return PackType.INTEGER;
        }
        switch (markerByte) {
            case -64: {
                return PackType.NULL;
            }
            case -62: 
            case -61: {
                return PackType.BOOLEAN;
            }
            case -63: {
                return PackType.FLOAT;
            }
            case -52: 
            case -51: 
            case -50: {
                return PackType.BYTES;
            }
            case -48: 
            case -47: 
            case -46: {
                return PackType.STRING;
            }
            case -44: 
            case -43: 
            case -42: 
            case -41: {
                return PackType.LIST;
            }
            case -40: 
            case -39: 
            case -38: 
            case -37: {
                return PackType.MAP;
            }
            case -36: 
            case -35: {
                return PackType.STRUCT;
            }
            case -33: {
                return PackType.END_OF_STREAM;
            }
            case -56: 
            case -55: 
            case -54: 
            case -53: {
                return PackType.INTEGER;
            }
        }
        return PackType.RESERVED;
    }

    public static class Unexpected
    extends PackStreamException {
        public Unexpected(PackType expectedType, byte unexpectedMarkerByte) {
            super("Wrong type received. Expected " + (Object)((Object)expectedType) + ", received: " + (Object)((Object)PackStream.type(unexpectedMarkerByte)) + " (0x" + Integer.toHexString(unexpectedMarkerByte) + ").");
        }
    }

    public static class Overflow
    extends PackStreamException {
        public Overflow(String message) {
            super(message);
        }
    }

    public static class EndOfStream
    extends PackStreamException {
        public EndOfStream(String message) {
            super(message);
        }
    }

    public static class PackStreamException
    extends IOException {
        public PackStreamException(String message) {
            super(message);
        }
    }

    public static class Unpacker {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        protected PackInput in;

        public Unpacker(PackInput in) {
            this.in = in;
        }

        public long unpackStructHeader() throws IOException {
            byte markerByte = this.in.readByte();
            byte markerHighNibble = (byte)(markerByte & 0xF0);
            byte markerLowNibble = (byte)(markerByte & 0xF);
            if (markerHighNibble == -80) {
                return markerLowNibble;
            }
            switch (markerByte) {
                case -36: {
                    return this.unpackUINT8();
                }
                case -35: {
                    return this.unpackUINT16();
                }
            }
            throw new Unexpected(PackType.STRUCT, markerByte);
        }

        public char unpackStructSignature() throws IOException {
            return (char)this.in.readByte();
        }

        public long unpackListHeader() throws IOException {
            byte markerByte = this.in.readByte();
            byte markerHighNibble = (byte)(markerByte & 0xF0);
            byte markerLowNibble = (byte)(markerByte & 0xF);
            if (markerHighNibble == -112) {
                return markerLowNibble;
            }
            switch (markerByte) {
                case -44: {
                    return this.unpackUINT8();
                }
                case -43: {
                    return this.unpackUINT16();
                }
                case -42: {
                    return this.unpackUINT32();
                }
                case -41: {
                    return -1L;
                }
            }
            throw new Unexpected(PackType.LIST, markerByte);
        }

        public long unpackMapHeader() throws IOException {
            byte markerByte = this.in.readByte();
            byte markerHighNibble = (byte)(markerByte & 0xF0);
            byte markerLowNibble = (byte)(markerByte & 0xF);
            if (markerHighNibble == -96) {
                return markerLowNibble;
            }
            switch (markerByte) {
                case -40: {
                    return this.unpackUINT8();
                }
                case -39: {
                    return this.unpackUINT16();
                }
                case -38: {
                    return this.unpackUINT32();
                }
                case -37: {
                    return -1L;
                }
            }
            throw new Unexpected(PackType.MAP, markerByte);
        }

        public int unpackInteger() throws IOException {
            byte markerByte = this.in.readByte();
            if ((long)markerByte >= -16L) {
                return markerByte;
            }
            switch (markerByte) {
                case -56: {
                    return this.in.readByte();
                }
                case -55: {
                    return this.in.readShort();
                }
                case -54: {
                    return this.in.readInt();
                }
                case -53: {
                    throw new Overflow("Unexpectedly large Integer value unpacked (" + this.in.readLong() + ")");
                }
            }
            throw new Unexpected(PackType.INTEGER, markerByte);
        }

        public long unpackLong() throws IOException {
            byte markerByte = this.in.readByte();
            if ((long)markerByte >= -16L) {
                return markerByte;
            }
            switch (markerByte) {
                case -56: {
                    return this.in.readByte();
                }
                case -55: {
                    return this.in.readShort();
                }
                case -54: {
                    return this.in.readInt();
                }
                case -53: {
                    return this.in.readLong();
                }
            }
            throw new Unexpected(PackType.INTEGER, markerByte);
        }

        public double unpackDouble() throws IOException {
            byte markerByte = this.in.readByte();
            if (markerByte == -63) {
                return this.in.readDouble();
            }
            throw new Unexpected(PackType.FLOAT, markerByte);
        }

        public byte[] unpackBytes() throws IOException {
            int size = this.unpackBytesHeader();
            return this.unpackRawBytes(size);
        }

        public String unpackString() throws IOException {
            return new String(this.unpackUTF8(), StandardCharsets.UTF_8);
        }

        public int unpackBytesHeader() throws IOException {
            int size;
            byte markerByte = this.in.readByte();
            switch (markerByte) {
                case -52: {
                    size = this.unpackUINT8();
                    break;
                }
                case -51: {
                    size = this.unpackUINT16();
                    break;
                }
                case -50: {
                    long longSize = this.unpackUINT32();
                    if (longSize <= Integer.MAX_VALUE) {
                        size = (int)longSize;
                        break;
                    }
                    throw new Overflow("BYTES_32 too long for Java");
                }
                default: {
                    throw new Unexpected(PackType.BYTES, markerByte);
                }
            }
            return size;
        }

        public int unpackStringHeader() throws IOException {
            int size;
            byte markerByte = this.in.readByte();
            byte markerHighNibble = (byte)(markerByte & 0xF0);
            int markerLowNibble = markerByte & 0xF;
            if (markerHighNibble == -128) {
                size = markerLowNibble;
            } else {
                switch (markerByte) {
                    case -48: {
                        size = this.unpackUINT8();
                        break;
                    }
                    case -47: {
                        size = this.unpackUINT16();
                        break;
                    }
                    case -46: {
                        long longSize = this.unpackUINT32();
                        if (longSize <= Integer.MAX_VALUE) {
                            size = (int)longSize;
                            break;
                        }
                        throw new Overflow("STRING_32 too long for Java");
                    }
                    default: {
                        throw new Unexpected(PackType.STRING, markerByte);
                    }
                }
            }
            return size;
        }

        public byte[] unpackUTF8() throws IOException {
            int size = this.unpackStringHeader();
            return this.unpackRawBytes(size);
        }

        public boolean unpackBoolean() throws IOException {
            byte markerByte = this.in.readByte();
            switch (markerByte) {
                case -61: {
                    return true;
                }
                case -62: {
                    return false;
                }
            }
            throw new Unexpected(PackType.BOOLEAN, markerByte);
        }

        public void unpackNull() throws IOException {
            byte markerByte = this.in.readByte();
            assert (markerByte == -64);
        }

        private int unpackUINT8() throws IOException {
            return this.in.readByte() & 0xFF;
        }

        private int unpackUINT16() throws IOException {
            return this.in.readShort() & 0xFFFF;
        }

        private long unpackUINT32() throws IOException {
            return (long)this.in.readInt() & 0xFFFFFFFFL;
        }

        public void unpackEndOfStream() throws IOException {
            byte markerByte = this.in.readByte();
            assert (markerByte == -33);
        }

        private byte[] unpackRawBytes(int size) throws IOException {
            if (size == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] heapBuffer = new byte[size];
            this.unpackRawBytesInto(heapBuffer, 0, heapBuffer.length);
            return heapBuffer;
        }

        private void unpackRawBytesInto(byte[] buffer, int offset, int size) throws IOException {
            if (size > 0) {
                this.in.readBytes(buffer, offset, size);
            }
        }

        public PackType peekNextType() throws IOException {
            byte markerByte = this.in.peekByte();
            return PackStream.type(markerByte);
        }

        public static void ensureCorrectStructSize(StructType structType, int expected, long actual) throws IOException {
            if ((long)expected != actual) {
                throw new PackStreamException(String.format("Invalid message received, serialized %s structures should have %d fields, received %s structure has %d fields.", structType.description(), expected, structType.description(), actual));
            }
        }
    }

    public static class Packer {
        private static final char PACKED_CHAR_START_CHAR = ' ';
        private static final char PACKED_CHAR_END_CHAR = '~';
        private static final String[] PACKED_CHARS = Packer.prePackChars();
        private UTF8Encoder utf8 = UTF8Encoder.fastestAvailableEncoder();
        protected PackOutput out;

        public Packer(PackOutput out) {
            this.out = out;
        }

        private static String[] prePackChars() {
            int size = 95;
            String[] packedChars = new String[size];
            for (int i = 0; i < size; ++i) {
                packedChars[i] = String.valueOf((char)(i + 32));
            }
            return packedChars;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void packNull() throws IOException {
            this.out.writeByte((byte)-64);
        }

        public void pack(boolean value) throws IOException {
            this.out.writeByte(value ? (byte)-61 : -62);
        }

        public void pack(long value) throws IOException {
            if (value >= -16L && value < 128L) {
                this.out.writeByte((byte)value);
            } else if (value >= -128L && value < -16L) {
                this.out.writeByte((byte)-56).writeByte((byte)value);
            } else if (value >= -32768L && value < 32768L) {
                this.out.writeByte((byte)-55).writeShort((short)value);
            } else if (value >= Integer.MIN_VALUE && value < 0x80000000L) {
                this.out.writeByte((byte)-54).writeInt((int)value);
            } else {
                this.out.writeByte((byte)-53).writeLong(value);
            }
        }

        public void pack(double value) throws IOException {
            this.out.writeByte((byte)-63).writeDouble(value);
        }

        public void pack(char character) throws IOException {
            if (character >= ' ' && character <= '~') {
                this.pack(PACKED_CHARS[character - 32]);
            } else {
                this.pack(String.valueOf(character));
            }
        }

        public void pack(byte[] value) throws IOException {
            if (value == null) {
                this.packNull();
            } else {
                this.packBytesHeader(value.length);
                this.out.writeBytes(value, 0, value.length);
            }
        }

        public void pack(String value) throws IOException {
            if (value == null) {
                this.packNull();
            } else {
                ByteBuffer encoded = this.utf8.encode(value);
                this.packStringHeader(encoded.remaining());
                this.out.writeBytes(encoded);
            }
        }

        public void packUTF8(byte[] bytes, int offset, int length) throws IOException {
            if (bytes == null) {
                this.packNull();
            } else {
                this.packStringHeader(length);
                this.out.writeBytes(bytes, offset, length);
            }
        }

        protected void packBytesHeader(int size) throws IOException {
            if (size <= 127) {
                this.out.writeShort((short)(0xFFFFCC00 | size));
            } else if (size <= Short.MAX_VALUE) {
                this.out.writeByte((byte)-51).writeShort((short)size);
            } else {
                this.out.writeByte((byte)-50).writeInt(size);
            }
        }

        private void packStringHeader(int size) throws IOException {
            if (size < 16) {
                this.out.writeByte((byte)(0xFFFFFF80 | size));
            } else if (size <= 127) {
                this.out.writeShort((short)(0xFFFFD000 | size));
            } else if (size <= Short.MAX_VALUE) {
                this.out.writeByte((byte)-47).writeShort((short)size);
            } else {
                this.out.writeByte((byte)-46).writeInt(size);
            }
        }

        public void packListHeader(int size) throws IOException {
            if (size < 16) {
                this.out.writeByte((byte)(0xFFFFFF90 | size));
            } else if (size <= 127) {
                this.out.writeShort((short)(0xFFFFD400 | size));
            } else if (size <= Short.MAX_VALUE) {
                this.out.writeByte((byte)-43).writeShort((short)size);
            } else {
                this.out.writeByte((byte)-42).writeInt(size);
            }
        }

        public void packListStreamHeader() throws IOException {
            this.out.writeByte((byte)-41);
        }

        public void packMapHeader(int size) throws IOException {
            if (size < 16) {
                this.out.writeByte((byte)(0xFFFFFFA0 | size));
            } else if (size <= 127) {
                this.out.writeShort((short)(0xFFFFD800 | size));
            } else if (size <= Short.MAX_VALUE) {
                this.out.writeByte((byte)-39).writeShort((short)size);
            } else {
                this.out.writeByte((byte)-38).writeInt(size);
            }
        }

        public void packMapStreamHeader() throws IOException {
            this.out.writeByte((byte)-37);
        }

        public void packStructHeader(int size, byte signature) throws IOException {
            if (size < 16) {
                this.out.writeShort((short)((byte)(0xFFFFFFB0 | size) << 8 | signature & 0xFF));
            } else if (size <= 127) {
                this.out.writeByte((byte)-36).writeByte((byte)size).writeByte(signature);
            } else if (size <= Short.MAX_VALUE) {
                this.out.writeByte((byte)-35).writeShort((short)size).writeByte(signature);
            } else {
                throw new Overflow("Structures cannot have more than 32767 fields");
            }
        }

        public void packEndOfStream() throws IOException {
            this.out.writeByte((byte)-33);
        }
    }
}

