/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.message.Messages;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.async.DelegatingBoltConnection;
import org.neo4j.driver.internal.async.TerminationAwareResponseHandler;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.util.Futures;

final class TerminationAwareBoltConnection
extends DelegatingBoltConnection {
    private final Logging logging;
    private final Logger log;
    private final TerminationAwareStateLockingExecutor executor;
    private final Consumer<Throwable> throwableConsumer;

    public TerminationAwareBoltConnection(Logging logging, DriverBoltConnection delegate, TerminationAwareStateLockingExecutor executor, Consumer<Throwable> throwableConsumer) {
        super(delegate);
        this.logging = Objects.requireNonNull(logging);
        this.log = logging.getLog(this.getClass());
        this.executor = Objects.requireNonNull(executor);
        this.throwableConsumer = Objects.requireNonNull(throwableConsumer);
    }

    public CompletionStage<Void> reset(Observation parentObservation) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TerminationAwareBoltConnection thisVal = this;
        this.executor.execute(ignored -> this.resetBolt(future, parentObservation)).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                this.throwableConsumer.accept((Throwable)throwable);
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    private CompletionStage<Void> resetBolt(final CompletableFuture<Void> future, Observation parentObservation) {
        return this.delegate.writeAndFlush(new DriverResponseHandler(){
            Throwable throwable = null;

            @Override
            public void onError(Throwable throwable) {
                TerminationAwareBoltConnection.this.log.error("Unexpected error occurred while resetting connection", throwable);
                TerminationAwareBoltConnection.this.throwableConsumer.accept(throwable);
                this.throwable = throwable;
            }

            @Override
            public void onComplete() {
                if (this.throwable != null) {
                    future.completeExceptionally(this.throwable);
                } else {
                    future.complete(null);
                }
            }
        }, List.of(Messages.reset()), parentObservation);
    }

    @Override
    public CompletionStage<Void> writeAndFlush(DriverResponseHandler handler, List<Message> messages, Observation parentObservation) {
        return this.executor.execute(causeOfTermination -> this.flushBolt((Throwable)causeOfTermination, handler, messages, parentObservation));
    }

    private CompletionStage<Void> flushBolt(Throwable causeOfTermination, DriverResponseHandler handler, List<Message> messages, Observation parentObservation) {
        if (causeOfTermination == null) {
            this.log.trace("This connection is active, will flush", new Object[0]);
            TerminationAwareResponseHandler terminationAwareResponseHandler = new TerminationAwareResponseHandler(this.logging, handler, this.executor, this.throwableConsumer);
            return this.delegate.writeAndFlush((DriverResponseHandler)terminationAwareResponseHandler, messages, parentObservation).handle((ignored, flushThrowable) -> {
                if ((flushThrowable = Futures.completionExceptionCause(flushThrowable)) != null) {
                    Throwable flushThrowableRef;
                    if (this.log.isTraceEnabled()) {
                        this.log.error("The flush has failed", (Throwable)flushThrowable);
                    }
                    if ((flushThrowable = this.executor.execute(arg_0 -> this.lambda$flushBolt$3(flushThrowableRef = flushThrowable, arg_0))) instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)flushThrowable;
                        throw runtimeException;
                    }
                    throw new CompletionException((Throwable)flushThrowable);
                }
                return ignored;
            });
        }
        return CompletableFuture.failedStage(causeOfTermination);
    }

    private /* synthetic */ Throwable lambda$flushBolt$3(Throwable flushThrowableRef, Throwable existingThrowable) {
        if (existingThrowable != null) {
            this.log.trace("The flush has failed, but there is an existing %s", existingThrowable);
            return existingThrowable;
        }
        this.throwableConsumer.accept(flushThrowableRef);
        return flushThrowableRef;
    }
}

