/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.neo4j.driver.internal.DelegatingTransactionContext;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.InternalResult;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.Futures;

public class InternalSession
extends AbstractQueryRunner
implements Session {
    private final NetworkSession session;
    private final DriverObservationProvider observationProvider;

    public InternalSession(NetworkSession session, DriverObservationProvider observationProvider) {
        this.session = session;
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public Result run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public Result run(String query, TransactionConfig config) {
        return this.run(query, Collections.emptyMap(), config);
    }

    @Override
    public Result run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    @Override
    public Result run(Query query, TransactionConfig config) {
        Observation runObservation = this.observationProvider.sessionRun(Session.class, query.text(), query.parameters());
        return ObservationUtil.observe(runObservation, () -> {
            ResultCursor cursor = Futures.blockingGet(this.session.runAsync(query, config, runObservation, Result.class), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in session"));
            DriverBoltConnection connection = Futures.getNow(this.session.connectionAsync());
            return new InternalResult(connection, cursor);
        });
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void close() {
        Observation closeObservation = this.observationProvider.sessionClose(Session.class);
        ObservationUtil.observe(closeObservation, () -> Futures.blockingGet(this.session.closeAsync(closeObservation), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the session")));
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    @Override
    public Transaction beginTransaction(TransactionConfig config) {
        return this.beginTransaction(config, null);
    }

    public Transaction beginTransaction(TransactionConfig config, String txType) {
        Observation beginTransaction = this.observationProvider.beginTransaction(Transaction.class);
        return ObservationUtil.observe(beginTransaction, () -> {
            UnmanagedTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(config, txType, new ApiTelemetryWork(TelemetryApi.UNMANAGED_TRANSACTION), beginTransaction), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
            return new InternalTransaction(tx, this.observationProvider, null);
        });
    }

    @Override
    public <T> T executeRead(TransactionCallback<T> callback, TransactionConfig config) {
        return this.execute(AccessMode.READ, callback, config, TelemetryApi.MANAGED_TRANSACTION, true);
    }

    @Override
    public <T> T executeWrite(TransactionCallback<T> callback, TransactionConfig config) {
        return this.execute(AccessMode.WRITE, callback, config, TelemetryApi.MANAGED_TRANSACTION, true);
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return this.session.lastBookmarks();
    }

    @Deprecated
    public void reset() {
        Futures.blockingGet(this.session.resetAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while resetting the session"));
    }

    <T> T execute(AccessMode accessMode, TransactionCallback<T> callback, TransactionConfig config, TelemetryApi telemetryApi, boolean flush) {
        return this.transaction(accessMode, callback, config, telemetryApi, flush);
    }

    private <T> T transaction(AccessMode mode, TransactionCallback<T> work, TransactionConfig config, TelemetryApi telemetryApi, boolean flush) {
        ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(telemetryApi);
        Observation executeObservation = this.observationProvider.sessionExecute(Session.class, mode);
        return (T)ObservationUtil.observe(executeObservation, () -> this.session.retryLogic().retry(() -> {
            try (InternalTransaction tx = this.beginTransaction(mode, config, apiTelemetryWork, flush, executeObservation);){
                Object result = work.execute(new DelegatingTransactionContext(tx));
                if (result instanceof Result) {
                    String message = String.format("%s is not a valid return value, it should be consumed before producing a return value", Result.class.getName());
                    throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                }
                if (tx.isOpen()) {
                    tx.commit();
                }
                Object t = result;
                return t;
            }
        }));
    }

    private InternalTransaction beginTransaction(AccessMode mode, TransactionConfig config, ApiTelemetryWork apiTelemetryWork, boolean flush, Observation parentObservation) {
        UnmanagedTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(mode, config, null, apiTelemetryWork, flush, parentObservation), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
        return new InternalTransaction(tx, this.observationProvider, parentObservation);
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        DriverBoltConnection connection = null;
        try {
            connection = Futures.getNow(this.session.connectionAsync());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (connection != null) {
            connection.forceClose(reason);
        }
    }
}

