/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionParameters;
import org.neo4j.bolt.connection.BoltConnectionSource;
import org.neo4j.bolt.connection.RoutedBoltConnectionParameters;
import org.neo4j.driver.internal.adaptedbolt.AdaptingDriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnectionSource;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.adaptedbolt.RoutedErrorMapper;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.value.BoltValueFactory;

public class AdaptingDriverBoltConnectionSource
implements DriverBoltConnectionSource {
    private final BoltConnectionSource<RoutedBoltConnectionParameters> delegate;
    private final ErrorMapper errorMapper;
    private final BoltValueFactory boltValueFactory;
    private final boolean routed;
    private final DriverObservationProvider observationProvider;

    public AdaptingDriverBoltConnectionSource(BoltConnectionSource<RoutedBoltConnectionParameters> delegate, ErrorMapper errorMapper, BoltValueFactory boltValueFactory, boolean routed, DriverObservationProvider observationProvider) {
        this.delegate = Objects.requireNonNull(delegate);
        this.errorMapper = Objects.requireNonNull(errorMapper);
        this.boltValueFactory = Objects.requireNonNull(boltValueFactory);
        this.routed = routed;
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public CompletionStage<DriverBoltConnection> getConnection(RoutedBoltConnectionParameters parameters, Observation parentObservation) {
        return ObservationUtil.scoped(this.observationProvider, parentObservation, () -> this.delegate.getConnection((BoltConnectionParameters)parameters)).exceptionally(this.errorMapper::mapAndThrow).thenApply(boltConnection -> new AdaptingDriverBoltConnection((BoltConnection)boltConnection, this.routed || boltConnection.serverSideRoutingEnabled() ? new RoutedErrorMapper(boltConnection.serverAddress(), parameters.accessMode()) : this.errorMapper, this.boltValueFactory, this.observationProvider));
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.delegate.verifyConnectivity().exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb() {
        return this.delegate.supportsMultiDb().exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.delegate.supportsSessionAuth().exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.delegate.close().exceptionally(this.errorMapper::mapAndThrow);
    }
}

