/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.api;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.api.SecurityPlanImpl;
import org.neo4j.driver.internal.bolt.api.ssl.RevocationCheckingStrategy;
import org.neo4j.driver.internal.bolt.api.ssl.SSLContexts;
import org.neo4j.driver.internal.bolt.api.ssl.TrustManagerFactories;

public final class SecurityPlans {
    private static final SecurityPlan UNENCRYPTED = new SecurityPlanImpl(false, false, null, false);

    public static SecurityPlan encrypted(boolean requiresClientAuth, SSLContext sslContext, boolean requiresHostnameVerification) {
        return new SecurityPlanImpl(true, requiresClientAuth, sslContext, requiresHostnameVerification);
    }

    public static SecurityPlan encryptedForAnyCertificate() throws GeneralSecurityException {
        SSLContext sslContext = SSLContexts.forAnyCertificate(new KeyManager[0]);
        return SecurityPlans.encrypted(false, sslContext, false);
    }

    public static SecurityPlan encryptedForSystemCASignedCertificates() throws GeneralSecurityException, IOException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactories.forSystemCertificates(RevocationCheckingStrategy.NO_CHECKS);
        SSLContext sslContext = SSLContexts.forTrustManagers(new KeyManager[0], trustManagerFactory.getTrustManagers());
        return SecurityPlans.encrypted(false, sslContext, true);
    }

    public static SecurityPlan unencrypted() {
        return UNENCRYPTED;
    }

    private SecurityPlans() {
    }
}

