/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection;

import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltConnectionParametersBuilderImpl;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.RoutedBoltConnectionParameters;
import org.neo4j.bolt.connection.RoutedBoltConnectionParametersImpl;

final class RoutingParametersBuilderImpl
extends BoltConnectionParametersBuilderImpl
implements RoutedBoltConnectionParameters.Builder {
    private AccessMode accessMode = AccessMode.WRITE;
    private DatabaseName databaseName;
    private Consumer<DatabaseName> databaseNameConsumer = ignored -> {};
    private String homeDatabase;
    private Set<String> bookmarks = Set.of();
    private String impersonatedUser;

    RoutingParametersBuilderImpl() {
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withAuthToken(AuthToken authToken) {
        super.withAuthToken(authToken);
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withMinVersion(BoltProtocolVersion minVersion) {
        super.withMinVersion(minVersion);
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withDatabaseName(DatabaseName databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withDatabaseNameListener(Consumer<DatabaseName> databaseNameListener) {
        this.databaseNameConsumer = databaseNameListener;
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withHomeDatabaseHint(String homeDatabaseHint) {
        this.homeDatabase = homeDatabaseHint;
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withBookmarks(Set<String> bookmarks) {
        this.bookmarks = bookmarks;
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters.Builder withImpersonatedUser(String impersonatedUser) {
        this.impersonatedUser = impersonatedUser;
        return this;
    }

    @Override
    public RoutedBoltConnectionParameters build() {
        return new RoutedBoltConnectionParametersImpl(this.authToken, this.minVersion, this.accessMode, this.databaseName, this.databaseNameConsumer, this.homeDatabase, this.bookmarks, this.impersonatedUser);
    }
}

