/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.bolt.connection.exception.BoltClientException;
import org.neo4j.bolt.connection.exception.BoltConnectionReadTimeoutException;
import org.neo4j.bolt.connection.exception.BoltException;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.exception.BoltProtocolException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.bolt.connection.exception.BoltUnsupportedFeatureException;
import org.neo4j.bolt.connection.message.BeginMessage;
import org.neo4j.bolt.connection.message.CommitMessage;
import org.neo4j.bolt.connection.message.DiscardMessage;
import org.neo4j.bolt.connection.message.LogoffMessage;
import org.neo4j.bolt.connection.message.LogonMessage;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.message.PullMessage;
import org.neo4j.bolt.connection.message.ResetMessage;
import org.neo4j.bolt.connection.message.RollbackMessage;
import org.neo4j.bolt.connection.message.RouteMessage;
import org.neo4j.bolt.connection.message.RunMessage;
import org.neo4j.bolt.connection.message.TelemetryMessage;
import org.neo4j.bolt.connection.netty.impl.MessageIgnoredException;
import org.neo4j.bolt.connection.netty.impl.RoutingContext;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltProtocol;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.PullMessageHandler;
import org.neo4j.bolt.connection.netty.impl.spi.Connection;
import org.neo4j.bolt.connection.netty.impl.util.FutureUtil;
import org.neo4j.bolt.connection.observation.BoltExchangeObservation;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.bolt.connection.observation.Observation;
import org.neo4j.bolt.connection.observation.ObservationProvider;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.DiscardSummary;
import org.neo4j.bolt.connection.summary.LogoffSummary;
import org.neo4j.bolt.connection.summary.LogonSummary;
import org.neo4j.bolt.connection.summary.PullSummary;
import org.neo4j.bolt.connection.summary.ResetSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public final class BoltConnectionImpl
implements BoltConnection {
    private final LoggingProvider logging;
    private final System.Logger log;
    private final BoltProtocol protocol;
    private final Connection connection;
    private final EventLoop eventLoop;
    private final String serverAgent;
    private final BoltServerAddress serverAddress;
    private final BoltProtocolVersion protocolVersion;
    private final boolean telemetrySupported;
    private final boolean serverSideRouting;
    private final AtomicReference<BoltConnectionState> stateRef = new AtomicReference<BoltConnectionState>(BoltConnectionState.OPEN);
    private final AtomicReference<CompletableFuture<AuthInfo>> authDataRef;
    private final Map<String, Value> routingContext;
    private final Queue<Message> messages;
    private final Clock clock;
    private final ValueFactory valueFactory;
    private final ObservationProvider observationProvider;

    public BoltConnectionImpl(BoltProtocol protocol, Connection connection, EventLoop eventLoop, AuthToken authToken, CompletableFuture<Long> latestAuthMillisFuture, RoutingContext routingContext, Clock clock, LoggingProvider logging, ValueFactory valueFactory, ObservationProvider observationProvider) {
        this.protocol = Objects.requireNonNull(protocol);
        this.connection = Objects.requireNonNull(connection);
        this.eventLoop = Objects.requireNonNull(eventLoop);
        this.serverAgent = Objects.requireNonNull(connection.serverAgent());
        this.serverAddress = Objects.requireNonNull(connection.serverAddress());
        this.protocolVersion = Objects.requireNonNull(connection.protocol().version());
        this.telemetrySupported = connection.isTelemetryEnabled();
        this.serverSideRouting = routingContext.isServerRoutingEnabled() && connection.isSsrEnabled();
        this.authDataRef = new AtomicReference<CompletableFuture<AuthInfoImpl>>(CompletableFuture.completedFuture(new AuthInfoImpl(authToken, latestAuthMillisFuture.join())));
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.routingContext = routingContext.toMap().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> valueFactory.value((String)entry.getValue()), (a, b) -> b));
        this.messages = new ArrayDeque<Message>();
        this.clock = Objects.requireNonNull(clock);
        this.logging = Objects.requireNonNull(logging);
        this.log = this.logging.getLog(this.getClass());
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    public CompletionStage<Void> writeAndFlush(ResponseHandler handler, List<Message> messages, ImmutableObservation parentObservation) {
        CompletableFuture flushFuture = new CompletableFuture();
        return this.executeInEventLoop(() -> {
            this.messages.addAll(messages);
            this.flush(handler, flushFuture, parentObservation);
        }).thenCompose(ignored -> flushFuture).handle((ignored, throwable) -> {
            if (throwable != null) {
                throwable = FutureUtil.completionExceptionCause(throwable);
                this.updateState((Throwable)throwable);
                if (throwable instanceof BoltException) {
                    BoltException boltException = (BoltException)throwable;
                    throw boltException;
                }
                Throwable patt0$temp = throwable.getCause();
                if (patt0$temp instanceof BoltException) {
                    BoltException boltException = (BoltException)patt0$temp;
                    throw boltException;
                }
                throw new BoltClientException("Failed to write messages", throwable);
            }
            return null;
        });
    }

    public CompletionStage<Void> write(List<Message> messages) {
        return this.executeInEventLoop(() -> this.messages.addAll(messages)).thenApply(ignored -> null);
    }

    private void flush(ResponseHandler handler, CompletableFuture<Void> flushFuture, ImmutableObservation parentObservation) {
        BoltExchangeObservation observation;
        CompletionStage<Object> flushStage;
        if (this.connection.isOpen()) {
            flushStage = CompletableFuture.completedStage(null);
            observation = this.observationProvider.boltExchange(parentObservation, this.serverAddress.connectionHost(), this.serverAddress.port(), this.protocolVersion, (key, value) -> {});
            ResponseHandleImpl responseHandler = new ResponseHandleImpl(handler, this.messages.size(), (Observation)observation);
            for (Message message : this.messages) {
                flushStage = flushStage.thenCompose(ignored -> this.writeMessage((ResponseHandler)responseHandler, message, observation));
            }
        } else {
            throw new BoltServiceUnavailableException("Connection is closed");
        }
        this.messages.clear();
        flushStage.thenCompose(ignored -> this.connection.flush()).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                if ((throwable = FutureUtil.completionExceptionCause(throwable)) instanceof CodecException && throwable.getCause() instanceof IOException) {
                    BoltServiceUnavailableException serviceError = new BoltServiceUnavailableException("Connection to the database failed", throwable.getCause());
                    this.forceClose("Connection has been closed due to encoding error").whenComplete((ignored1, ignored2) -> flushFuture.completeExceptionally((Throwable)serviceError));
                } else {
                    flushFuture.completeExceptionally((Throwable)throwable);
                }
                observation.error(throwable);
                observation.stop();
            } else {
                flushFuture.complete(null);
                this.log.log(System.Logger.Level.DEBUG, "flushed");
            }
        });
    }

    private CompletionStage<Void> writeMessage(ResponseHandler handler, Message message, BoltExchangeObservation observation) {
        CompletionStage<Void> result;
        if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            result = this.writeMessage(handler, routeMessage, observation);
        } else if (message instanceof BeginMessage) {
            BeginMessage beginMessage = (BeginMessage)message;
            result = this.writeMessage(handler, beginMessage, observation);
        } else if (message instanceof RunMessage) {
            RunMessage runMessage = (RunMessage)message;
            result = this.writeMessage(handler, runMessage, observation);
        } else if (message instanceof PullMessage) {
            PullMessage pullMessage = (PullMessage)message;
            result = this.writeMessage(handler, pullMessage, observation);
        } else if (message instanceof DiscardMessage) {
            DiscardMessage discardMessage = (DiscardMessage)message;
            result = this.writeMessage(handler, discardMessage, observation);
        } else if (message instanceof CommitMessage) {
            CommitMessage commitMessage = (CommitMessage)message;
            result = this.writeMessage(handler, commitMessage, observation);
        } else if (message instanceof RollbackMessage) {
            RollbackMessage rollbackMessage = (RollbackMessage)message;
            result = this.writeMessage(handler, rollbackMessage, observation);
        } else if (message instanceof ResetMessage) {
            ResetMessage resetMessage = (ResetMessage)message;
            result = this.writeMessage(handler, resetMessage, observation);
        } else if (message instanceof LogoffMessage) {
            LogoffMessage logoffMessage = (LogoffMessage)message;
            result = this.writeMessage(handler, logoffMessage, observation);
        } else if (message instanceof LogonMessage) {
            LogonMessage logonMessage = (LogonMessage)message;
            result = this.writeMessage(handler, logonMessage, observation);
        } else if (message instanceof TelemetryMessage) {
            TelemetryMessage telemetryMessage = (TelemetryMessage)message;
            result = this.writeMessage(handler, telemetryMessage, observation);
        } else {
            result = CompletableFuture.failedStage((Throwable)new BoltException("Unknown message type: " + String.valueOf(message.getClass())));
        }
        return result;
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, RouteMessage routeMessage, BoltExchangeObservation observation) {
        return this.protocol.route(this.connection, this.routingContext, routeMessage.bookmarks(), routeMessage.databaseName().orElse(null), routeMessage.impersonatedUser().orElse(null), new MessageHandler<RouteSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(RouteSummary summary) {
                handler.onRouteSummary(summary);
            }
        }, this.clock, this.logging, this.valueFactory, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, BeginMessage beginMessage, BoltExchangeObservation observation) {
        DatabaseName databaseName = DatabaseName.database((String)beginMessage.databaseName().orElse(null));
        AccessMode accessMode = beginMessage.accessMode();
        String string = beginMessage.impersonatedUser().orElse(null);
        Set set = beginMessage.bookmarks();
        Duration duration = beginMessage.txTimeout().orElse(null);
        Map map = beginMessage.txMetadata();
        return this.protocol.beginTransaction(this.connection, databaseName, accessMode, string, set, duration, map, switch (beginMessage.transactionType()) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionType.DEFAULT -> null;
            case TransactionType.UNCONSTRAINED -> "IMPLICIT";
        }, beginMessage.notificationConfig(), new MessageHandler<BeginSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(BeginSummary summary) {
                handler.onBeginSummary(summary);
            }
        }, this.logging, this.valueFactory, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, RunMessage runMessage, BoltExchangeObservation observation) {
        if (runMessage.extra().isEmpty()) {
            return this.protocol.run(this.connection, runMessage.query(), runMessage.parameters(), new MessageHandler<RunSummary>(){

                @Override
                public void onError(Throwable throwable) {
                    BoltConnectionImpl.this.updateState(throwable);
                    handler.onError(throwable);
                }

                @Override
                public void onSummary(RunSummary summary) {
                    handler.onRunSummary(summary);
                }
            }, observation);
        }
        RunMessage.Extra extra = (RunMessage.Extra)runMessage.extra().get();
        return this.protocol.runAuto(this.connection, DatabaseName.database((String)extra.databaseName().orElse(null)), extra.accessMode(), extra.impersonatedUser().orElse(null), runMessage.query(), runMessage.parameters(), extra.bookmarks(), extra.txTimeout().orElse(null), extra.txMetadata(), extra.notificationConfig(), new MessageHandler<RunSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(RunSummary summary) {
                handler.onRunSummary(summary);
            }
        }, this.logging, this.valueFactory, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, PullMessage pullMessage, BoltExchangeObservation observation) {
        return this.protocol.pull(this.connection, pullMessage.qid(), pullMessage.request(), new PullMessageHandler(){

            @Override
            public void onRecord(List<Value> fields) {
                handler.onRecord(fields);
            }

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(PullSummary success) {
                handler.onPullSummary(success);
            }
        }, this.valueFactory, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, DiscardMessage discardMessage, BoltExchangeObservation observation) {
        return this.protocol.discard(this.connection, discardMessage.qid(), discardMessage.number(), new MessageHandler<DiscardSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(DiscardSummary summary) {
                handler.onDiscardSummary(summary);
            }
        }, this.valueFactory, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, CommitMessage commitMessage, BoltExchangeObservation observation) {
        return this.protocol.commitTransaction(this.connection, new MessageHandler<String>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(String bookmark) {
                handler.onCommitSummary(() -> Optional.ofNullable(bookmark));
            }
        }, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, RollbackMessage rollbackMessage, BoltExchangeObservation observation) {
        return this.protocol.rollbackTransaction(this.connection, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                handler.onRollbackSummary(RollbackSummaryImpl.INSTANCE);
            }
        }, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, ResetMessage resetMessage, BoltExchangeObservation observation) {
        return this.protocol.reset(this.connection, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                BoltConnectionImpl.this.stateRef.set(BoltConnectionState.OPEN);
                handler.onResetSummary(null);
            }
        }, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, LogoffMessage logoffMessage, BoltExchangeObservation observation) {
        return this.protocol.logoff(this.connection, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                BoltConnectionImpl.this.authDataRef.set(new CompletableFuture());
                handler.onLogoffSummary(null);
            }
        }, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, final LogonMessage logonMessage, BoltExchangeObservation observation) {
        return this.protocol.logon(this.connection, logonMessage.authToken().asMap(), this.clock, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                BoltConnectionImpl.this.authDataRef.get().complete(new AuthInfoImpl(logonMessage.authToken(), BoltConnectionImpl.this.clock.millis()));
                handler.onLogonSummary(null);
            }
        }, this.valueFactory, observation);
    }

    private CompletionStage<Void> writeMessage(final ResponseHandler handler, TelemetryMessage telemetryMessage, BoltExchangeObservation observation) {
        if (!this.telemetrySupported()) {
            return CompletableFuture.failedStage((Throwable)new BoltUnsupportedFeatureException("telemetry not supported"));
        }
        return this.protocol.telemetry(this.connection, telemetryMessage.api().getValue(), new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                handler.onTelemetrySummary(TelemetrySummaryImpl.INSTANCE);
            }
        }, observation);
    }

    public CompletionStage<Void> forceClose(String reason) {
        if (this.stateRef.getAndSet(BoltConnectionState.CLOSED) != BoltConnectionState.CLOSED) {
            try {
                return this.connection.forceClose(reason).exceptionally(ignored -> null);
            }
            catch (Throwable throwable) {
                return CompletableFuture.completedStage(null);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Void> close() {
        CompletionStage<Object> close;
        try {
            close = switch (this.stateRef.getAndSet(BoltConnectionState.CLOSED)) {
                default -> throw new IncompatibleClassChangeError();
                case BoltConnectionState.OPEN -> this.connection.close();
                case BoltConnectionState.ERROR -> this.connection.forceClose("Closing connection after error");
                case BoltConnectionState.FAILURE -> this.connection.forceClose("Closing connection after failure");
                case BoltConnectionState.CLOSED -> CompletableFuture.completedStage(null);
            };
        }
        catch (Throwable throwable) {
            close = CompletableFuture.completedStage(null);
        }
        return close.exceptionally(ignored -> null);
    }

    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.executeInEventLoop(() -> this.connection.setReadTimeout(duration));
    }

    public BoltConnectionState state() {
        BoltConnectionState state = this.stateRef.get();
        if (state == BoltConnectionState.OPEN && !this.connection.isOpen()) {
            state = BoltConnectionState.CLOSED;
        }
        return state;
    }

    public CompletionStage<AuthInfo> authInfo() {
        return this.authDataRef.get();
    }

    public String serverAgent() {
        return this.serverAgent;
    }

    public BoltServerAddress serverAddress() {
        return this.serverAddress;
    }

    public BoltProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    public boolean telemetrySupported() {
        return this.telemetrySupported;
    }

    public boolean serverSideRoutingEnabled() {
        return this.serverSideRouting;
    }

    public Optional<Duration> defaultReadTimeout() {
        return this.connection.defaultReadTimeoutMillis();
    }

    private <T> CompletionStage<T> executeInEventLoop(Runnable runnable) {
        return this.executeInEventLoop(() -> {
            runnable.run();
            return null;
        });
    }

    private <T> CompletionStage<T> executeInEventLoop(Supplier<T> supplier) {
        CompletableFuture executeFuture = new CompletableFuture();
        Runnable stageCompletingRunnable = () -> {
            try {
                executeFuture.complete(supplier.get());
            }
            catch (Throwable throwable) {
                executeFuture.completeExceptionally(throwable);
            }
        };
        if (this.eventLoop.inEventLoop()) {
            stageCompletingRunnable.run();
        } else {
            try {
                this.eventLoop.execute(stageCompletingRunnable);
            }
            catch (Throwable throwable) {
                executeFuture.completeExceptionally(throwable);
            }
        }
        return executeFuture;
    }

    private void updateState(Throwable throwable) {
        if (throwable instanceof BoltServiceUnavailableException) {
            if (throwable instanceof BoltConnectionReadTimeoutException) {
                this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.ERROR);
            } else {
                this.stateRef.set(BoltConnectionState.CLOSED);
            }
        } else if (throwable instanceof BoltFailureException) {
            BoltFailureException boltFailureException = (BoltFailureException)throwable;
            if ("Neo.ClientError.Security.AuthorizationExpired".equals(boltFailureException.code())) {
                this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.ERROR);
            } else {
                this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.FAILURE);
            }
        } else if (throwable instanceof MessageIgnoredException) {
            this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.FAILURE);
        } else if (throwable instanceof EncoderException) {
            this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.ERROR);
        } else {
            this.stateRef.updateAndGet(state -> switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case BoltConnectionState.OPEN, BoltConnectionState.ERROR, BoltConnectionState.FAILURE -> BoltConnectionState.ERROR;
                case BoltConnectionState.CLOSED -> BoltConnectionState.CLOSED;
            });
        }
    }

    private record AuthInfoImpl(AuthToken authToken, long authAckMillis) implements AuthInfo
    {
    }

    private static class ResponseHandleImpl
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private final CompletableFuture<Void> summariesFuture = new CompletableFuture();
        private int expectedSummaries;
        private final Observation observation;

        private ResponseHandleImpl(ResponseHandler delegate, int expectedSummaries, Observation observation) {
            this.delegate = Objects.requireNonNull(delegate);
            this.expectedSummaries = expectedSummaries;
            this.observation = Objects.requireNonNull(observation);
            this.summariesFuture.whenComplete((ignored1, ignored2) -> this.onComplete());
        }

        public void onError(Throwable throwable) {
            if (!(throwable instanceof MessageIgnoredException)) {
                if (!this.summariesFuture.isDone()) {
                    this.observation.error(throwable);
                    this.runIgnoringError(() -> this.delegate.onError(throwable));
                    if (!(throwable instanceof BoltException) || throwable instanceof BoltServiceUnavailableException || throwable instanceof BoltProtocolException) {
                        this.expectedSummaries = 1;
                    }
                    this.handleSummary();
                }
            } else {
                this.onIgnored();
            }
        }

        public void onBeginSummary(BeginSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onBeginSummary(summary));
                this.handleSummary();
            }
        }

        public void onRunSummary(RunSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRunSummary(summary));
                this.handleSummary();
            }
        }

        public void onRecord(List<Value> fields) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRecord(fields));
            }
        }

        public void onPullSummary(PullSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onPullSummary(summary));
                this.handleSummary();
            }
        }

        public void onDiscardSummary(DiscardSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onDiscardSummary(summary));
                this.handleSummary();
            }
        }

        public void onCommitSummary(CommitSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onCommitSummary(summary));
                this.handleSummary();
            }
        }

        public void onRollbackSummary(RollbackSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRollbackSummary(summary));
                this.handleSummary();
            }
        }

        public void onResetSummary(ResetSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onResetSummary(summary));
                this.handleSummary();
            }
        }

        public void onRouteSummary(RouteSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRouteSummary(summary));
                this.handleSummary();
            }
        }

        public void onLogoffSummary(LogoffSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onLogoffSummary(summary));
                this.handleSummary();
            }
        }

        public void onLogonSummary(LogonSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onLogonSummary(summary));
                this.handleSummary();
            }
        }

        public void onTelemetrySummary(TelemetrySummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onTelemetrySummary(summary));
                this.handleSummary();
            }
        }

        public void onIgnored() {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> ((ResponseHandler)this.delegate).onIgnored());
                this.handleSummary();
            }
        }

        public void onComplete() {
            this.observation.stop();
            this.runIgnoringError(() -> ((ResponseHandler)this.delegate).onComplete());
        }

        private void handleSummary() {
            --this.expectedSummaries;
            if (this.expectedSummaries == 0) {
                this.summariesFuture.complete(null);
            }
        }

        private void runIgnoringError(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class RollbackSummaryImpl
    implements RollbackSummary {
        private static final RollbackSummary INSTANCE = new RollbackSummaryImpl();

        private RollbackSummaryImpl() {
        }
    }

    private static class TelemetrySummaryImpl
    implements TelemetrySummary {
        private static final TelemetrySummary INSTANCE = new TelemetrySummaryImpl();

        private TelemetrySummaryImpl() {
        }
    }
}

