/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.NeoWebServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.bind.ComponentsBinder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.http.HttpMemoryPool;
import org.neo4j.server.http.HttpTransactionMemoryPool;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.repr.RepresentationBasedMessageBodyWriter;
import org.neo4j.server.web.RotatingRequestLog;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public abstract class AbstractNeoWebServer
extends LifecycleAdapter
implements NeoWebServer {
    private static final long MINIMUM_TIMEOUT = 1000L;
    private static final long ROUNDING_SECOND = 1000L;
    static final String NEO4J_IS_STARTING_MESSAGE = "======== Neo4j " + Version.getNeo4jVersion() + " ========";
    protected final InternalLogProvider userLogProvider;
    private final InternalLog log;
    private final DbmsInfo dbmsInfo;
    private final MemoryPool requestMemoryPool;
    private final MemoryPool transactionMemoryPool;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final List<Pattern> authWhitelist;
    private final DatabaseManagementService databaseManagementService;
    private final Dependencies globalDependencies;
    private final Config config;
    private final TransactionManager transactionManager;
    private final LifeSupport life = new LifeSupport();
    private final boolean httpEnabled;
    private final boolean httpsEnabled;
    private SocketAddress httpListenAddress;
    private SocketAddress httpsListenAddress;
    private SocketAddress httpAdvertisedAddress;
    private SocketAddress httpsAdvertisedAddress;
    protected WebServer webServer;
    protected Supplier<AuthManager> authManagerSupplier;
    protected ArrayByteBufferPool byteBufferPool;
    private final Supplier<SslPolicyLoader> sslPolicyFactorySupplier;
    private final HttpTransactionManager httpTransactionManager;
    private final CompositeDatabaseAvailabilityGuard globalAvailabilityGuard;
    protected final SystemNanoClock clock;
    protected ConnectorPortRegister connectorPortRegister;
    private RotatingRequestLog requestLog;

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract WebServer createWebServer();

    public AbstractNeoWebServer(DatabaseManagementService databaseManagementService, Dependencies globalDependencies, Config config, InternalLogProvider userLogProvider, DbmsInfo dbmsInfo, MemoryPools memoryPools, TransactionManager transactionManager, SystemNanoClock clock) {
        this.databaseManagementService = databaseManagementService;
        this.globalDependencies = globalDependencies;
        this.transactionManager = transactionManager;
        this.config = config;
        this.userLogProvider = userLogProvider;
        this.log = userLogProvider.getLog(this.getClass());
        this.dbmsInfo = dbmsInfo;
        this.clock = clock;
        this.log.info(NEO4J_IS_STARTING_MESSAGE);
        this.byteBufferPool = new ArrayByteBufferPool();
        this.requestMemoryPool = new HttpMemoryPool(memoryPools, this.byteBufferPool);
        this.life.add((Lifecycle)new MemoryPoolLifecycleAdapter(this.requestMemoryPool));
        this.transactionMemoryPool = new HttpTransactionMemoryPool(memoryPools);
        this.life.add((Lifecycle)new MemoryPoolLifecycleAdapter(this.transactionMemoryPool));
        AbstractNeoWebServer.verifyConnectorsConfiguration(config);
        this.httpEnabled = (Boolean)config.get(HttpConnector.enabled);
        if (this.httpEnabled) {
            this.httpListenAddress = (SocketAddress)config.get(HttpConnector.listen_address);
            this.httpAdvertisedAddress = (SocketAddress)config.get(HttpConnector.advertised_address);
        }
        this.httpsEnabled = (Boolean)config.get(HttpsConnector.enabled);
        if (this.httpsEnabled) {
            this.httpsListenAddress = (SocketAddress)config.get(HttpsConnector.listen_address);
            this.httpsAdvertisedAddress = (SocketAddress)config.get(HttpsConnector.advertised_address);
        }
        this.authWhitelist = AbstractNeoWebServer.parseAuthWhitelist(config);
        this.authManagerSupplier = globalDependencies.provideDependency(AuthManager.class);
        this.sslPolicyFactorySupplier = globalDependencies.provideDependency(SslPolicyLoader.class);
        this.connectorPortRegister = (ConnectorPortRegister)globalDependencies.resolveDependency(ConnectorPortRegister.class);
        this.httpTransactionManager = this.createHttpTransactionManager();
        this.globalAvailabilityGuard = (CompositeDatabaseAvailabilityGuard)globalDependencies.resolveDependency(CompositeDatabaseAvailabilityGuard.class);
        this.life.add((Lifecycle)new ServerComponentsLifecycleAdapter());
    }

    protected Dependencies getGlobalDependencies() {
        return this.globalDependencies;
    }

    @Override
    public DbmsInfo getDbmsInfo() {
        return this.dbmsInfo;
    }

    public void init() {
        this.life.init();
    }

    public void start() throws ServerStartupException {
        try {
            this.life.start();
        }
        catch (Throwable t) {
            this.life.shutdown();
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            throw new ServerStartupException(String.format("Starting Neo4j failed: %s", rootCause.getMessage()), rootCause);
        }
    }

    private HttpTransactionManager createHttpTransactionManager() {
        JobScheduler jobScheduler = (JobScheduler)this.globalDependencies.resolveDependency(JobScheduler.class);
        Clock clock = Clocks.systemClock();
        Duration transactionTimeout = this.getTransactionTimeout();
        Boolean routingEnabled = (Boolean)this.config.get(GraphDatabaseSettings.routing_enabled);
        return new HttpTransactionManager(this.databaseManagementService, this.transactionMemoryPool, jobScheduler, clock, transactionTimeout, this.userLogProvider, this.transactionManager, this.authManagerSupplier.get(), routingEnabled);
    }

    private Duration getTransactionTimeout() {
        long timeout = ((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout)).toMillis();
        return Duration.ofMillis(Math.max(timeout, 2000L));
    }

    private void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules() {
        for (ServerModule module : this.serverModules) {
            module.start();
        }
    }

    private void stopModules() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            RuntimeException e = new RuntimeException();
            errors.forEach(e::addSuppressed);
            throw e;
        }
    }

    private void clearModules() {
        this.serverModules.clear();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    protected void configureWebServer() {
        SslPolicyLoader sslPolicyLoader;
        this.webServer.setHttpAddress(this.httpListenAddress);
        this.webServer.setHttpsAddress(this.httpsListenAddress);
        this.webServer.setMaxThreads((Integer)this.config.get(ServerSettings.webserver_max_threads));
        this.webServer.setWadlEnabled((Boolean)this.config.get(ServerSettings.wadl_enabled));
        this.webServer.setComponentsBinder(this.createComponentsBinder());
        if (this.httpsEnabled && (sslPolicyLoader = this.sslPolicyFactorySupplier.get()).hasPolicyForSource(SslPolicyScope.HTTPS)) {
            this.webServer.setSslPolicy(sslPolicyLoader.getPolicy(SslPolicyScope.HTTPS));
        }
    }

    protected void startWebServer() throws Exception {
        try {
            this.setUpHttpLogging();
            this.webServer.start();
            this.registerHttpAddressAfterStartup();
            this.registerHttpsAddressAfterStartup();
            String protocol = this.httpsListenAddress != null ? "HTTPS" : "HTTP";
            SocketAddress url = this.httpsListenAddress != null ? this.httpsListenAddress : this.httpListenAddress;
            this.log.info("%s enabled on %s.", new Object[]{protocol, url});
            this.log.info("Remote interface available at %s", new Object[]{this.getBaseUri()});
        }
        catch (Exception e) {
            SocketAddress address = this.httpListenAddress != null ? this.httpListenAddress : this.httpsListenAddress;
            this.log.error("Failed to start Neo4j on %s: %s", new Object[]{address, e.getMessage()});
            throw e;
        }
    }

    private void registerHttpAddressAfterStartup() {
        if (this.httpEnabled) {
            InetSocketAddress localHttpAddress = this.webServer.getLocalHttpAddress();
            this.connectorPortRegister.register(ConnectorType.HTTP, localHttpAddress);
            if (this.httpAdvertisedAddress.getPort() == 0) {
                this.httpAdvertisedAddress = new SocketAddress(localHttpAddress.getHostString(), localHttpAddress.getPort());
            }
        }
    }

    private void registerHttpsAddressAfterStartup() {
        if (this.httpsEnabled) {
            InetSocketAddress localHttpsAddress = this.webServer.getLocalHttpsAddress();
            this.connectorPortRegister.register(ConnectorType.HTTPS, localHttpsAddress);
            if (this.httpsAdvertisedAddress.getPort() == 0) {
                this.httpsAdvertisedAddress = new SocketAddress(localHttpsAddress.getHostString(), localHttpsAddress.getPort());
            }
        }
    }

    private void setUpHttpLogging() {
        if (!((Boolean)this.getConfig().get(ServerSettings.http_logging_enabled)).booleanValue()) {
            return;
        }
        LogService logService = (LogService)this.globalDependencies.resolveDependency(LogService.class);
        this.requestLog = new RotatingRequestLog(logService.getInternalLogProvider());
        this.webServer.setRequestLog(this.requestLog);
    }

    protected List<Pattern> getUriWhitelist() {
        return this.authWhitelist;
    }

    public void stop() {
        this.shutdownGlobalAvailabilityGuard();
        this.life.stop();
    }

    private void shutdownGlobalAvailabilityGuard() {
        try {
            if (this.globalAvailabilityGuard != null) {
                this.globalAvailabilityGuard.stop();
            }
        }
        catch (Throwable t) {
            this.log.error("Failed to set the global availability guard to shutdown in the process of stopping the Neo4j server", t);
        }
    }

    private void stopWebServer() throws Exception {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.httpTransactionManager.getTransactionRegistry();
    }

    @Override
    public URI getBaseUri() {
        return this.httpAdvertisedAddress != null ? SimpleUriBuilder.buildURI(this.httpAdvertisedAddress, false) : SimpleUriBuilder.buildURI(this.httpsAdvertisedAddress, true);
    }

    @Override
    public Optional<URI> httpsUri() {
        return Optional.ofNullable(this.httpsAdvertisedAddress).map(address -> SimpleUriBuilder.buildURI(address, true));
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    private ComponentsBinder createComponentsBinder() {
        ComponentsBinder binder = new ComponentsBinder();
        DatabaseStateService databaseStateService = (DatabaseStateService)this.getGlobalDependencies().resolveDependency(DatabaseStateService.class);
        DefaultDatabaseResolver databaseResolver = (DefaultDatabaseResolver)this.getGlobalDependencies().resolveDependency(DefaultDatabaseResolver.class);
        binder.addSingletonBinding(this.databaseManagementService, DatabaseManagementService.class);
        binder.addSingletonBinding(databaseStateService, DatabaseStateService.class);
        binder.addSingletonBinding(this, NeoWebServer.class);
        binder.addSingletonBinding(this.getConfig(), Config.class);
        binder.addSingletonBinding(this.transactionMemoryPool, MemoryPool.class);
        binder.addSingletonBinding(this.getWebServer(), WebServer.class);
        binder.bind(RepresentationBasedMessageBodyWriter.class).to(MessageBodyWriter.class);
        binder.addSingletonBinding(this.httpTransactionManager, HttpTransactionManager.class);
        binder.addSingletonBinding(databaseResolver, DefaultDatabaseResolver.class);
        binder.addLazyBinding(this.authManagerSupplier, AuthManager.class);
        binder.addSingletonBinding(this.userLogProvider, InternalLogProvider.class);
        binder.addSingletonBinding(this.userLogProvider.getLog(NeoWebServer.class), InternalLog.class);
        return binder;
    }

    private static void verifyConnectorsConfiguration(Config config) {
        boolean httpAndHttpsDisabled;
        boolean bl = httpAndHttpsDisabled = (Boolean)config.get(HttpConnector.enabled) == false && (Boolean)config.get(HttpsConnector.enabled) == false;
        if (httpAndHttpsDisabled) {
            throw new IllegalArgumentException("Either HTTP or HTTPS connector must be configured to run the server");
        }
    }

    private static List<Pattern> parseAuthWhitelist(Config config) {
        return ((List)config.get(ServerSettings.http_auth_allowlist)).stream().map(Pattern::compile).toList();
    }

    private static class MemoryPoolLifecycleAdapter
    extends LifecycleAdapter {
        private final MemoryPool memoryPool;

        private MemoryPoolLifecycleAdapter(MemoryPool memoryPool) {
            this.memoryPool = memoryPool;
        }

        public void shutdown() throws Exception {
            this.memoryPool.free();
        }
    }

    private class ServerComponentsLifecycleAdapter
    extends LifecycleAdapter {
        private ServerComponentsLifecycleAdapter() {
        }

        public void init() {
            AbstractNeoWebServer.this.webServer = AbstractNeoWebServer.this.createWebServer();
            for (ServerModule moduleClass : AbstractNeoWebServer.this.createServerModules()) {
                AbstractNeoWebServer.this.registerModule(moduleClass);
            }
        }

        public void start() throws Exception {
            LogService logService = (LogService)AbstractNeoWebServer.this.globalDependencies.resolveDependency(LogService.class);
            InternalLog serverLog = logService.getInternalLog(ServerComponentsLifecycleAdapter.class);
            serverLog.info("Starting web server");
            AbstractNeoWebServer.this.configureWebServer();
            AbstractNeoWebServer.this.startModules();
            AbstractNeoWebServer.this.startWebServer();
            serverLog.info("Web server started.");
        }

        public void stop() throws Exception {
            AbstractNeoWebServer.this.stopWebServer();
            AbstractNeoWebServer.this.stopModules();
            AbstractNeoWebServer.this.clearModules();
        }
    }
}

