/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationBasedMessageBodyWriter;
import org.neo4j.server.rest.repr.RepresentationFormat;

class RestRepresentationWriter
implements ResultDataContentWriter {
    private final URI baseUri;

    RestRepresentationWriter(URI baseUri) {
        this.baseUri = baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonGenerator out, RecordEvent recordEvent) throws IOException {
        WriteThroughJsonFormat format = new WriteThroughJsonFormat(out);
        out.writeArrayFieldStart("rest");
        try {
            for (String key : recordEvent.getColumns()) {
                this.write(out, format, recordEvent.getValue(key));
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(JsonGenerator out, WriteThroughJsonFormat format, Object value) throws IOException {
        if (value instanceof Map) {
            out.writeStartObject();
            try {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    out.writeFieldName((String)entry.getKey());
                    this.write(out, format, entry.getValue());
                }
            }
            finally {
                out.writeEndObject();
            }
        } else if (value instanceof Path) {
            RepresentationBasedMessageBodyWriter.serialize(new PathRepresentation<Path>((Path)value), format, this.baseUri);
        } else if (value instanceof Iterable) {
            out.writeStartArray();
            try {
                for (Object item : (Iterable)value) {
                    this.write(out, format, item);
                }
            }
            finally {
                out.writeEndArray();
            }
        } else if (value instanceof Node) {
            NodeRepresentation representation = new NodeRepresentation((Node)value);
            RepresentationBasedMessageBodyWriter.serialize((Representation)representation, format, this.baseUri);
        } else if (value instanceof Relationship) {
            RelationshipRepresentation representation = new RelationshipRepresentation((Relationship)value);
            RepresentationBasedMessageBodyWriter.serialize((Representation)representation, format, this.baseUri);
        } else {
            format.serializeValue(null, value);
        }
    }

    private static class WriteThroughJsonFormat
    extends RepresentationFormat {
        private final JsonGenerator jsonGenerator;

        WriteThroughJsonFormat(JsonGenerator g) {
            super(MediaType.APPLICATION_JSON_TYPE);
            this.jsonGenerator = g;
        }

        protected String serializeValue(String type, Object value) {
            try {
                this.jsonGenerator.writeObject(value);
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected ListWriter serializeList(String type) {
            return new WriteThroughListWriterImpl(this.jsonGenerator);
        }

        public MappingWriter serializeMapping(String type) {
            return new WriteThroughMappingWriterImpl(this.jsonGenerator);
        }

        protected String complete(ListWriter serializer) {
            this.flush();
            return null;
        }

        protected String complete(MappingWriter serializer) {
            this.flush();
            return null;
        }

        private void flush() {
            try {
                this.jsonGenerator.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void complete() {
            this.flush();
        }
    }

    private static class WriteThroughListWriterImpl
    extends ListWriter {
        private final JsonGenerator jsonGenerator;

        WriteThroughListWriterImpl(JsonGenerator jsonGenerator) {
            this.jsonGenerator = jsonGenerator;
            try {
                jsonGenerator.writeStartArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        WriteThroughListWriterImpl(JsonGenerator g, String key) {
            this.jsonGenerator = g;
            try {
                g.writeArrayFieldStart(key);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public MappingWriter newMapping(String type) {
            return new WriteThroughMappingWriterImpl(this.jsonGenerator);
        }

        public ListWriter newList(String type) {
            return new WriteThroughListWriterImpl(this.jsonGenerator);
        }

        public void writeValue(String type, Object value) {
            try {
                this.jsonGenerator.writeObject(value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void done() {
            try {
                this.jsonGenerator.writeEndArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class WriteThroughMappingWriterImpl
    extends MappingWriter {
        private final JsonGenerator jsonGenerator;

        WriteThroughMappingWriterImpl(JsonGenerator jsonGenerator) {
            this.jsonGenerator = jsonGenerator;
            try {
                jsonGenerator.writeStartObject();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        WriteThroughMappingWriterImpl(JsonGenerator g, String key) {
            this.jsonGenerator = g;
            try {
                g.writeObjectFieldStart(key);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public MappingWriter newMapping(String type, String key) {
            return new WriteThroughMappingWriterImpl(this.jsonGenerator, key);
        }

        public ListWriter newList(String type, String key) {
            return new WriteThroughListWriterImpl(this.jsonGenerator, key);
        }

        public void writeValue(String type, String key, Object value) {
            try {
                this.jsonGenerator.writeObjectField(key, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void done() {
            try {
                this.jsonGenerator.writeEndObject();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

