/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.rest.web.AllowAjaxFilter;
import org.neo4j.server.web.InjectableWrapper;
import org.neo4j.server.web.NeoServletContainer;
import org.neo4j.server.web.XForwardFilter;

public abstract class JaxRsServletHolderFactory {
    private final List<String> items = new ArrayList<String>();
    private final List<Injectable<?>> injectables = new ArrayList();

    public void add(List<String> items, Collection<Injectable<?>> injectableProviders) {
        this.items.addAll(items);
        if (injectableProviders != null) {
            this.injectables.addAll(injectableProviders);
        }
    }

    public void remove(List<String> items) {
        this.items.removeAll(items);
    }

    public ServletHolder create(Collection<InjectableProvider<?>> defaultInjectables, boolean wadlEnabled) {
        Collection<InjectableProvider<?>> injectableProviders = this.mergeInjectables(defaultInjectables, this.injectables);
        NeoServletContainer container = new NeoServletContainer(injectableProviders);
        ServletHolder servletHolder = new ServletHolder((Servlet)container);
        servletHolder.setInitParameter("com.sun.jersey.config.feature.DisableWADL", String.valueOf(!wadlEnabled));
        this.configure(servletHolder, this.toCommaSeparatedList(this.items));
        servletHolder.setInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", AllowAjaxFilter.class.getName());
        servletHolder.setInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", this.getRequestFilterConfig());
        return servletHolder;
    }

    private String getRequestFilterConfig() {
        return XForwardFilter.class.getName();
    }

    protected abstract void configure(ServletHolder var1, String var2);

    private Collection<InjectableProvider<?>> mergeInjectables(Collection<InjectableProvider<?>> defaultInjectables, Collection<Injectable<?>> injectables) {
        ArrayList injectableProviders = new ArrayList();
        if (defaultInjectables != null) {
            injectableProviders.addAll(defaultInjectables);
        }
        if (injectables != null) {
            for (Injectable<?> injectable : injectables) {
                injectableProviders.add(new InjectableWrapper(injectable));
            }
        }
        return injectableProviders;
    }

    private String toCommaSeparatedList(List<String> packageNames) {
        StringBuilder sb = new StringBuilder();
        for (String str : packageNames) {
            sb.append(str);
            sb.append(", ");
        }
        String result = sb.toString();
        return result.substring(0, result.length() - 2);
    }

    public static class Classes
    extends JaxRsServletHolderFactory {
        @Override
        protected void configure(ServletHolder servletHolder, String classes) {
            servletHolder.setInitParameter("com.sun.jersey.config.property.classnames", classes);
        }
    }

    public static class Packages
    extends JaxRsServletHolderFactory {
        @Override
        protected void configure(ServletHolder servletHolder, String packages) {
            servletHolder.setInitParameter("com.sun.jersey.config.property.packages", packages);
        }
    }
}

