/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class WhiteListJavaWrapper
extends WrapFactory {
    private final ClassShutter classShutter;

    public WhiteListJavaWrapper(ClassShutter classShutter) {
        this.classShutter = classShutter;
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
        if (javaObject instanceof ClassLoader) {
            throw new SecurityException("Class loaders cannot be accessed in this environment.");
        }
        String name = null;
        if (javaObject instanceof Class) {
            name = ((Class)javaObject).getName();
        } else if (javaObject instanceof Member) {
            Member member = (Member)javaObject;
            if (!Modifier.isPublic(member.getModifiers())) {
                return null;
            }
            name = member.getDeclaringClass().getName();
        }
        if (name != null) {
            if (!this.classShutter.visibleToScripts(name)) {
                throw new SecurityException("'" + name + "' cannot be accessed in this environment.");
            }
            return new NativeJavaObject(scope, javaObject, (Class)staticType);
        }
        Class<?> dynamicType = javaObject.getClass();
        String name2 = dynamicType.getName();
        if (!this.classShutter.visibleToScripts(name2)) {
            Class<?> type = null;
            if (staticType != null && staticType.isInterface()) {
                type = staticType;
            } else {
                while ((dynamicType = dynamicType.getSuperclass()) != null) {
                    name2 = dynamicType.getName();
                    if (!this.classShutter.visibleToScripts(name2)) continue;
                    type = dynamicType;
                    break;
                }
                assert (type != null) : "even java.lang.Object is not accessible?";
            }
            return new JavascriptJavaObject(scope, javaObject, type);
        }
        return new NativeJavaObject(scope, javaObject, (Class)staticType);
    }

    public static class JavascriptJavaObject
    extends NativeJavaObject {
        public JavascriptJavaObject(Scriptable scope, Object javaObject, Class type) {
            super(scope, null, type);
            this.javaObject = javaObject;
        }
    }
}

