/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.primitives;

import java.util.NoSuchElementException;
import lombok.NonNull;

public class Optional<T> {
    private static final Optional EMPTY = new Optional();
    private final T value;

    private Optional() {
        this(null);
    }

    private Optional(T value) {
        this.value = value;
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public static <T> Optional<T> of(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (value == null) {
            return Optional.empty();
        }
        return new Optional<T>(value);
    }

    public T get() {
        if (!this.isPresent()) {
            throw new NoSuchElementException("Optional is empty");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T orElse(T other) {
        if (this.isPresent()) {
            return this.get();
        }
        return other;
    }

    public String toString() {
        if (this.isPresent()) {
            return "Optional(" + this.value.toString() + ")";
        }
        return "Optional()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Optional;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

