/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.config;

import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ND4JClassLoading {
    private static final Logger log = LoggerFactory.getLogger(ND4JClassLoading.class);
    private static ClassLoader nd4jClassloader = Thread.currentThread().getContextClassLoader();

    private ND4JClassLoading() {
    }

    public static ClassLoader getNd4jClassloader() {
        return nd4jClassloader;
    }

    public static void setNd4jClassloaderFromClass(Class<?> clazz) {
        ND4JClassLoading.setNd4jClassloader(clazz.getClassLoader());
    }

    public static void setNd4jClassloader(ClassLoader nd4jClassloader) {
        ND4JClassLoading.nd4jClassloader = nd4jClassloader;
        log.debug("Global class-loader for ND4J was changed.");
    }

    public static boolean classPresentOnClasspath(String className) {
        return ND4JClassLoading.classPresentOnClasspath(className, nd4jClassloader);
    }

    public static boolean classPresentOnClasspath(String className, ClassLoader classLoader) {
        return ND4JClassLoading.loadClassByName(className, false, classLoader) != null;
    }

    public static <T> Class<T> loadClassByName(String className) {
        return ND4JClassLoading.loadClassByName(className, true, nd4jClassloader);
    }

    public static <T> Class<T> loadClassByName(String className, boolean initialize, ClassLoader classLoader) {
        try {
            return Class.forName(className, initialize, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.trace(String.format("Cannot find class [%s] of provided class-loader.", className));
            return null;
        }
    }

    public static <S> ServiceLoader<S> loadService(Class<S> serviceClass) {
        return ND4JClassLoading.loadService(serviceClass, nd4jClassloader);
    }

    public static <S> ServiceLoader<S> loadService(Class<S> serviceClass, ClassLoader classLoader) {
        return ServiceLoader.load(serviceClass, classLoader);
    }
}

