/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"allKeysSorted"})
public class MapSchedule
implements ISchedule {
    private ScheduleType scheduleType;
    private Map<Integer, Double> values;
    private int[] allKeysSorted;

    public MapSchedule(@JsonProperty(value="scheduleType") @NonNull ScheduleType scheduleType, @JsonProperty(value="values") @NonNull Map<Integer, Double> values) {
        if (scheduleType == null) {
            throw new NullPointerException("scheduleType is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (!values.containsKey(0)) {
            throw new IllegalArgumentException("Invalid set of values: must contain initial value (position 0)");
        }
        this.scheduleType = scheduleType;
        this.values = values;
        this.allKeysSorted = new int[values.size()];
        int pos = 0;
        for (Integer i : values.keySet()) {
            this.allKeysSorted[pos++] = i;
        }
        Arrays.sort(this.allKeysSorted);
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        int i;
        int n = i = this.scheduleType == ScheduleType.ITERATION ? iteration : epoch;
        if (this.values.containsKey(i)) {
            return this.values.get(i);
        }
        if (i >= this.allKeysSorted[this.allKeysSorted.length - 1]) {
            return this.values.get(this.allKeysSorted[this.allKeysSorted.length - 1]);
        }
        int pt = Arrays.binarySearch(this.allKeysSorted, i);
        int iPt = -(pt + 1);
        double d = this.values.get(this.allKeysSorted[iPt - 1]);
        return d;
    }

    @Override
    public ISchedule clone() {
        return new MapSchedule(this.scheduleType, this.values);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public Map<Integer, Double> getValues() {
        return this.values;
    }

    public int[] getAllKeysSorted() {
        return this.allKeysSorted;
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setValues(Map<Integer, Double> values) {
        this.values = values;
    }

    public void setAllKeysSorted(int[] allKeysSorted) {
        this.allKeysSorted = allKeysSorted;
    }

    public String toString() {
        return "MapSchedule(scheduleType=" + (Object)((Object)this.getScheduleType()) + ", values=" + this.getValues() + ", allKeysSorted=" + Arrays.toString(this.getAllKeysSorted()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapSchedule)) {
            return false;
        }
        MapSchedule other = (MapSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !((Object)((Object)this$scheduleType)).equals((Object)other$scheduleType)) {
            return false;
        }
        Map<Integer, Double> this$values = this.getValues();
        Map<Integer, Double> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        return Arrays.equals(this.getAllKeysSorted(), other.getAllKeysSorted());
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapSchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)((Object)$scheduleType)).hashCode());
        Map<Integer, Double> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        result = result * 59 + Arrays.hashCode(this.getAllKeysSorted());
        return result;
    }

    public static class Builder {
        private ScheduleType scheduleType;
        private Map<Integer, Double> values = new HashMap<Integer, Double>();

        public Builder(ScheduleType scheduleType) {
            this.scheduleType = scheduleType;
        }

        public Builder add(int position, double value) {
            this.values.put(position, value);
            return this;
        }

        public MapSchedule build() {
            return new MapSchedule(this.scheduleType, this.values);
        }
    }
}

