/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.util.Arrays;
import java.util.Map;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.AdamUpdater;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Adam
implements IUpdater {
    public static final double DEFAULT_ADAM_LEARNING_RATE = 0.001;
    public static final double DEFAULT_ADAM_EPSILON = 1.0E-8;
    public static final double DEFAULT_ADAM_BETA1_MEAN_DECAY = 0.9;
    public static final double DEFAULT_ADAM_BETA2_VAR_DECAY = 0.999;
    private double learningRate;
    private ISchedule learningRateSchedule;
    private double beta1;
    private double beta2;
    private double epsilon;

    public Adam() {
        this(0.001, 0.9, 0.999, 1.0E-8);
    }

    public Adam(double learningRate) {
        this(learningRate, null, 0.9, 0.999, 1.0E-8);
    }

    public Adam(ISchedule learningRateSchedule) {
        this(Double.NaN, learningRateSchedule, 0.9, 0.999, 1.0E-8);
    }

    public Adam(double learningRate, double beta1, double beta2, double epsilon) {
        this(learningRate, null, beta1, beta2, epsilon);
    }

    private Adam(@JsonProperty(value="learningRate") double learningRate, @JsonProperty(value="learningRateSchedule") ISchedule learningRateSchedule, @JsonProperty(value="beta1") double beta1, @JsonProperty(value="beta2") double beta2, @JsonProperty(value="epsilon") double epsilon) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
    }

    @Override
    public long stateSize(long numParams) {
        return 2L * numParams;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        AdamUpdater u = new AdamUpdater(this);
        long[] gradientShape = viewArray.shape();
        gradientShape = Arrays.copyOf(gradientShape, gradientShape.length);
        gradientShape[1] = gradientShape[1] / 2L;
        u.setStateViewArray(viewArray, gradientShape, viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public GradientUpdater instantiate(Map<String, INDArray> updaterState, boolean initializeStateArrays) {
        AdamUpdater u = new AdamUpdater(this);
        u.setState(updaterState, initializeStateArrays);
        return u;
    }

    @Override
    public Adam clone() {
        return new Adam(this.learningRate, this.learningRateSchedule, this.beta1, this.beta2, this.epsilon);
    }

    @Override
    public double getLearningRate(int iteration, int epoch) {
        if (this.learningRateSchedule != null) {
            return this.learningRateSchedule.valueAt(iteration, epoch);
        }
        return this.learningRate;
    }

    @Override
    public boolean hasLearningRate() {
        return true;
    }

    @Override
    public void setLrAndSchedule(double lr, ISchedule lrSchedule) {
        this.learningRate = lr;
        this.learningRateSchedule = lrSchedule;
    }

    private static double $default$learningRate() {
        return 0.001;
    }

    private static double $default$beta1() {
        return 0.9;
    }

    private static double $default$beta2() {
        return 0.999;
    }

    private static double $default$epsilon() {
        return 1.0E-8;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public ISchedule getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public double getBeta1() {
        return this.beta1;
    }

    public double getBeta2() {
        return this.beta2;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ISchedule learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setBeta1(double beta1) {
        this.beta1 = beta1;
    }

    public void setBeta2(double beta2) {
        this.beta2 = beta2;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adam)) {
            return false;
        }
        Adam other = (Adam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta1(), other.getBeta1()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta2(), other.getBeta2()) != 0) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        ISchedule this$learningRateSchedule = this.getLearningRateSchedule();
        ISchedule other$learningRateSchedule = other.getLearningRateSchedule();
        return !(this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Adam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $beta1 = Double.doubleToLongBits(this.getBeta1());
        result = result * 59 + (int)($beta1 >>> 32 ^ $beta1);
        long $beta2 = Double.doubleToLongBits(this.getBeta2());
        result = result * 59 + (int)($beta2 >>> 32 ^ $beta2);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        ISchedule $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        return result;
    }

    public String toString() {
        return "Adam(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", beta1=" + this.getBeta1() + ", beta2=" + this.getBeta2() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public static class Builder {
        private boolean learningRate$set;
        private double learningRate$value;
        private ISchedule learningRateSchedule;
        private boolean beta1$set;
        private double beta1$value;
        private boolean beta2$set;
        private double beta2$value;
        private boolean epsilon$set;
        private double epsilon$value;

        public Builder learningRate(double learningRate) {
            this.learningRate$value = learningRate;
            this.learningRate$set = true;
            return this;
        }

        public Builder learningRateSchedule(ISchedule learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder beta1(double beta1) {
            this.beta1$value = beta1;
            this.beta1$set = true;
            return this;
        }

        public Builder beta2(double beta2) {
            this.beta2$value = beta2;
            this.beta2$set = true;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon$value = epsilon;
            this.epsilon$set = true;
            return this;
        }

        public Adam build() {
            double learningRate$value = this.learningRate$value;
            if (!this.learningRate$set) {
                learningRate$value = Adam.$default$learningRate();
            }
            double beta1$value = this.beta1$value;
            if (!this.beta1$set) {
                beta1$value = Adam.$default$beta1();
            }
            double beta2$value = this.beta2$value;
            if (!this.beta2$set) {
                beta2$value = Adam.$default$beta2();
            }
            double epsilon$value = this.epsilon$value;
            if (!this.epsilon$set) {
                epsilon$value = Adam.$default$epsilon();
            }
            return new Adam(learningRate$value, this.learningRateSchedule, beta1$value, beta2$value, epsilon$value);
        }

        public String toString() {
            return "Adam.Builder(learningRate$value=" + this.learningRate$value + ", learningRateSchedule=" + this.learningRateSchedule + ", beta1$value=" + this.beta1$value + ", beta2$value=" + this.beta2$value + ", epsilon$value=" + this.epsilon$value + ")";
        }
    }
}

