/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class OnesAs
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(OnesAs.class);
    protected DataType outputType;

    public OnesAs() {
    }

    public OnesAs(SameDiff sameDiff, SDVariable input) {
        this(null, sameDiff, input);
    }

    public OnesAs(String name, SameDiff sameDiff, SDVariable input) {
        this(name, sameDiff, input, input.dataType());
    }

    public OnesAs(SameDiff sameDiff, SDVariable input, DataType dataType) {
        this(null, sameDiff, input, dataType);
    }

    public OnesAs(String name, SameDiff sameDiff, SDVariable input, DataType dataType) {
        super(name, sameDiff, new SDVariable[]{input}, false);
        this.outputType = dataType;
        this.addArgs();
    }

    public OnesAs(@NonNull INDArray input, DataType dataType) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.addInputArgument(input);
        this.outputType = dataType;
        this.addArgs();
    }

    public OnesAs(@NonNull INDArray input) {
        this(input, input.dataType());
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
    }

    public void addArgs() {
        if (this.outputType != null) {
            this.addDArgument(this.outputType);
        }
    }

    @Override
    public String opName() {
        return "ones_as";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No op found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Ones";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("T")) {
            this.outputType = TFGraphMapper.convertType(attributesForNode.get("T").getType());
        }
        this.addArgs();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret = this.sameDiff.zerosLike(this.outputVariables()[0]);
        return Arrays.asList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected list with exactly 1 datatype for %s, got %s", this.getClass(), dataTypes);
        if (this.outputType != null) {
            return Collections.singletonList(this.outputType);
        }
        return dataTypes;
    }
}

