/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.util.ConvConfigUtil;

public class LocalResponseNormalizationConfig
extends BaseConvolutionConfig {
    private double alpha;
    private double beta;
    private double bias;
    private int depth;

    public LocalResponseNormalizationConfig(double alpha, double beta, double bias, int depth) {
        this.alpha = alpha;
        this.beta = beta;
        this.bias = bias;
        this.depth = depth;
        this.validate();
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("alpha", this.alpha);
        ret.put("beta", this.beta);
        ret.put("bias", this.bias);
        ret.put("depth", this.depth);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validateLRN(this.alpha, this.beta, this.bias, this.depth);
    }

    public static LocalResponseNormalizationConfigBuilder builder() {
        return new LocalResponseNormalizationConfigBuilder();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getBias() {
        return this.bias;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalResponseNormalizationConfig)) {
            return false;
        }
        LocalResponseNormalizationConfig other = (LocalResponseNormalizationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta(), other.getBeta()) != 0) {
            return false;
        }
        if (Double.compare(this.getBias(), other.getBias()) != 0) {
            return false;
        }
        return this.getDepth() == other.getDepth();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalResponseNormalizationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        long $beta = Double.doubleToLongBits(this.getBeta());
        result = result * 59 + (int)($beta >>> 32 ^ $beta);
        long $bias = Double.doubleToLongBits(this.getBias());
        result = result * 59 + (int)($bias >>> 32 ^ $bias);
        result = result * 59 + this.getDepth();
        return result;
    }

    public String toString() {
        return "LocalResponseNormalizationConfig(alpha=" + this.getAlpha() + ", beta=" + this.getBeta() + ", bias=" + this.getBias() + ", depth=" + this.getDepth() + ")";
    }

    public LocalResponseNormalizationConfig() {
    }

    public static class LocalResponseNormalizationConfigBuilder {
        private double alpha;
        private double beta;
        private double bias;
        private int depth;

        LocalResponseNormalizationConfigBuilder() {
        }

        public LocalResponseNormalizationConfigBuilder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public LocalResponseNormalizationConfigBuilder beta(double beta) {
            this.beta = beta;
            return this;
        }

        public LocalResponseNormalizationConfigBuilder bias(double bias) {
            this.bias = bias;
            return this;
        }

        public LocalResponseNormalizationConfigBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public LocalResponseNormalizationConfig build() {
            return new LocalResponseNormalizationConfig(this.alpha, this.beta, this.bias, this.depth);
        }

        public String toString() {
            return "LocalResponseNormalizationConfig.LocalResponseNormalizationConfigBuilder(alpha=" + this.alpha + ", beta=" + this.beta + ", bias=" + this.bias + ", depth=" + this.depth + ")";
        }
    }
}

